/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sevenzipjbinding.impl;

import net.sf.sevenzipjbinding.ArchiveFormat;
import net.sf.sevenzipjbinding.ExtractAskMode;
import net.sf.sevenzipjbinding.ExtractOperationResult;
import net.sf.sevenzipjbinding.IArchiveExtractCallback;
import net.sf.sevenzipjbinding.ICryptoGetTextPassword;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.IOutItemAllFormats;
import net.sf.sevenzipjbinding.IOutItemBase;
import net.sf.sevenzipjbinding.IOutUpdateArchive;
import net.sf.sevenzipjbinding.IOutUpdateArchive7z;
import net.sf.sevenzipjbinding.IOutUpdateArchiveBZip2;
import net.sf.sevenzipjbinding.IOutUpdateArchiveGZip;
import net.sf.sevenzipjbinding.IOutUpdateArchiveTar;
import net.sf.sevenzipjbinding.IOutUpdateArchiveZip;
import net.sf.sevenzipjbinding.ISequentialOutStream;
import net.sf.sevenzipjbinding.NFileTimeType;
import net.sf.sevenzipjbinding.PropID;
import net.sf.sevenzipjbinding.PropertyInfo;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.OutArchiveImpl;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.impl.SimpleInArchiveImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InArchiveImpl
implements IInArchive {
    private long jbindingSession;
    private long sevenZipArchiveInstance;
    private long sevenZipInStreamInstance;
    private OutArchiveImpl<?> outArchiveImpl;
    private int numberOfItems = -1;
    private ArchiveFormat archiveFormat;

    @Override
    public void extract(int[] nArray, boolean bl, IArchiveExtractCallback iArchiveExtractCallback) throws SevenZipException {
        this.nativeExtract(nArray, bl, iArchiveExtractCallback);
    }

    @Override
    public ExtractOperationResult extractSlow(int n, ISequentialOutStream iSequentialOutStream) throws SevenZipException {
        ExtractSlowCallback extractSlowCallback = new ExtractSlowCallback(iSequentialOutStream);
        this.nativeExtract(new int[]{n}, false, extractSlowCallback);
        return extractSlowCallback.getExtractOperationResult();
    }

    @Override
    public ExtractOperationResult extractSlow(int n, ISequentialOutStream iSequentialOutStream, String string) throws SevenZipException {
        ExtractSlowCryptoCallback extractSlowCryptoCallback = new ExtractSlowCryptoCallback(iSequentialOutStream, string);
        this.nativeExtract(new int[]{n}, false, extractSlowCryptoCallback);
        return extractSlowCryptoCallback.getExtractOperationResult();
    }

    private native void nativeExtract(int[] var1, boolean var2, IArchiveExtractCallback var3) throws SevenZipException;

    private native Object nativeGetArchiveProperty(int var1) throws SevenZipException;

    @Override
    public Object getArchiveProperty(PropID propID) throws SevenZipException {
        return this.nativeGetArchiveProperty(propID.getPropIDIndex());
    }

    private native String nativeGetStringArchiveProperty(int var1) throws SevenZipException;

    @Override
    public String getStringArchiveProperty(PropID propID) throws SevenZipException {
        return this.nativeGetStringArchiveProperty(propID.getPropIDIndex());
    }

    private native PropertyInfo nativeGetArchivePropertyInfo(int var1) throws SevenZipException;

    @Override
    public PropertyInfo getArchivePropertyInfo(int n) throws SevenZipException {
        return this.nativeGetArchivePropertyInfo(n);
    }

    private native int nativeGetNumberOfArchiveProperties() throws SevenZipException;

    @Override
    public int getNumberOfArchiveProperties() throws SevenZipException {
        return this.nativeGetNumberOfArchiveProperties();
    }

    private native int nativeGetNumberOfProperties() throws SevenZipException;

    @Override
    public int getNumberOfProperties() throws SevenZipException {
        return this.nativeGetNumberOfProperties();
    }

    private native PropertyInfo nativeGetPropertyInfo(int var1) throws SevenZipException;

    @Override
    public PropertyInfo getPropertyInfo(int n) throws SevenZipException {
        return this.nativeGetPropertyInfo(n);
    }

    private native void nativeClose() throws SevenZipException;

    @Override
    public void close() throws SevenZipException {
        this.nativeClose();
    }

    private native int nativeGetNumberOfItems() throws SevenZipException;

    @Override
    public int getNumberOfItems() throws SevenZipException {
        if (this.numberOfItems == -1) {
            this.numberOfItems = this.nativeGetNumberOfItems();
        }
        return this.numberOfItems;
    }

    private native Object nativeGetProperty(int var1, int var2) throws SevenZipException;

    @Override
    public Object getProperty(int n, PropID propID) throws SevenZipException {
        if (n < 0 || n >= this.getNumberOfItems()) {
            throw new SevenZipException("Index out of range. Index: " + n + ", NumberOfItems: " + this.getNumberOfItems());
        }
        Object object = this.nativeGetProperty(n, propID.getPropIDIndex());
        switch (propID) {
            case SIZE: 
            case PACKED_SIZE: {
                if (object instanceof Integer) {
                    return ((Integer)object).longValue();
                }
                if (object != null || this.archiveFormat == null || this.archiveFormat != ArchiveFormat.NSIS) break;
                return 0L;
            }
            case IS_FOLDER: {
                if (object != null) break;
                return Boolean.FALSE;
            }
            case ENCRYPTED: {
                if (object != null) break;
                return Boolean.FALSE;
            }
            case TIME_TYPE: {
                if (object == null) break;
                return NFileTimeType.values()[(Integer)object];
            }
        }
        return object;
    }

    private native String nativeGetStringProperty(int var1, int var2) throws SevenZipException;

    @Override
    public String getStringProperty(int n, PropID propID) throws SevenZipException {
        if (n < 0 || n >= this.getNumberOfItems()) {
            throw new SevenZipException("Index out of range. Index: " + n + ", NumberOfItems: " + this.getNumberOfItems());
        }
        return this.nativeGetStringProperty(n, propID.getPropIDIndex());
    }

    @Override
    public ISimpleInArchive getSimpleInterface() {
        return new SimpleInArchiveImpl(this);
    }

    @Override
    public ArchiveFormat getArchiveFormat() {
        return this.archiveFormat;
    }

    private void setArchiveFormat(String string) {
        for (ArchiveFormat archiveFormat : ArchiveFormat.values()) {
            if (!archiveFormat.getMethodName().equalsIgnoreCase(string)) continue;
            this.archiveFormat = archiveFormat;
            return;
        }
    }

    @Override
    public IOutUpdateArchive<IOutItemAllFormats> getConnectedOutArchive() throws SevenZipException {
        return this.getConnectedOutArchiveIntern();
    }

    private <T extends IOutItemBase> IOutUpdateArchive<T> getConnectedOutArchiveIntern() throws SevenZipException {
        if (this.outArchiveImpl == null) {
            this.createConnectedOutArchive();
        }
        return this.outArchiveImpl;
    }

    @Override
    public IOutUpdateArchive7z getConnectedOutArchive7z() throws SevenZipException {
        this.ensureArchiveFormatForArchiveFormatSpecificUpdateAPI(ArchiveFormat.SEVEN_ZIP);
        return (IOutUpdateArchive7z)this.getConnectedOutArchiveIntern();
    }

    @Override
    public IOutUpdateArchiveZip getConnectedOutArchiveZip() throws SevenZipException {
        this.ensureArchiveFormatForArchiveFormatSpecificUpdateAPI(ArchiveFormat.ZIP);
        return (IOutUpdateArchiveZip)this.getConnectedOutArchiveIntern();
    }

    @Override
    public IOutUpdateArchiveTar getConnectedOutArchiveTar() throws SevenZipException {
        this.ensureArchiveFormatForArchiveFormatSpecificUpdateAPI(ArchiveFormat.TAR);
        return (IOutUpdateArchiveTar)this.getConnectedOutArchiveIntern();
    }

    @Override
    public IOutUpdateArchiveGZip getConnectedOutArchiveGZip() throws SevenZipException {
        this.ensureArchiveFormatForArchiveFormatSpecificUpdateAPI(ArchiveFormat.GZIP);
        return (IOutUpdateArchiveGZip)this.getConnectedOutArchiveIntern();
    }

    @Override
    public IOutUpdateArchiveBZip2 getConnectedOutArchiveBZip2() throws SevenZipException {
        this.ensureArchiveFormatForArchiveFormatSpecificUpdateAPI(ArchiveFormat.BZIP2);
        return (IOutUpdateArchiveBZip2)this.getConnectedOutArchiveIntern();
    }

    private void ensureArchiveFormatForArchiveFormatSpecificUpdateAPI(ArchiveFormat archiveFormat) throws SevenZipException {
        if (this.getArchiveFormat() != archiveFormat) {
            throw new SevenZipException("Archive format specific update API for " + archiveFormat.getMethodName() + "-archives can't work with the currently opened " + this.getArchiveFormat().getMethodName() + "-archive");
        }
    }

    private void createConnectedOutArchive() throws SevenZipException {
        if (!this.archiveFormat.isOutArchiveSupported()) {
            throw new IllegalStateException("Archive format '" + (Object)((Object)this.archiveFormat) + "' doesn't support archive manipulations.");
        }
        try {
            this.outArchiveImpl = this.archiveFormat.getOutArchiveImplementation().newInstance();
        }
        catch (Exception exception) {
            throw new IllegalStateException("Internal error: Can't create new instance of the class " + this.archiveFormat.getOutArchiveImplementation() + " using default constructor.");
        }
        this.outArchiveImpl.setInArchive(this);
        this.outArchiveImpl.setArchiveFormat(this.archiveFormat);
        this.nativeConnectOutArchive(this.outArchiveImpl, this.archiveFormat);
    }

    private native void nativeConnectOutArchive(OutArchiveImpl<?> var1, ArchiveFormat var2) throws SevenZipException;

    private static final class ExtractSlowCryptoCallback
    extends ExtractSlowCallback
    implements ICryptoGetTextPassword {
        private String password;

        public ExtractSlowCryptoCallback(ISequentialOutStream iSequentialOutStream, String string) {
            super(iSequentialOutStream);
            this.password = string;
        }

        public String cryptoGetTextPassword() throws SevenZipException {
            return this.password;
        }
    }

    private static class ExtractSlowCallback
    implements IArchiveExtractCallback {
        ISequentialOutStream sequentialOutStreamParam;
        private ExtractOperationResult extractOperationResult;

        ExtractSlowCallback(ISequentialOutStream iSequentialOutStream) {
            this.sequentialOutStreamParam = iSequentialOutStream;
        }

        public void setTotal(long l) {
        }

        public void setCompleted(long l) {
        }

        public void setOperationResult(ExtractOperationResult extractOperationResult) {
            this.extractOperationResult = extractOperationResult;
        }

        public void prepareOperation(ExtractAskMode extractAskMode) {
        }

        public ISequentialOutStream getStream(int n, ExtractAskMode extractAskMode) {
            return extractAskMode.equals((Object)ExtractAskMode.EXTRACT) ? this.sequentialOutStreamParam : null;
        }

        ExtractOperationResult getExtractOperationResult() {
            return this.extractOperationResult;
        }
    }
}

