/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.lzss;

import ghidra.file.formats.lzss.LzssConstants;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import java.util.Arrays;

public class LzssUtil {
    public static final boolean isLZSS(Program program) {
        byte[] formatBytes;
        byte[] compressionBytes;
        Address address;
        return program != null && (address = program.getMinAddress()) != null && Arrays.equals(compressionBytes = LzssUtil.getBytes(program, address), LzssConstants.SIGNATURE_COMPRESSION_BYTES) && Arrays.equals(formatBytes = LzssUtil.getBytes(program, address.add((long)compressionBytes.length)), LzssConstants.SIGNATURE_LZSS_BYTES);
    }

    private static byte[] getBytes(Program program, Address address) {
        byte[] bytes = new byte[4];
        try {
            program.getMemory().getBytes(address, bytes);
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return bytes;
    }
}

