/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.img3.tag;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.ios.img3.AbstractImg3Tag;
import ghidra.file.formats.ios.img3.tag.BdidTag;
import ghidra.file.formats.ios.img3.tag.BoardTag;
import ghidra.file.formats.ios.img3.tag.CertficateTag;
import ghidra.file.formats.ios.img3.tag.ChipTag;
import ghidra.file.formats.ios.img3.tag.DataTag;
import ghidra.file.formats.ios.img3.tag.ExclusiveChipTag;
import ghidra.file.formats.ios.img3.tag.KBagTag;
import ghidra.file.formats.ios.img3.tag.ProductionModeTag;
import ghidra.file.formats.ios.img3.tag.RsaShaTag;
import ghidra.file.formats.ios.img3.tag.ScepTag;
import ghidra.file.formats.ios.img3.tag.SecurityDomainTag;
import ghidra.file.formats.ios.img3.tag.SecurityEpochTag;
import ghidra.file.formats.ios.img3.tag.TypeTag;
import ghidra.file.formats.ios.img3.tag.UnknownTag;
import ghidra.file.formats.ios.img3.tag.VersionTag;
import ghidra.util.StringUtilities;
import java.io.IOException;

public final class Img3TagFactory {
    public static final AbstractImg3Tag get(BinaryReader reader) throws IOException {
        String tag = StringUtilities.toString((int)reader.peekNextInt());
        if (tag != null && tag.length() != 0) {
            if (tag.equals("BDID")) {
                return new BdidTag(reader);
            }
            if (tag.equals("BORD")) {
                return new BoardTag(reader);
            }
            if (tag.equals("CERT")) {
                return new CertficateTag(reader);
            }
            if (tag.equals("CHIP")) {
                return new ChipTag(reader);
            }
            if (tag.equals("DATA")) {
                return new DataTag(reader);
            }
            if (tag.equals("ECID")) {
                return new ExclusiveChipTag(reader);
            }
            if (tag.equals("KBAG")) {
                return new KBagTag(reader);
            }
            if (tag.equals("PROD")) {
                return new ProductionModeTag(reader);
            }
            if (tag.equals("SCEP")) {
                return new ScepTag(reader);
            }
            if (tag.equals("SDOM")) {
                return new SecurityDomainTag(reader);
            }
            if (tag.equals("SEPO")) {
                return new SecurityEpochTag(reader);
            }
            if (tag.equals("SHSH")) {
                return new RsaShaTag(reader);
            }
            if (tag.equals("TYPE")) {
                return new TypeTag(reader);
            }
            if (tag.equals("VERS")) {
                return new VersionTag(reader);
            }
        }
        return new UnknownTag(reader);
    }
}

