/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.ir;

import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.elasticsearch.painless.ClassWriter;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.ScriptClassInfo;
import org.elasticsearch.painless.WriterConstants;
import org.elasticsearch.painless.ir.BlockNode;
import org.elasticsearch.painless.ir.FieldNode;
import org.elasticsearch.painless.ir.FunctionNode;
import org.elasticsearch.painless.ir.IRNode;
import org.elasticsearch.painless.phase.IRTreeVisitor;
import org.elasticsearch.painless.symbol.ScriptScope;
import org.elasticsearch.painless.symbol.WriteScope;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.Printer;

public class ClassNode
extends IRNode {
    private final List<FieldNode> fieldNodes = new ArrayList<FieldNode>();
    private final List<FunctionNode> functionNodes = new ArrayList<FunctionNode>();
    private final BlockNode clinitBlockNode = new BlockNode(new Location("internal$clinit$blocknode", 0));
    private Printer debugStream;
    private ScriptScope scriptScope;

    public void addFieldNode(FieldNode fieldNode) {
        this.fieldNodes.add(fieldNode);
    }

    public List<FieldNode> getFieldsNodes() {
        return this.fieldNodes;
    }

    public void addFunctionNode(FunctionNode functionNode) {
        this.functionNodes.add(functionNode);
    }

    public List<FunctionNode> getFunctionsNodes() {
        return this.functionNodes;
    }

    public BlockNode getClinitBlockNode() {
        return this.clinitBlockNode;
    }

    public void setDebugStream(Printer debugStream) {
        this.debugStream = debugStream;
    }

    public Printer getDebugStream() {
        return this.debugStream;
    }

    public void setScriptScope(ScriptScope scriptScope) {
        this.scriptScope = scriptScope;
    }

    public ScriptScope getScriptScope() {
        return this.scriptScope;
    }

    @Override
    public <Scope> void visit(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        irTreeVisitor.visitClass(this, scope);
    }

    @Override
    public <Scope> void visitChildren(IRTreeVisitor<Scope> irTreeVisitor, Scope scope) {
        this.clinitBlockNode.visit(irTreeVisitor, scope);
        for (FunctionNode functionNode : this.functionNodes) {
            functionNode.visit(irTreeVisitor, scope);
        }
    }

    public ClassNode(Location location) {
        super(location);
        this.clinitBlockNode.setAllEscape(true);
    }

    public byte[] write() {
        ScriptClassInfo scriptClassInfo = this.scriptScope.getScriptClassInfo();
        BitSet statements = new BitSet(this.scriptScope.getScriptSource().length());
        this.scriptScope.addStaticConstant("$STATEMENTS", statements);
        int classFrames = 3;
        int classAccess = 49;
        String interfaceBase = WriterConstants.BASE_INTERFACE_TYPE.getInternalName();
        String className = WriterConstants.CLASS_TYPE.getInternalName();
        String[] classInterfaces = new String[]{interfaceBase};
        ClassWriter classWriter = new ClassWriter(this.scriptScope.getCompilerSettings(), statements, this.debugStream, scriptClassInfo.getBaseClass(), classFrames, classAccess, className, classInterfaces);
        ClassVisitor classVisitor = classWriter.getClassVisitor();
        classVisitor.visitSource(Location.computeSourceName(this.scriptScope.getScriptName()), null);
        Method init = scriptClassInfo.getBaseClass().getConstructors().length == 0 ? new Method("<init>", MethodType.methodType(Void.TYPE).toMethodDescriptorString()) : new Method("<init>", MethodType.methodType(Void.TYPE, scriptClassInfo.getBaseClass().getConstructors()[0].getParameterTypes()).toMethodDescriptorString());
        MethodWriter constructor = classWriter.newMethodWriter(1, init);
        constructor.visitCode();
        constructor.loadThis();
        constructor.loadArgs();
        constructor.invokeConstructor(Type.getType(scriptClassInfo.getBaseClass()), init);
        constructor.returnValue();
        constructor.endMethod();
        if (!this.clinitBlockNode.getStatementsNodes().isEmpty()) {
            MethodWriter methodWriter = classWriter.newMethodWriter(9, new Method("<clinit>", Type.getType(Void.TYPE), new Type[0]));
            this.clinitBlockNode.write(classWriter, methodWriter, new WriteScope());
            methodWriter.returnValue();
            methodWriter.endMethod();
        }
        for (FieldNode fieldNode : this.fieldNodes) {
            fieldNode.write(classWriter, null, null);
        }
        for (FunctionNode functionNode : this.functionNodes) {
            functionNode.write(classWriter, null, new WriteScope());
        }
        classVisitor.visitEnd();
        return classWriter.getClassBytes();
    }

    @Override
    public void write(ClassWriter classWriter, MethodWriter methodWriter, WriteScope writeScope) {
        throw new UnsupportedOperationException("use write() instead");
    }
}

