import{i18n as e}from"../i18n/i18n.js";import{NumberUtilities as t,StringUtilities as i}from"../platform/platform.js";import{OverlayModel as s,LayerTreeBase as r}from"../sdk/sdk.js";import{Widget as n,EmptyWidget as o,UIUtils as a,ARIAUtils as l,TreeOutline as h,ContextMenu as c,Toolbar as d,ShortcutRegistry as _,Geometry as u,XLink as p,ThrottledWidget as m}from"../ui/ui.js";import{Settings as g,ObjectWrapper as y,Throttler as f}from"../common/common.js";import{PieChart as w,OverviewGrid as v}from"../perf_ui/perf_ui.js";const C={showInternalLayers:"Show internal layers"},S=e.registerUIStrings("layer_viewer/LayerViewHost.ts",C),b=e.getLocalizedString.bind(void 0,S);class P{constructor(e,t){this._type=e,this._layer=t}static isEqual(e,t){return e&&t?e._isEqual(t):e===t}type(){return this._type}layer(){return this._layer}_isEqual(e){return!1}}class x extends P{constructor(e){console.assert(Boolean(e),"LayerSelection with empty layer"),super("Layer",e)}_isEqual(e){return"Layer"===e._type&&e.layer().id()===this.layer().id()}}class T extends P{constructor(e,t){super("ScrollRect",e),this.scrollRectIndex=t}_isEqual(e){return"ScrollRect"===e._type&&this.layer().id()===e.layer().id()&&this.scrollRectIndex===e.scrollRectIndex}}class L extends P{constructor(e,t){super("Snapshot",e),this._snapshot=t}_isEqual(e){return"Snapshot"===e._type&&this.layer().id()===e.layer().id()&&this._snapshot===e._snapshot}snapshot(){return this._snapshot}}var E=Object.freeze({__proto__:null,UIStrings:C,LayerView:class{},Selection:P,LayerSelection:x,ScrollRectSelection:T,SnapshotSelection:L,LayerViewHost:class{constructor(){this._views=[],this._selectedObject=null,this._hoveredObject=null,this._showInternalLayersSetting=g.Settings.instance().createSetting("layersShowInternalLayers",!1),this._snapshotLayers=new Map}registerView(e){this._views.push(e)}setLayerSnapshotMap(e){this._snapshotLayers=e}getLayerSnapshotMap(){return this._snapshotLayers}setLayerTree(e){if(!e)return;this._target=e.target();const t=this._selectedObject&&this._selectedObject.layer();!t||e&&e.layerById(t.id())||this.selectObject(null);const i=this._hoveredObject&&this._hoveredObject.layer();!i||e&&e.layerById(i.id())||this.hoverObject(null);for(const t of this._views)t.setLayerTree(e)}hoverObject(e){if(P.isEqual(this._hoveredObject,e))return;this._hoveredObject=e;const t=e&&e.layer();this._toggleNodeHighlight(t?t.nodeForSelfOrAncestor():null);for(const t of this._views)t.hoverObject(e)}selectObject(e){if(!P.isEqual(this._selectedObject,e)){this._selectedObject=e;for(const t of this._views)t.selectObject(e)}}selection(){return this._selectedObject}showContextMenu(e,t){e.defaultSection().appendCheckboxItem(b(C.showInternalLayers),this._toggleShowInternalLayers.bind(this),this._showInternalLayersSetting.get());const i=t&&t.layer()&&t.layer().nodeForSelfOrAncestor();i&&e.appendApplicableItems(i),e.show()}showInternalLayersSetting(){return this._showInternalLayersSetting}_toggleShowInternalLayers(){this._showInternalLayersSetting.set(!this._showInternalLayersSetting.get())}_toggleNodeHighlight(e){e?e.highlightForTwoSeconds():s.OverlayModel.hideDOMNodeHighlight()}}});const R={selectALayerToSeeItsDetails:"Select a layer to see its details",scrollRectangleDimensions:"{PH1} {PH2} × {PH3} (at {PH4}, {PH5})",unnamed:"<unnamed>",stickyAncenstorLayersS:"{PH1}: {PH2} ({PH3})",stickyBoxRectangleDimensions:"Sticky Box {PH1} × {PH2} (at {PH3}, {PH4})",containingBlocRectangleDimensions:"Containing Block {PH1} × {PH2} (at {PH3}, {PH4})",nearestLayerShiftingStickyBox:"Nearest Layer Shifting Sticky Box",nearestLayerShiftingContaining:"Nearest Layer Shifting Containing Block",updateRectangleDimensions:"{PH1} × {PH2} (at {PH3},{PH4})",size:"Size",compositingReasons:"Compositing Reasons",memoryEstimate:"Memory estimate",paintCount:"Paint count",slowScrollRegions:"Slow scroll regions",stickyPositionConstraint:"Sticky position constraint",paintProfiler:"Paint Profiler",nonFastScrollable:"Non fast scrollable",touchEventHandler:"Touch event handler",wheelEventHandler:"Wheel event handler",repaintsOnScroll:"Repaints on scroll",mainThreadScrollingReason:"Main thread scrolling reason"},I=e.registerUIStrings("layer_viewer/LayerDetailsView.ts",R),H=e.getLocalizedString.bind(void 0,I),D=e.getLazilyComputedLocalizedString.bind(void 0,I);class O extends n.Widget{constructor(e){super(!0),this.registerRequiredCSS("layer_viewer/layerDetailsView.css",{enableLegacyPatching:!0}),this._layerViewHost=e,this._layerViewHost.registerView(this),this._emptyWidget=new o.EmptyWidget(H(R.selectALayerToSeeItsDetails)),this._layerSnapshotMap=this._layerViewHost.getLayerSnapshotMap(),this._buildContent(),this._selection=null}hoverObject(e){}selectObject(e){this._selection=e,this.isShowing()&&this.update()}setLayerTree(e){}wasShown(){super.wasShown(),this.update()}_onScrollRectClicked(e,t){1===t.which&&this._selection&&this._layerViewHost.selectObject(new T(this._selection.layer(),e))}_invokeProfilerLink(){if(!this._selection)return;const e="Snapshot"===this._selection.type()?this._selection:this._layerSnapshotMap.get(this._selection.layer());e&&this.dispatchEventToListeners(B.PaintProfilerRequested,e)}_createScrollRectElement(e,t){t&&a.createTextChild(this._scrollRectsCell,", ");const i=this._scrollRectsCell.createChild("span","scroll-rect");this._selection&&this._selection.scrollRectIndex===t&&i.classList.add("active"),i.textContent=H(R.scrollRectangleDimensions,{PH1:k.get(e.type)?.(),PH2:e.rect.width,PH3:e.rect.height,PH4:e.rect.x,PH5:e.rect.y}),i.addEventListener("click",this._onScrollRectClicked.bind(this,t),!1)}_formatStickyAncestorLayer(e,t){if(!t)return"";const i=t.nodeForSelfOrAncestor(),s=i?i.simpleSelector():H(R.unnamed);return H(R.stickyAncenstorLayersS,{PH1:e,PH2:s,PH3:t.id()})}_createStickyAncestorChild(e,t){if(!t)return;a.createTextChild(this._stickyPositionConstraintCell,", ");this._stickyPositionConstraintCell.createChild("span").textContent=this._formatStickyAncestorLayer(e,t)}_populateStickyPositionConstraintCell(e){if(this._stickyPositionConstraintCell.removeChildren(),!e)return;const t=e.stickyBoxRect();this._stickyPositionConstraintCell.createChild("span").textContent=H(R.stickyBoxRectangleDimensions,{PH1:t.width,PH2:t.height,PH3:t.x,PH4:t.y}),a.createTextChild(this._stickyPositionConstraintCell,", ");const i=e.containingBlockRect();this._stickyPositionConstraintCell.createChild("span").textContent=H(R.containingBlocRectangleDimensions,{PH1:i.width,PH2:i.height,PH3:i.x,PH4:i.y}),this._createStickyAncestorChild(H(R.nearestLayerShiftingStickyBox),e.nearestLayerShiftingStickyBox()),this._createStickyAncestorChild(H(R.nearestLayerShiftingContaining),e.nearestLayerShiftingContainingBlock())}update(){const e=this._selection&&this._selection.layer();if(!e)return this._tableElement.remove(),this._paintProfilerLink.remove(),void this._emptyWidget.show(this.contentElement);this._emptyWidget.detach(),this.contentElement.appendChild(this._tableElement),this.contentElement.appendChild(this._paintProfilerLink),this._sizeCell.textContent=H(R.updateRectangleDimensions,{PH1:e.width(),PH2:e.height(),PH3:e.offsetX(),PH4:e.offsetY()}),this._paintCountCell.parentElement&&this._paintCountCell.parentElement.classList.toggle("hidden",!e.paintCount()),this._paintCountCell.textContent=String(e.paintCount()),this._memoryEstimateCell.textContent=t.bytesToString(e.gpuMemoryUsage()),e.requestCompositingReasonIds().then(this._updateCompositingReasons.bind(this)),this._scrollRectsCell.removeChildren(),e.scrollRects().forEach(this._createScrollRectElement.bind(this)),this._populateStickyPositionConstraintCell(e.stickyPositionConstraint());const i=this._selection&&"Snapshot"===this._selection.type()?this._selection.snapshot():null;this._paintProfilerLink.classList.toggle("hidden",!(this._layerSnapshotMap.has(e)||i))}_buildContent(){this._tableElement=this.contentElement.createChild("table"),this._tbodyElement=this._tableElement.createChild("tbody"),this._sizeCell=this._createRow(H(R.size)),this._compositingReasonsCell=this._createRow(H(R.compositingReasons)),this._memoryEstimateCell=this._createRow(H(R.memoryEstimate)),this._paintCountCell=this._createRow(H(R.paintCount)),this._scrollRectsCell=this._createRow(H(R.slowScrollRegions)),this._stickyPositionConstraintCell=this._createRow(H(R.stickyPositionConstraint)),this._paintProfilerLink=this.contentElement.createChild("span","hidden devtools-link link-margin"),l.markAsLink(this._paintProfilerLink),this._paintProfilerLink.textContent=H(R.paintProfiler),this._paintProfilerLink.tabIndex=0,this._paintProfilerLink.addEventListener("click",(e=>{e.consume(!0),this._invokeProfilerLink()})),this._paintProfilerLink.addEventListener("keydown",(e=>{"Enter"===e.key&&(e.consume(),this._invokeProfilerLink())}))}_createRow(e){const t=this._tbodyElement.createChild("tr");return t.createChild("td").textContent=e,t.createChild("td")}_updateCompositingReasons(e){if(!e||!e.length)return void(this._compositingReasonsCell.textContent="n/a");this._compositingReasonsCell.removeChildren();const t=this._compositingReasonsCell.createChild("ul"),i=O.getCompositingReasons(e);for(const e of i)t.createChild("li").textContent=e}static getCompositingReasons(e){const t=[];for(const i of e){const e=M.get(i);e?t.push(e):console.error(`Compositing reason id '${i}' is not recognized.`)}return t}}const M=new Map([["transform3D","Has a 3D transform."],["video","Is an accelerated video."],["canvas","Is an accelerated canvas, or is a display list backed canvas that was promoted to a layer based on a performance heuristic."],["plugin","Is an accelerated plugin."],["iFrame","Is an accelerated iFrame."],["backfaceVisibilityHidden","Has backface-visibility: hidden."],["activeTransformAnimation","Has an active accelerated transform animation or transition."],["activeOpacityAnimation","Has an active accelerated opacity animation or transition."],["activeFilterAnimation","Has an active accelerated filter animation or transition."],["activeBackdropFilterAnimation","Has an active accelerated backdrop filter animation or transition."],["immersiveArOverlay","Is DOM overlay for WebXR immersive-ar mode."],["scrollDependentPosition","Is fixed or sticky position."],["overflowScrolling","Is a scrollable overflow element."],["overflowScrollingParent","Scroll parent is not an ancestor."],["outOfFlowClipping","Has clipping ancestor."],["videoOverlay","Is overlay controls for video."],["willChangeTransform","Has a will-change: transform compositing hint."],["willChangeOpacity","Has a will-change: opacity compositing hint."],["willChangeOther","Has a will-change compositing hint other than transform and opacity."],["backdropFilter","Has a backdrop filter."],["rootScroller","Is the document.rootScroller."],["assumedOverlap","Might overlap other composited content."],["overlap","Overlaps other composited content."],["negativeZIndexChildren","Parent with composited negative z-index content."],["squashingDisallowed","Layer was separately composited because it could not be squashed."],["opacityWithCompositedDescendants","Has opacity that needs to be applied by the compositor because of composited descendants."],["maskWithCompositedDescendants","Has a mask that needs to be known by the compositor because of composited descendants."],["reflectionWithCompositedDescendants","Has a reflection that needs to be known by the compositor because of composited descendants."],["filterWithCompositedDescendants","Has a filter effect that needs to be known by the compositor because of composited descendants."],["blendingWithCompositedDescendants","Has a blending effect that needs to be known by the compositor because of composited descendants."],["clipsCompositingDescendants","Has a clip that needs to be known by the compositor because of composited descendants."],["perspectiveWith3DDescendants","Has a perspective transform that needs to be known by the compositor because of 3D descendants."],["preserve3DWith3DDescendants","Has a preserves-3D property that needs to be known by the compositor because of 3D descendants."],["isolateCompositedDescendants","Should isolate descendants to apply a blend effect."],["positionFixedWithCompositedDescendants","Is a position:fixed element with composited descendants."],["root","Is the root layer."],["layerForHorizontalScrollbar","Secondary layer, the horizontal scrollbar layer."],["layerForVerticalScrollbar","Secondary layer, the vertical scrollbar layer."],["layerForOverflowControlsHost","Secondary layer, the overflow controls host layer."],["layerForScrollCorner","Secondary layer, the scroll corner layer."],["layerForScrollingContents","Secondary layer, to house contents that can be scrolled."],["layerForScrollingContainer","Secondary layer, used to position the scrolling contents while scrolling."],["layerForSquashingContents","Secondary layer, home for a group of squashable content."],["layerForSquashingContainer","Secondary layer, no-op layer to place the squashing layer correctly in the composited layer tree."],["layerForForeground","Secondary layer, to contain any normal flow and positive z-index contents on top of a negative z-index layer."],["layerForMask","Secondary layer, to contain the mask contents."],["layerForDecoration","Layer painted on top of other layers as decoration."],["layerForOther","Layer for link highlight, frame overlay, etc."]]);var B;!function(e){e.PaintProfilerRequested="PaintProfilerRequested"}(B||(B={}));const k=new Map([[r.Layer.ScrollRectType.NonFastScrollable,D(R.nonFastScrollable)],[r.Layer.ScrollRectType.TouchEventHandler,D(R.touchEventHandler)],[r.Layer.ScrollRectType.WheelEventHandler,D(R.wheelEventHandler)],[r.Layer.ScrollRectType.RepaintsOnScroll,D(R.repaintsOnScroll)],[r.Layer.ScrollRectType.MainThreadScrollingReason,D(R.mainThreadScrollingReason)]]);var A=Object.freeze({__proto__:null,UIStrings:R,LayerDetailsView:O,get Events(){return B},slowScrollRectNames:k});const F={layersTreePane:"Layers Tree Pane",showPaintProfiler:"Show Paint Profiler",updateChildDimension:" ({PH1} × {PH2})"},V=e.registerUIStrings("layer_viewer/LayerTreeOutline.ts",F),W=e.getLocalizedString.bind(void 0,V);class X extends y.ObjectWrapper{constructor(e){super(),this._layerViewHost=e,this._layerViewHost.registerView(this),this._treeOutline=new h.TreeOutlineInShadow,this._treeOutline.element.classList.add("layer-tree","overflow-auto"),this._treeOutline.element.addEventListener("mousemove",this._onMouseMove.bind(this),!1),this._treeOutline.element.addEventListener("mouseout",this._onMouseMove.bind(this),!1),this._treeOutline.element.addEventListener("contextmenu",this._onContextMenu.bind(this),!0),l.setAccessibleName(this._treeOutline.contentElement,W(F.layersTreePane)),this._lastHoveredNode=null,this.element=this._treeOutline.element,this._layerViewHost.showInternalLayersSetting().addChangeListener(this._update,this)}focus(){this._treeOutline.focus()}selectObject(e){this.hoverObject(null);const t=e&&e.layer(),i=t&&U.get(t);i?i.revealAndSelect(!0):this._treeOutline.selectedTreeElement&&this._treeOutline.selectedTreeElement.deselect()}hoverObject(e){const t=e&&e.layer(),i=t&&U.get(t);i!==this._lastHoveredNode&&(this._lastHoveredNode&&this._lastHoveredNode.setHovered(!1),i&&i.setHovered(!0),this._lastHoveredNode=i)}setLayerTree(e){this._layerTree=e,this._update()}_update(){const e=this._layerViewHost.showInternalLayersSetting().get(),t=new Map;let i=null;this._layerTree&&(e||(i=this._layerTree.contentRoot()),i||(i=this._layerTree.root())),i&&this._layerTree&&this._layerTree.forEachLayer(function(s){if(!s.drawsContent()&&!e)return;t.get(s)&&console.assert(!1,"Duplicate layer: "+s.id()),t.set(s,!0);let r=U.get(s)||null,n=s.parent();for(;n&&n!==i&&!n.drawsContent()&&!e;)n=n.parent();const o=s===i?this._treeOutline.rootElement():n&&U.get(n);if(o)if(r){if(r.parent!==o){const e=this._treeOutline.selectedTreeElement;r.parent&&r.parent.removeChild(r),o.appendChild(r),e&&e!==this._treeOutline.selectedTreeElement&&e.select()}r._update()}else r=new j(this,s),o.appendChild(r),s.drawsContent()||r.expand();else console.assert(!1,"Parent is not in the tree")}.bind(this),i);for(let e=this._treeOutline.rootElement().firstChild();e instanceof j&&!e.root;)if(t.get(e._layer))e=e.traverseNextTreeElement(!1);else{const t=e.nextSibling||e.parent;e.parent&&e.parent.removeChild(e),e===this._lastHoveredNode&&(this._lastHoveredNode=null),e=t}if(!this._treeOutline.selectedTreeElement&&this._layerTree){const e=this._layerTree.contentRoot()||this._layerTree.root();if(e){const t=U.get(e);t&&t.revealAndSelect(!0)}}}_onMouseMove(e){const t=this._treeOutline.treeElementFromEvent(e);t!==this._lastHoveredNode&&this._layerViewHost.hoverObject(this._selectionForNode(t))}_selectedNodeChanged(e){this._layerViewHost.selectObject(this._selectionForNode(e))}_onContextMenu(e){const t=this._selectionForNode(this._treeOutline.treeElementFromEvent(e)),i=new c.ContextMenu(e),s=t&&t.layer();s&&(this._layerSnapshotMap=this._layerViewHost.getLayerSnapshotMap(),this._layerSnapshotMap.has(s)&&i.defaultSection().appendItem(W(F.showPaintProfiler),this.dispatchEventToListeners.bind(this,N.PaintProfilerRequested,t),!1)),this._layerViewHost.showContextMenu(i,t)}_selectionForNode(e){return e&&e._layer?new x(e._layer):null}}var N;(N||(N={})).PaintProfilerRequested="PaintProfilerRequested";class j extends h.TreeElement{constructor(e,t){super(),this._treeOutline=e,this._layer=t,U.set(t,this),this._update()}_update(){const e=this._layer.nodeForSelfOrAncestor(),t=document.createDocumentFragment();a.createTextChild(t,e?e.simpleSelector():"#"+this._layer.id());t.createChild("span","dimmed").textContent=W(F.updateChildDimension,{PH1:this._layer.width(),PH2:this._layer.height()}),this.title=t}onselect(){return this._treeOutline._selectedNodeChanged(this),!1}setHovered(e){this.listItemElement.classList.toggle("hovered",e)}}const U=new WeakMap;var Y=Object.freeze({__proto__:null,UIStrings:F,LayerTreeOutline:X,get Events(){return N},LayerTreeElement:j,layerToTreeElement:U});const q={panModeX:"Pan mode (X)",rotateModeV:"Rotate mode (V)",resetTransform:"Reset transform (0)"},z=e.registerUIStrings("layer_viewer/TransformController.ts",q),G=e.getLocalizedString.bind(void 0,z);class K extends y.ObjectWrapper{constructor(e,t){if(super(),this._scale=1,this._offsetX=0,this._offsetY=0,this._rotateX=0,this._rotateY=0,this._oldRotateX=0,this._oldRotateY=0,this._originX=0,this._originY=0,this.element=e,this._registerShortcuts(),a.installDragHandle(e,this._onDragStart.bind(this),this._onDrag.bind(this),this._onDragEnd.bind(this),"move",null),e.addEventListener("wheel",this._onMouseWheel.bind(this),!1),this._minScale=0,this._maxScale=1/0,this._controlPanelToolbar=new d.Toolbar("transform-control-panel"),this._modeButtons={},!t){const e=new d.ToolbarToggle(G(q.panModeX),"largeicon-pan");e.addEventListener(d.ToolbarButton.Events.Click,this._setMode.bind(this,"Pan")),this._modeButtons.Pan=e,this._controlPanelToolbar.appendToolbarItem(e);const t=new d.ToolbarToggle(G(q.rotateModeV),"largeicon-rotate");t.addEventListener(d.ToolbarButton.Events.Click,this._setMode.bind(this,"Rotate")),this._modeButtons.Rotate=t,this._controlPanelToolbar.appendToolbarItem(t)}this._setMode("Pan");const i=new d.ToolbarButton(G(q.resetTransform),"largeicon-center");i.addEventListener(d.ToolbarButton.Events.Click,this.resetAndNotify.bind(this,void 0)),this._controlPanelToolbar.appendToolbarItem(i),this._reset()}toolbar(){return this._controlPanelToolbar}_registerShortcuts(){_.ShortcutRegistry.instance().addShortcutListener(this.element,{"layers.reset-view":async()=>(this.resetAndNotify(),!0),"layers.pan-mode":async()=>(this._setMode("Pan"),!0),"layers.rotate-mode":async()=>(this._setMode("Rotate"),!0),"layers.zoom-in":this._onKeyboardZoom.bind(this,1.1),"layers.zoom-out":this._onKeyboardZoom.bind(this,1/1.1),"layers.up":this._onKeyboardPanOrRotate.bind(this,0,-1),"layers.down":this._onKeyboardPanOrRotate.bind(this,0,1),"layers.left":this._onKeyboardPanOrRotate.bind(this,-1,0),"layers.right":this._onKeyboardPanOrRotate.bind(this,1,0)})}_postChangeEvent(){this.dispatchEventToListeners(Q.TransformChanged)}_reset(){this._scale=1,this._offsetX=0,this._offsetY=0,this._rotateX=0,this._rotateY=0}_setMode(e){this._mode!==e&&(this._mode=e,this._updateModeButtons())}_updateModeButtons(){for(const e in this._modeButtons)this._modeButtons[e].setToggled(e===this._mode)}resetAndNotify(e){this._reset(),this._postChangeEvent(),e&&e.preventDefault(),this.element.focus()}setScaleConstraints(e,i){this._minScale=e,this._maxScale=i,this._scale=t.clamp(this._scale,e,i)}clampOffsets(e,i,s,r){this._offsetX=t.clamp(this._offsetX,e,i),this._offsetY=t.clamp(this._offsetY,s,r)}scale(){return this._scale}offsetX(){return this._offsetX}offsetY(){return this._offsetY}rotateX(){return this._rotateX}rotateY(){return this._rotateY}_onScale(e,i,s){e=t.clamp(this._scale*e,this._minScale,this._maxScale)/this._scale,this._scale*=e,this._offsetX-=(i-this._offsetX)*(e-1),this._offsetY-=(s-this._offsetY)*(e-1),this._postChangeEvent()}_onPan(e,t){this._offsetX+=e,this._offsetY+=t,this._postChangeEvent()}_onRotate(e,t){this._rotateX=e,this._rotateY=t,this._postChangeEvent()}async _onKeyboardZoom(e){return this._onScale(e,this.element.clientWidth/2,this.element.clientHeight/2),!0}async _onKeyboardPanOrRotate(e,t){return"Rotate"===this._mode?this._onRotate(this._rotateX+5*t,this._rotateY+5*e):this._onPan(6*e,6*t),!0}_onMouseWheel(e){const t=e,i=Math.pow(1.1,-t.deltaY*(1/53));this._onScale(i,t.clientX-this.element.totalOffsetLeft(),t.clientY-this.element.totalOffsetTop())}_onDrag(e){const{clientX:t,clientY:i}=e;"Rotate"===this._mode?this._onRotate(this._oldRotateX+(this._originY-i)/this.element.clientHeight*180,this._oldRotateY-(this._originX-t)/this.element.clientWidth*180):(this._onPan(t-this._originX,i-this._originY),this._originX=t,this._originY=i)}_onDragStart(e){return this.element.focus(),this._originX=e.clientX,this._originY=e.clientY,this._oldRotateX=this._rotateX,this._oldRotateY=this._rotateY,!0}_onDragEnd(){this._originX=0,this._originY=0,this._oldRotateX=0,this._oldRotateY=0}}var Q;(Q||(Q={})).TransformChanged="TransformChanged";var Z=Object.freeze({__proto__:null,UIStrings:q,TransformController:K,get Events(){return Q}});const J={layerInformationIsNotYet:"Layer information is not yet available.",dLayersView:"3D Layers View",cantDisplayLayers:"Can't display layers,",webglSupportIsDisabledInYour:"WebGL support is disabled in your browser.",checkSForPossibleReasons:"Check {PH1} for possible reasons.",slowScrollRects:"Slow scroll rects",paints:"Paints",resetView:"Reset View",showPaintProfiler:"Show Paint Profiler"},$=e.registerUIStrings("layer_viewer/Layers3DView.ts",J),ee=e.getLocalizedString.bind(void 0,$),te=new Map,ie=new Map,se=new Map,re=new Map,ne=new Map,oe=new Map;class ae extends n.VBox{constructor(e){super(!0),this.registerRequiredCSS("layer_viewer/layers3DView.css",{enableLegacyPatching:!0}),this.contentElement.classList.add("layers-3d-view"),this._failBanner=new n.VBox,this._failBanner.element.classList.add("full-widget-dimmed-banner"),a.createTextChild(this._failBanner.element,ee(J.layerInformationIsNotYet)),this._layerViewHost=e,this._layerViewHost.registerView(this),this._transformController=new K(this.contentElement),this._transformController.addEventListener(Q.TransformChanged,this._update,this),this._initToolbar(),this._canvasElement=this.contentElement.createChild("canvas"),this._canvasElement.tabIndex=0,this._canvasElement.addEventListener("dblclick",this._onDoubleClick.bind(this),!1),this._canvasElement.addEventListener("mousedown",this._onMouseDown.bind(this),!1),this._canvasElement.addEventListener("mouseup",this._onMouseUp.bind(this),!1),this._canvasElement.addEventListener("mouseleave",this._onMouseMove.bind(this),!1),this._canvasElement.addEventListener("mousemove",this._onMouseMove.bind(this),!1),this._canvasElement.addEventListener("contextmenu",this._onContextMenu.bind(this),!1),l.setAccessibleName(this._canvasElement,ee(J.dLayersView)),this._lastSelection={},this._layerTree=null,this._textureManager=new be(this._update.bind(this)),this._chromeTextures=[],this._rects=[],this._snapshotLayers=new Map,this._layerViewHost.setLayerSnapshotMap(this._snapshotLayers),this._layerViewHost.showInternalLayersSetting().addChangeListener(this._update,this)}setLayerTree(e){this._layerTree=e,this._layerTexture=null,delete this._oldTextureScale,this._showPaints()&&this._textureManager.setLayerTree(e),this._update()}showImageForLayer(e,t){if(!t)return this._layerTexture=null,void this._update();a.loadImage(t).then((t=>{const i=t&&be._createTextureForImage(this._gl||null,t);this._layerTexture=i?{layer:e,texture:i}:null,this._update()}))}onResize(){this._resizeCanvas(),this._update()}willHide(){this._textureManager.suspend()}wasShown(){this._textureManager.resume(),this._needsUpdate&&(this._resizeCanvas(),this._update())}updateLayerSnapshot(e){this._textureManager.layerNeedsUpdate(e)}_setOutline(e,t){this._lastSelection[e]=t,this._update()}hoverObject(e){this._setOutline(le.Hovered,e)}selectObject(e){this._setOutline(le.Hovered,null),this._setOutline(le.Selected,e)}snapshotForSelection(e){if("Snapshot"===e.type()){const t=e.snapshot();return t.snapshot.addReference(),Promise.resolve(t)}if(e.layer()){const t=e.layer().snapshots()[0];if(t)return t}return Promise.resolve(null)}_initGL(e){const t=e.getContext("webgl");return t?(t.blendFunc(t.SRC_ALPHA,t.ONE_MINUS_SRC_ALPHA),t.enable(t.BLEND),t.clearColor(0,0,0,0),t.enable(t.DEPTH_TEST),t):null}_createShader(e,t){if(!this._gl)return;const i=this._gl.createShader(e);i&&this._shaderProgram&&(this._gl.shaderSource(i,t),this._gl.compileShader(i),this._gl.attachShader(this._shaderProgram,i))}_initShaders(){if(!this._gl)return;if(this._shaderProgram=this._gl.createProgram(),!this._shaderProgram)return;this._createShader(this._gl.FRAGMENT_SHADER,ce),this._createShader(this._gl.VERTEX_SHADER,de),this._gl.linkProgram(this._shaderProgram),this._gl.useProgram(this._shaderProgram);const e=this._gl.getAttribLocation(this._shaderProgram,"aVertexPosition");this._gl.enableVertexAttribArray(e),te.set(this._shaderProgram,e);const t=this._gl.getAttribLocation(this._shaderProgram,"aVertexColor");this._gl.enableVertexAttribArray(t),ie.set(this._shaderProgram,t);const i=this._gl.getAttribLocation(this._shaderProgram,"aTextureCoord");this._gl.enableVertexAttribArray(i),se.set(this._shaderProgram,i);const s=this._gl.getUniformLocation(this._shaderProgram,"uPMatrix");re.set(this._shaderProgram,s);const r=this._gl.getUniformLocation(this._shaderProgram,"uSampler");ne.set(this._shaderProgram,r)}_resizeCanvas(){this._canvasElement.width=this._canvasElement.offsetWidth*window.devicePixelRatio,this._canvasElement.height=this._canvasElement.offsetHeight*window.devicePixelRatio}_updateTransformAndConstraints(){const e=this._dimensionsForAutoscale||{width:0,height:0},i=this._layerTree?this._layerTree.viewportSize():null,s=i?i.width:e.width,r=i?i.height:e.height,n=this._canvasElement.width,o=this._canvasElement.height,a=.1*n,l=.1*o,h=(n-2*a)/s,c=(o-2*l)/r,d=Math.min(h,c),_=Math.min(s/e.width,r/e.width)/2;this._transformController.setScaleConstraints(_,10/d);const p=this._transformController.scale(),m=this._transformController.rotateX(),g=this._transformController.rotateY();this._scale=p*d;const y=t.clamp(this._scale,.1,1);y!==this._oldTextureScale&&(this._oldTextureScale=y,this._textureManager.setScale(y),this.dispatchEventToListeners(he.ScaleChanged,y));const f=(new WebKitCSSMatrix).scale(p,p,p).translate(n/2,o/2,0).rotate(m,g,0).scale(d,d,d).translate(-s/2,-r/2,0);let w;for(let e=0;e<this._rects.length;++e)w=u.boundsForTransformedPoints(f,this._rects[e].vertices,w);w&&this._transformController.clampOffsets((a-w.maxX)/window.devicePixelRatio,(n-a-w.minX)/window.devicePixelRatio,(l-w.maxY)/window.devicePixelRatio,(o-l-w.minY)/window.devicePixelRatio);const v=this._transformController.offsetX()*window.devicePixelRatio,C=this._transformController.offsetY()*window.devicePixelRatio;this._projectionMatrix=(new WebKitCSSMatrix).translate(v,C,0).multiply(f);const S=(new WebKitCSSMatrix).scale(1,-1,-1).translate(-1,-1,0).scale(2/this._canvasElement.width,2/this._canvasElement.height,1e-6).multiply(this._projectionMatrix);if(this._shaderProgram){const e=re.get(this._shaderProgram);this._gl&&e&&this._gl.uniformMatrix4fv(e,!1,this._arrayFromMatrix(S))}}_arrayFromMatrix(e){return new Float32Array([e.m11,e.m12,e.m13,e.m14,e.m21,e.m22,e.m23,e.m24,e.m31,e.m32,e.m33,e.m34,e.m41,e.m42,e.m43,e.m44])}_initWhiteTexture(){if(!this._gl)return;this._whiteTexture=this._gl.createTexture(),this._gl.bindTexture(this._gl.TEXTURE_2D,this._whiteTexture);const e=new Uint8Array([255,255,255,255]);this._gl.texImage2D(this._gl.TEXTURE_2D,0,this._gl.RGBA,1,1,0,this._gl.RGBA,this._gl.UNSIGNED_BYTE,e)}_initChromeTextures(){function e(e,t){a.loadImage(t).then((t=>{this._chromeTextures[e]=t&&be._createTextureForImage(this._gl||null,t)||void 0}))}e.call(this,0,"Images/chromeLeft.avif"),e.call(this,1,"Images/chromeMiddle.avif"),e.call(this,2,"Images/chromeRight.avif")}_initGLIfNecessary(){return this._gl?this._gl:(this._gl=this._initGL(this._canvasElement),this._gl?(this._initShaders(),this._initWhiteTexture(),this._initChromeTextures(),this._textureManager.setContext(this._gl),this._gl):null)}_calculateDepthsAndVisibility(){this._depthByLayerId=new Map;let e=0;const t=this._layerViewHost.showInternalLayersSetting().get();if(!this._layerTree)return;const i=t?this._layerTree.root():this._layerTree.contentRoot()||this._layerTree.root();if(!i)return;const s=[i];for(this._depthByLayerId.set(i.id(),0),this._visibleLayers=new Set;s.length>0;){const i=s.shift();if(!i)break;(t||i.drawsContent())&&this._visibleLayers.add(i);const r=i.children();for(let t=0;t<r.length;++t)this._depthByLayerId.set(r[t].id(),++e),s.push(r[t])}this._maxDepth=e}_depthForLayer(e){return(this._depthByLayerId.get(e.id())||0)*Ce}_calculateScrollRectDepth(e,t){return this._depthForLayer(e)+t*Se+1}_updateDimensionsForAutoscale(e){this._dimensionsForAutoscale||(this._dimensionsForAutoscale={width:0,height:0}),this._dimensionsForAutoscale.width=Math.max(e.width(),this._dimensionsForAutoscale.width),this._dimensionsForAutoscale.height=Math.max(e.height(),this._dimensionsForAutoscale.height)}_calculateLayerRect(e){if(!this._visibleLayers.has(e))return;const t=new x(e),i=new Pe(t);i.setVertices(e.quad(),this._depthForLayer(e)),this._appendRect(i),this._updateDimensionsForAutoscale(e)}_appendRect(e){const t=e.relatedObject,i=P.isEqual(this._lastSelection[le.Selected],t),s=P.isEqual(this._lastSelection[le.Hovered],t);if(i)e.borderColor=ue;else if(s){e.borderColor=_e;const t=e.fillColor||[255,255,255,1],i=ye;e.fillColor=[t[0]*i[0]/255,t[1]*i[1]/255,t[2]*i[2]/255,t[3]*i[3]]}else e.borderColor=pe;e.lineWidth=i?we:fe,this._rects.push(e)}_calculateLayerScrollRects(e){const t=e.scrollRects();for(let i=0;i<t.length;++i){const s=new T(e,i),r=new Pe(s);r.calculateVerticesFromRect(e,t[i].rect,this._calculateScrollRectDepth(e,i)),r.fillColor=ge,this._appendRect(r)}}_calculateLayerTileRects(e){const t=this._textureManager.tilesForLayer(e);for(let i=0;i<t.length;++i){const s=t[i];if(!s.texture)continue;const r=new L(e,{rect:s.rect,snapshot:s.snapshot}),n=new Pe(r);this._snapshotLayers.has(e)||this._snapshotLayers.set(e,r),n.calculateVerticesFromRect(e,s.rect,this._depthForLayer(e)+1),n.texture=s.texture,this._appendRect(n)}}_calculateRects(){if(this._rects=[],this._snapshotLayers.clear(),this._dimensionsForAutoscale={width:0,height:0},this._layerTree&&this._layerTree.forEachLayer(this._calculateLayerRect.bind(this)),this._showSlowScrollRectsSetting&&this._showSlowScrollRectsSetting.get()&&this._layerTree&&this._layerTree.forEachLayer(this._calculateLayerScrollRects.bind(this)),this._layerTexture&&this._visibleLayers.has(this._layerTexture.layer)){const e=this._layerTexture.layer,t=new x(e),i=new Pe(t);i.setVertices(e.quad(),this._depthForLayer(e)),i.texture=this._layerTexture.texture,this._appendRect(i)}else this._showPaints()&&this._layerTree&&this._layerTree.forEachLayer(this._calculateLayerTileRects.bind(this))}_makeColorsArray(e){let t=[];const i=[e[0]/255,e[1]/255,e[2]/255,e[3]];for(let e=0;e<4;e++)t=t.concat(i);return t}_setVertexAttribute(e,t,i){const s=this._gl;if(!s)return;const r=s.createBuffer();s.bindBuffer(s.ARRAY_BUFFER,r),s.bufferData(s.ARRAY_BUFFER,new Float32Array(t),s.STATIC_DRAW),s.vertexAttribPointer(e,i,s.FLOAT,!1,0,0)}_drawRectangle(e,t,i,s){const r=this._gl;if(i=i||[255,255,255,1],!this._shaderProgram)return;const n=te.get(this._shaderProgram),o=se.get(this._shaderProgram),a=ie.get(this._shaderProgram);if(void 0!==n&&this._setVertexAttribute(n,e,3),void 0!==o&&this._setVertexAttribute(o,[0,1,1,1,1,0,0,0],2),void 0!==a&&this._setVertexAttribute(a,this._makeColorsArray(i),i.length),!r)return;const l=ne.get(this._shaderProgram);s?l&&(r.activeTexture(r.TEXTURE0),r.bindTexture(r.TEXTURE_2D,s),r.uniform1i(l,0)):this._whiteTexture&&r.bindTexture(r.TEXTURE_2D,this._whiteTexture);const h=e.length/3;r.drawArrays(t,0,h)}_drawTexture(e,t,i){this._gl&&this._drawRectangle(e,this._gl.TRIANGLE_FAN,i,t)}_drawViewportAndChrome(){if(!this._layerTree)return;const e=this._layerTree.viewportSize();if(!e)return;const t=!g.Settings.instance().moduleSetting("frameViewerHideChromeWindow").get()&&this._chromeTextures.length>=3&&this._chromeTextures.indexOf(void 0)<0,i=(this._maxDepth+1)*Ce,s=Math.ceil(ve*this._scale);let r=[e.width,0,i,e.width,e.height,i,0,e.height,i,0,0,i];if(!this._gl)return;if(this._gl.lineWidth(s),this._drawRectangle(r,t?this._gl.LINE_STRIP:this._gl.LINE_LOOP,me),!t)return;const n=this._layerTree.viewportSize();if(!n)return;const o=ve/2,a=n.width+2*o;if(this._chromeTextures[0]&&this._chromeTextures[2]){const e=oe.get(this._chromeTextures[0])||{naturalHeight:0,naturalWidth:0},t=e.naturalHeight,s=oe.get(this._chromeTextures[2])||{naturalHeight:0,naturalWidth:0},n=a-e.naturalWidth-s.naturalWidth;let l=-o;const h=-t;for(let e=0;e<this._chromeTextures.length;++e){const s=this._chromeTextures[e];if(!s)continue;const o=oe.get(s);if(!o)continue;const c=1===e?n:o.naturalWidth;if(c<0||l+c>a)break;r=[l,h,i,l+c,h,i,l+c,h+t,i,l,h+t,i],this._drawTexture(r,this._chromeTextures[e]),l+=c}}}_drawViewRect(e){if(!this._gl)return;const t=e.vertices;e.texture?this._drawTexture(t,e.texture,e.fillColor||void 0):e.fillColor&&this._drawRectangle(t,this._gl.TRIANGLE_FAN,e.fillColor),this._gl.lineWidth(e.lineWidth),e.borderColor&&this._drawRectangle(t,this._gl.LINE_LOOP,e.borderColor)}_update(){if(!this.isShowing())return void(this._needsUpdate=!0);if(!this._layerTree||!this._layerTree.root())return void this._failBanner.show(this.contentElement);const e=this._initGLIfNecessary();if(!e)return this._failBanner.element.removeChildren(),this._failBanner.element.appendChild(this._webglDisabledBanner()),void this._failBanner.show(this.contentElement);this._failBanner.detach();const t=this._canvasElement.width,i=this._canvasElement.height;this._calculateDepthsAndVisibility(),this._calculateRects(),this._updateTransformAndConstraints(),e.viewport(0,0,t,i),e.clear(e.COLOR_BUFFER_BIT|e.DEPTH_BUFFER_BIT),this._rects.forEach(this._drawViewRect.bind(this)),this._drawViewportAndChrome()}_webglDisabledBanner(){const t=this.contentElement.ownerDocument.createDocumentFragment();return t.createChild("div").textContent=ee(J.cantDisplayLayers),t.createChild("div").textContent=ee(J.webglSupportIsDisabledInYour),t.appendChild(e.getFormatLocalizedString($,J.checkSForPossibleReasons,{PH1:p.XLink.create("about:gpu")})),t}_selectionFromEventPoint(e){const t=e;if(!this._layerTree)return null;let i=1/0,s=null;const r=(new WebKitCSSMatrix).scale(1,-1,-1).translate(-1,-1,0).multiply(this._projectionMatrix),n=(t.clientX-this._canvasElement.totalOffsetLeft())*window.devicePixelRatio,o=-(t.clientY-this._canvasElement.totalOffsetTop())*window.devicePixelRatio;return this._rects.forEach((function(e){if(!e.relatedObject)return;const t=e.intersectWithLine(r,n,o);t&&t<i&&(i=t,s=e.relatedObject)})),s}_createVisibilitySetting(e,t,i,s){const r=g.Settings.instance().createSetting(t,i);return r.setTitle(ee(e)),r.addChangeListener(this._update,this),s.appendToolbarItem(new d.ToolbarSettingCheckbox(r)),r}_initToolbar(){this._panelToolbar=this._transformController.toolbar(),this.contentElement.appendChild(this._panelToolbar.element),this._showSlowScrollRectsSetting=this._createVisibilitySetting(ee(J.slowScrollRects),"frameViewerShowSlowScrollRects",!0,this._panelToolbar),this._showPaintsSetting=this._createVisibilitySetting(ee(J.paints),"frameViewerShowPaints",!0,this._panelToolbar),this._showPaintsSetting.addChangeListener(this._updatePaints,this),g.Settings.instance().moduleSetting("frameViewerHideChromeWindow").addChangeListener(this._update,this)}_onContextMenu(e){const t=new c.ContextMenu(e);t.defaultSection().appendItem(ee(J.resetView),(()=>this._transformController.resetAndNotify()),!1);const i=this._selectionFromEventPoint(e);i&&"Snapshot"===i.type()&&t.defaultSection().appendItem(ee(J.showPaintProfiler),this.dispatchEventToListeners.bind(this,he.PaintProfilerRequested,i),!1),this._layerViewHost.showContextMenu(t,i)}_onMouseMove(e){e.which||this._layerViewHost.hoverObject(this._selectionFromEventPoint(e))}_onMouseDown(e){const t=e;this._mouseDownX=t.clientX,this._mouseDownY=t.clientY}_onMouseUp(e){const t=e;this._mouseDownX&&Math.abs(t.clientX-this._mouseDownX)<6&&Math.abs(t.clientY-(this._mouseDownY||0))<6&&this._layerViewHost.selectObject(this._selectionFromEventPoint(e)),delete this._mouseDownX,delete this._mouseDownY}_onDoubleClick(e){const t=this._selectionFromEventPoint(e);t&&("Snapshot"===t.type()||t.layer())&&this.dispatchEventToListeners(he.PaintProfilerRequested,t),e.stopPropagation()}_updatePaints(){this._showPaints()?(this._textureManager.setLayerTree(this._layerTree),this._textureManager.forceUpdate()):this._textureManager.reset(),this._update()}_showPaints(){return!!this._showPaintsSetting&&this._showPaintsSetting.get()}}var le,he;!function(e){e.Hovered="hovered",e.Selected="selected"}(le||(le={})),function(e){e.PaintProfilerRequested="PaintProfilerRequested",e.ScaleChanged="ScaleChanged"}(he||(he={}));const ce="precision mediump float;\nvarying vec4 vColor;\nvarying vec2 vTextureCoord;\nuniform sampler2D uSampler;\nvoid main(void)\n{\n    gl_FragColor = texture2D(uSampler, vec2(vTextureCoord.s, vTextureCoord.t)) * vColor;\n}",de="attribute vec3 aVertexPosition;\nattribute vec2 aTextureCoord;\nattribute vec4 aVertexColor;\nuniform mat4 uPMatrix;\nvarying vec2 vTextureCoord;\nvarying vec4 vColor;\nvoid main(void)\n{\ngl_Position = uPMatrix * vec4(aVertexPosition, 1.0);\nvColor = aVertexColor;\nvTextureCoord = aTextureCoord;\n}",_e=[0,0,255,1],ue=[0,255,0,1],pe=[0,0,0,1],me=[160,160,160,1],ge=[178,100,100,.6],ye=[200,200,255,1],fe=1,we=2,ve=3,Ce=20,Se=4;class be{constructor(e){this._textureUpdatedCallback=e,this._throttler=new f.Throttler(0),this._scale=0,this._active=!1,this.reset()}static _createTextureForImage(e,t){if(!e)throw new Error("WebGLRenderingContext not provided");const i=e.createTexture();if(!i)throw new Error("Unable to create texture");return oe.set(i,t),e.bindTexture(e.TEXTURE_2D,i),e.pixelStorei(e.UNPACK_FLIP_Y_WEBGL,1),e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,t),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MIN_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_MAG_FILTER,e.LINEAR),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE),e.texParameteri(e.TEXTURE_2D,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE),e.bindTexture(e.TEXTURE_2D,null),i}reset(){this._tilesByLayer&&this.setLayerTree(null),this._tilesByLayer=new Map,this._queue=[]}setContext(e){this._gl=e,this._scale&&this._updateTextures()}suspend(){this._active=!1}resume(){this._active=!0,this._queue.length&&this._update()}setLayerTree(e){const t=new Set,i=Array.from(this._tilesByLayer.keys());e&&e.forEachLayer((e=>{e.drawsContent()&&(t.add(e),this._tilesByLayer.has(e)||(this._tilesByLayer.set(e,[]),this.layerNeedsUpdate(e)))})),i.length||this.forceUpdate();for(const e of i){if(t.has(e))continue;const i=this._tilesByLayer.get(e);i&&i.forEach((e=>e.dispose())),this._tilesByLayer.delete(e)}}_setSnapshotsForLayer(e,t){const i=new Map((this._tilesByLayer.get(e)||[]).map((e=>[e.snapshot,e]))),s=[],r=[];for(const e of t){const t=i.get(e.snapshot);t?(r.push(t),i.delete(e.snapshot)):s.push(new xe(e))}this._tilesByLayer.set(e,r.concat(s));for(const e of i.values())e.dispose();const n=this._gl;return n&&this._scale?Promise.all(s.map((e=>e.update(n,this._scale)))).then(this._textureUpdatedCallback):Promise.resolve()}setScale(e){this._scale&&this._scale>=e||(this._scale=e,this._updateTextures())}tilesForLayer(e){return this._tilesByLayer.get(e)||[]}layerNeedsUpdate(e){this._queue.indexOf(e)<0&&this._queue.push(e),this._active&&this._throttler.schedule(this._update.bind(this))}forceUpdate(){this._queue.forEach((e=>this._updateLayer(e))),this._queue=[],this._update()}_update(){const e=this._queue.shift();return e?(this._queue.length&&this._throttler.schedule(this._update.bind(this)),this._updateLayer(e)):Promise.resolve()}_updateLayer(e){return Promise.all(e.snapshots()).then((t=>this._setSnapshotsForLayer(e,t.filter((e=>null!==e)))))}_updateTextures(){if(this._gl&&this._scale)for(const e of this._tilesByLayer.values())for(const t of e){const e=t.updateScale(this._gl,this._scale);e&&e.then(this._textureUpdatedCallback)}}}class Pe{constructor(e){this.relatedObject=e,this.lineWidth=1,this.borderColor=null,this.fillColor=null,this.texture=null}setVertices(e,t){this.vertices=[e[0],e[1],t,e[2],e[3],t,e[4],e[5],t,e[6],e[7],t]}_calculatePointOnQuad(e,t,i){const s=e[0],r=e[1],n=e[2],o=e[3],a=e[4],l=e[5],h=e[6],c=e[7],d=s+t*(n-s),_=r+t*(o-r);return[d+i*(h+t*(a-h)-d),_+i*(c+t*(l-c)-_)]}calculateVerticesFromRect(e,t,i){const s=e.quad(),r=t.x/e.width(),n=(t.x+t.width)/e.width(),o=t.y/e.height(),a=(t.y+t.height)/e.height(),l=this._calculatePointOnQuad(s,r,o).concat(this._calculatePointOnQuad(s,n,o)).concat(this._calculatePointOnQuad(s,n,a)).concat(this._calculatePointOnQuad(s,r,a));this.setVertices(l,i)}intersectWithLine(e,t,i){let s;const r=[];for(s=0;s<4;++s)r[s]=u.multiplyVectorByMatrixAndNormalize(new u.Vector(this.vertices[3*s],this.vertices[3*s+1],this.vertices[3*s+2]),e);const n=u.crossProduct(u.subtract(r[1],r[0]),u.subtract(r[2],r[1])),o=n.x,a=n.y,l=n.z,h=-(-(o*r[0].x+a*r[0].y+l*r[0].z)+o*t+a*i)/l,c=new u.Vector(t,i,h),d=r.map(u.subtract.bind(null,c));for(s=0;s<d.length;++s){if(u.scalarProduct(n,u.crossProduct(d[s],d[(s+1)%d.length]))<0)return}return h}}class xe{constructor(e){this.snapshot=e.snapshot,this.rect=e.rect,this.scale=0,this.texture=null}dispose(){this.snapshot.release(),this.texture&&(this._gl.deleteTexture(this.texture),this.texture=null)}updateScale(e,t){return this.texture&&this.scale>=t?null:this.update(e,t)}async update(e,t){this._gl=e,this.scale=t;const i=await this.snapshot.replay(t),s=i?await a.loadImage(i):null;this.texture=s?be._createTextureForImage(e,s):null}}var Te=Object.freeze({__proto__:null,UIStrings:J,Layers3DView:ae,get OutlineType(){return le},get Events(){return he},FragmentShader:ce,VertexShader:de,HoveredBorderColor:_e,SelectedBorderColor:ue,BorderColor:pe,ViewportBorderColor:me,ScrollRectBackgroundColor:ge,HoveredImageMaskColor:ye,BorderWidth:fe,SelectedBorderWidth:we,ViewportBorderWidth:ve,LayerSpacing:Ce,ScrollRectSpacing:Se,LayerTextureManager:be,Rectangle:Pe,Tile:xe});const Le={profiling:"Profiling…",shapes:"Shapes",bitmap:"Bitmap",text:"Text",misc:"Misc",profilingResults:"Profiling results",commandLog:"Command Log"},Ee=e.registerUIStrings("layer_viewer/PaintProfilerView.ts",Le),Re=e.getLocalizedString.bind(void 0,Ee);let Ie=null,He=null;class De extends n.HBox{constructor(e){super(!0),this.registerRequiredCSS("layer_viewer/paintProfiler.css",{enableLegacyPatching:!0}),this.contentElement.classList.add("paint-profiler-overview"),this._canvasContainer=this.contentElement.createChild("div","paint-profiler-canvas-container"),this._progressBanner=this.contentElement.createChild("div","full-widget-dimmed-banner hidden"),this._progressBanner.textContent=Re(Le.profiling),this._pieChart=new w.PieChart,this._populatePieChart(0,[]),this._pieChart.classList.add("paint-profiler-pie-chart"),this.contentElement.appendChild(this._pieChart),this._showImageCallback=e,this._canvas=this._canvasContainer.createChild("canvas","fill"),this._context=this._canvas.getContext("2d"),this._selectionWindow=new v.Window(this._canvasContainer),this._selectionWindow.addEventListener(v.Events.WindowChanged,this._onWindowChanged,this),this._innerBarWidth=4*window.devicePixelRatio,this._minBarHeight=window.devicePixelRatio,this._barPaddingWidth=2*window.devicePixelRatio,this._outerBarWidth=this._innerBarWidth+this._barPaddingWidth,this._pendingScale=1,this._scale=this._pendingScale,this._samplesPerBar=0,this._log=[],this._reset()}static categories(){return Ie||(Ie={shapes:new Ae("shapes",Re(Le.shapes),"rgb(255, 161, 129)"),bitmap:new Ae("bitmap",Re(Le.bitmap),"rgb(136, 196, 255)"),text:new Ae("text",Re(Le.text),"rgb(180, 255, 137)"),misc:new Ae("misc",Re(Le.misc),"rgb(206, 160, 255)")}),Ie}static _initLogItemCategories(){if(!He){const e=De.categories(),t={};t.Clear=e.misc,t.DrawPaint=e.misc,t.DrawData=e.misc,t.SetMatrix=e.misc,t.PushCull=e.misc,t.PopCull=e.misc,t.Translate=e.misc,t.Scale=e.misc,t.Concat=e.misc,t.Restore=e.misc,t.SaveLayer=e.misc,t.Save=e.misc,t.BeginCommentGroup=e.misc,t.AddComment=e.misc,t.EndCommentGroup=e.misc,t.ClipRect=e.misc,t.ClipRRect=e.misc,t.ClipPath=e.misc,t.ClipRegion=e.misc,t.DrawPoints=e.shapes,t.DrawRect=e.shapes,t.DrawOval=e.shapes,t.DrawRRect=e.shapes,t.DrawPath=e.shapes,t.DrawVertices=e.shapes,t.DrawDRRect=e.shapes,t.DrawBitmap=e.bitmap,t.DrawBitmapRectToRect=e.bitmap,t.DrawBitmapMatrix=e.bitmap,t.DrawBitmapNine=e.bitmap,t.DrawSprite=e.bitmap,t.DrawPicture=e.bitmap,t.DrawText=e.text,t.DrawPosText=e.text,t.DrawPosTextH=e.text,t.DrawTextOnPath=e.text,He=t}return He}static _categoryForLogItem(e){const t=i.toTitleCase(e.method),s=De._initLogItemCategories();let r=s[t];return r||(r=De.categories().misc,s[t]=r),r}onResize(){this._update()}async setSnapshotAndLog(e,t,i){if(this._reset(),this._snapshot=e,this._snapshot&&this._snapshot.addReference(),this._log=t,this._logCategories=this._log.map(De._categoryForLogItem),!e)return this._update(),this._populatePieChart(0,[]),void this._selectionWindow.setEnabled(!1);this._selectionWindow.setEnabled(!0),this._progressBanner.classList.remove("hidden"),this._updateImage();const s=await e.profile(i);this._progressBanner.classList.add("hidden"),this._profiles=s,this._update(),this._updatePieChart()}setScale(e){const t=e>this._scale;this._pendingScale=Math.min(1,2*e),t&&this._snapshot&&this._updateImage()}_update(){if(this._canvas.width=this._canvasContainer.clientWidth*window.devicePixelRatio,this._canvas.height=this._canvasContainer.clientHeight*window.devicePixelRatio,this._samplesPerBar=0,!this._profiles||!this._profiles.length||!this._logCategories)return;const e=Math.floor((this._canvas.width-2*this._barPaddingWidth)/this._outerBarWidth),t=this._log.length;this._samplesPerBar=Math.ceil(t/e);let i=0;const s=[],r=[];let n={};for(let e=0,o=0,a=0;e<t;){let l=this._logCategories[e]&&this._logCategories[e].name||"misc";const h=this._log[e].commandIndex;for(let e=0;e<this._profiles.length;e++){const t=this._profiles[e][h];a+=t,n[l]=(n[l]||0)+t}if(++e,e-o===this._samplesPerBar||e===t){const t=this._profiles.length*(e-o);for(l in a/=t,n)n[l]/=t;s.push(a),r.push(n),a>i&&(i=a),a=0,n={},o=e}}const o=4*window.devicePixelRatio,a=(this._canvas.height-o-this._minBarHeight)/i;for(let e=0;e<s.length;++e){for(const t in r[e])r[e][t]*=(s[e]*a+this._minBarHeight)/s[e];this._renderBar(e,r[e])}}_renderBar(e,t){const i=De.categories();let s=0;const r=this._barPaddingWidth+e*this._outerBarWidth;for(const e in i){if(!t[e])continue;s+=t[e];const n=this._canvas.height-s;this._context.fillStyle=i[e].color,this._context.fillRect(r,n,this._innerBarWidth,t[e])}}_onWindowChanged(){this.dispatchEventToListeners(Oe.WindowChanged),this._updatePieChart(),this._updateImageTimer||(this._updateImageTimer=window.setTimeout(this._updateImage.bind(this),100))}_updatePieChart(){const{total:e,slices:t}=this._calculatePieChart();this._populatePieChart(e,t)}_calculatePieChart(){const e=this.selectionWindow();if(!this._profiles||!this._profiles.length||!e)return{total:0,slices:[]};let t=0;const i={};for(let s=e.left;s<e.right;++s){const e=this._log[s],r=De._categoryForLogItem(e);i[r.color]=i[r.color]||0;for(let s=0;s<this._profiles.length;++s){const n=this._profiles[s][e.commandIndex];t+=n,i[r.color]+=n}}const s=[];for(const e in i)s.push({value:i[e]/this._profiles.length,color:e,title:""});return{total:t/this._profiles.length,slices:s}}_populatePieChart(e,t){this._pieChart.data={chartName:Re(Le.profilingResults),size:55,formatter:this._formatPieChartTime.bind(this),showLegend:!1,total:e,slices:t}}_formatPieChartTime(e){return Number.millisToString(1e3*e,!0)}selectionWindow(){if(!this._log)return null;const e=(this._selectionWindow.windowLeft||0)*this._canvas.width,i=(this._selectionWindow.windowRight||0)*this._canvas.width,s=Math.floor(e/this._outerBarWidth),r=Math.floor((i+this._innerBarWidth-this._barPaddingWidth/2)/this._outerBarWidth);return{left:t.clamp(s*this._samplesPerBar,0,this._log.length-1),right:t.clamp(r*this._samplesPerBar,0,this._log.length)}}_updateImage(){let e,t;delete this._updateImageTimer;const i=this.selectionWindow();this._profiles&&this._profiles.length&&i&&(e=this._log[i.left].commandIndex,t=this._log[i.right-1].commandIndex);const s=this._pendingScale;this._snapshot&&this._snapshot.replay(s,e,t).then((e=>{e&&(this._scale=s,this._showImageCallback(e))}))}_reset(){this._snapshot&&this._snapshot.release(),this._snapshot=null,this._profiles=null,this._selectionWindow.reset(),this._selectionWindow.setEnabled(!1)}}var Oe;(Oe||(Oe={})).WindowChanged="WindowChanged";class Me extends m.ThrottledWidget{constructor(){super(),this.setMinimumSize(100,25),this.element.classList.add("overflow-auto"),this._treeOutline=new h.TreeOutlineInShadow,l.setAccessibleName(this._treeOutline.contentElement,Re(Le.commandLog)),this.element.appendChild(this._treeOutline.element),this.setDefaultFocusedElement(this._treeOutline.contentElement),this._log=[],this._treeItemCache=new Map}setCommandLog(e){this._log=e,this.updateWindow({left:0,right:this._log.length})}_appendLogItem(e){let t=this._treeItemCache.get(e);if(t){if(t.parent)return}else t=new Be(this,e),this._treeItemCache.set(e,t);this._treeOutline.appendChild(t)}updateWindow(e){this._selectionWindow=e,this.update()}doUpdate(){if(!this._selectionWindow||!this._log.length)return this._treeOutline.removeChildren(),Promise.resolve();const e=this._treeOutline.rootElement();for(;;){const t=e.firstChild();if(!t||t._logItem.commandIndex>=this._selectionWindow.left)break;e.removeChildAtIndex(0)}for(;;){const t=e.lastChild();if(!t||t._logItem.commandIndex<this._selectionWindow.right)break;e.removeChildAtIndex(e.children().length-1)}for(let e=this._selectionWindow.left,t=this._selectionWindow.right;e<t;++e)this._appendLogItem(this._log[e]);return Promise.resolve()}}class Be extends h.TreeElement{constructor(e,t){super("",Boolean(t.params)),this._logItem=t,this._ownerView=e,this._filled=!1}onattach(){this._update()}async onpopulate(){for(const e in this._logItem.params)ke._appendLogPropertyItem(this,e,this._logItem.params[e])}_paramToString(e,t){if("object"!=typeof e)return"string"==typeof e&&e.length>100?t:JSON.stringify(e);let i="",s=0;for(const r in e){if(++s>4||"object"==typeof e[r]||"string"==typeof e[r]&&e[r].length>100)return t;i&&(i+=", "),i+=e[r]}return i}_paramsToString(e){let t="";for(const i in e)t&&(t+=", "),t+=this._paramToString(e[i],i);return t}_update(){const e=document.createDocumentFragment();a.createTextChild(e,this._logItem.method+"("+this._paramsToString(this._logItem.params)+")"),this.title=e}}class ke extends h.TreeElement{constructor(e){super(),this._property=e}static _appendLogPropertyItem(e,t,i){const s=new ke({name:t,value:i});if(e.appendChild(s),i&&"object"==typeof i)for(const e in i)ke._appendLogPropertyItem(s,e,i[e])}onattach(){const e=document.createDocumentFragment();e.createChild("span","name").textContent=this._property.name;if(e.createChild("span","separator").textContent=": ",null===this._property.value||"object"!=typeof this._property.value){const t=e.createChild("span","value");t.textContent=JSON.stringify(this._property.value),t.classList.add("cm-js-"+(null===this._property.value?"null":typeof this._property.value))}this.title=e}}class Ae{constructor(e,t,i){this.name=e,this.title=t,this.color=i}}var Fe=Object.freeze({__proto__:null,UIStrings:Le,PaintProfilerView:De,get Events(){return Oe},PaintProfilerCommandLogView:Me,LogTreeElement:Be,LogPropertyTreeElement:ke,PaintProfilerCategory:Ae});export{A as LayerDetailsView,Y as LayerTreeOutline,E as LayerViewHost,Te as Layers3DView,Fe as PaintProfilerView,Z as TransformController};
