#!/usr/local/bin/wish8.5 -f
#  'CBB' -- Check Book Balancer
#
#   init.tcl -- Initialization routines.
#
#  Written by Curtis Olson.  Started December 7, 1996.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# $Id: init.tcl,v 2.18 1997/06/12 21:53:14 curt Exp $
# (Log is kept at end of this file)


# ----------------------------------------------------------------------------
# Draw splash screen on startup
# ----------------------------------------------------------------------------

proc cbb_splash {} {                                              
    global lib_path

    toplevel .x -bd 3 -relief raised
    wm withdraw .x
    set sw [winfo screenwidth .]
    set sh [winfo screenheight .]
    image create photo "title" -file "$lib_path/images/splash-32.gif"
    wm overrideredirect .x 1
    label .x.l -image title -bd 1 -relief sunken
    pack .x.l -side top -expand 1 -fill both
    set x [expr ($sw - 200)/2]
    set y [expr ($sh - 250)/2]
    wm geometry .x +$x+$y
    wm deiconify .x
    update idletasks
    after 3000 {destroy .x}
}


# ----------------------------------------------------------------------------
# Initialize CBB
# ----------------------------------------------------------------------------

proc cbb_setup {} {
    global tcl_precision cbb eng lib_path

    # lets get this out of the way right away ... increases the precision.
    set tcl_precision 17

    # initialize the variables
    cbb_init_vars

    # open a two way pipe to the perl engine.
    set eng [open |$lib_path/wrapper.pl r+]

    # Set debugging flag on/off in perl engine
    puts $eng "debug $cbb(debug)"; flush $eng
    gets $eng result
    if { $cbb(debug) } { puts $result }

    # Set cache flag on/off in perl engine
    puts $eng "cache $cbb(cache)"; flush $eng
    gets $eng result
    if { $cbb(debug) } { puts $result }

    # If Crypt is activated, ask for password
    if { $cbb(use_crypt) } { useCrypt }

    # Determine what century we are in (used as the default when not specified)
    puts $eng "century"; flush $eng
    gets $eng cbb(century)
    if { $cbb(debug) } { puts "Our current year starts with $cbb(century)" }

    # parse the command line
    parse_command_line

    # setup the main window
    setup_main

    # Load a data file if one is specified on command line or in the 
    # $cbb(save_cur_file)
    if { "$cbb(cur_file)" != "noname.cbb" } {
	# if cbb(save_cur_file) file overwrote the default cur_file or file 
	# specified on command line

	load_acct_listbox
	acctLoadFile $cbb(cur_file)
	cd [file dirname $cbb(cur_file)]
    }

    # make sure we have a backup file being saved ... automatically
    setup_auto_save

    # initialize main window bindings
    setup_default_binding

    # initialize undo
    undoInit

    # Remind user to remove ~/.cbbrc if it still exists.
    if { [file exists "~/.cbbrc"] } {
	cbbWindow.ok "You can remove your ``.cbbrc'' file because it is \
		obsolete.  It has been replaced with a ``.cbbrc.tcl'' file."
	tkwait window .ok
    }

    # If the user doesn't have a ~/.cbbrc.tcl file, create one for him.
    if { [file exists $cbb(conf_file)] } {
	# it exists, don't bother right now
    } else {
	cbbrcSave
    }

    # This should remain the last thing in the setup procedure.  It leaves 
    # a welcome message at the bottom of the window.

    .status.line configure -text "Welcome to the Check Book Balancer."
    update
}


# ----------------------------------------------------------------------------
# Initialize CBB Variables
# ----------------------------------------------------------------------------

proc cbb_init_vars {} {
    global cbb env

    # Set global variables

    acctSetClean
    set cbb(author_xbm) "author.xbm"
    set cbb(century) 19
    set cbb(conf_file) "$env(HOME)/.cbbrc.tcl"
    set cbb(save_cur_file) "$env(HOME)/.cbbcur.tcl"
    set cbb(cur_date) ""
    set cbb(cur_file) "noname.cbb"
    set cbb(def_cat) "default.cat"
    set cbb(devel) 0
    set cbb(help_text) "cbb-man.txt"
    set cbb(icon_xbm) "cbb.xbm"
    set cbb(index1) 0
    set cbb(index2) 0
    set cbb(next_chk) 0
    set cbb(no_more_mem) 0
    set cbb(safe_mode) 0
    set cbb(selected) 0
    set cbb(state_start) 0.00
    set cbb(state_end) 0.00
    set cbb(version) "Version 0.73"

    # Preferences changed
    set cbb(pref_chg) 0

    # internal Startdate
    set cbb(int_sdate) "0"

    # code to use for cryptography
    set cbb(crypt_code) ""

    # The following defaults are over ridden by $cbb(CONF_FILE)

    set cbb(auto_hilite) 1
    set cbb(button_font) "-Adobe-Helvetica-Bold-R-Normal-*-*-120-*-*-*-*-*-*"
    set cbb(date_fmt) 1
    set cbb(debug) 0
    set cbb(default_font) "-Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-*"
    set cbb(dialog_font) "-Adobe-Helvetica-Bold-R-Normal-*-*-120-*-*-*-*-*-*"
    set cbb(fixed_font) "8x13"
    set cbb(fixed_header_font) "8x13"
    set cbb(head_color) #00008f
    set cbb(hilite_color) #8080b0
    set cbb(list_line1_color) ""
    set cbb(list_line2_color) grey78
    set cbb(list_height) 28
    set cbb(list_width) 70
    set cbb(acctlist_height) 5
    set cbb(max_splits) 16
    set cbb(menu_font) "-Adobe-Helvetica-Medium-R-Normal-*-*-120-*-*-*-*-*-*"
    set cbb(msg_text_font) "-Adobe-Helvetica-Bold-R-Normal-*-*-120-*-*-*-*-*-*"
    # 1000 milleseconds = 1 second (save_interval is specified in milleseconds)
    set cbb(save_interval) 180000
    set cbb(auto_save) 0
    set cbb(status_line_font) \
	    "-Adobe-Helvetica-Bold-R-Normal-*-*-120-*-*-*-*-*-*"
    set cbb(use_mems) 1
    set cbb(balloon,on) 1
    set cbb(web_browser) "netscape"

    # start time
    set cbb(sdate) ""
    set cbb(use_sdate) 0

    # account cache
    set cbb(cache) 0

    # use cryptography ?
    set cbb(use_crypt) 0
    set cbb(encrypt) ""
    set cbb(decrypt) ""

    # Ok, so lets override them if we can ...
    if { [file exists $cbb(conf_file)] } {
	source $cbb(conf_file)
    }
    if { [file exists $cbb(save_cur_file)] } {
	source $cbb(save_cur_file)
    }

    # allow the user to put their own custom commands in ~/.wishrc
    if { [file exists "~/.wishrc"] } {
	source "~/.wishrc"
    }
}


# ----------------------------------------------------------------------------
# Parse command line arguments
# ----------------------------------------------------------------------------

proc parse_command_line {} {
    global cbb argc argv argv0 eng

    if { [expr $argc >= 1] } {
	# process command line arguments
 
	set i 0
	while { $i < $argc } {
	    set arg [lindex $argv $i]
 
	    if { $cbb(debug) } { puts "arg$i = $arg" }
	    
	    if { [string range $arg 0 0] == "-" } {
		if { $cbb(debug) } { puts "this is a 'dash' option" }
 
		if { "$arg" == "--safe" } {
		    if { $cbb(debug) } { puts "setting safe mode" }
		    set cbb(safe_mode) 1
		} elseif { "$arg" == "--debug" } {
		    if { $cbb(debug) } { puts "forcing debug on" }
		    set cbb(debug) 1
		    # Set debugging flag on/off in perl engine
		    puts $eng "debug $cbb(debug)"; flush $eng
		    gets $eng result
		    if { $cbb(debug) } { puts $result }
		} elseif { "$arg" == "--devel" } {
		    if { $cbb(debug) } { puts "Including Developer options" }
		    set cbb(devel) 1
		} elseif { "$arg" == "--version" } {
		    puts "CBB $cbb(version)"
		    exit
		} else {
		    puts "Usage: [file tail $argv0] \[--safe\]\
			    \[--debug\] \[--devel\] \[--version\] \[file_name\]"
		    exit
		}
	    } else {
		set cbb(cur_file) $arg
	    }
	    incr i
	}
    }
}


# ----------------------------------------------------------------------------
# $Log: init.tcl,v $
# Revision 2.18  1997/06/12 21:53:14  curt
# Applied more patches from Martin Schenk <schenkm@ping.at>.  His changes
# greatly improved and developed the preferences menu so it is now actually
# usable to set preferences.
# Current data file is now saved in ~/.cbbcur.tcl
#
# Revision 2.17  1997/05/06 01:00:24  curt
# Added patches contributed by Martin Schenk <schenkm@ping.at>
# - Default to umask of 066 so .CBB files get created rw by owner only
# - Added support for pgp encrypting data files
# - Added support for displaying only recent parts of files (avoids
#   waiting to load in lots of old txns you don't currently need.)
# - Added a feature to "cache" whole accounts in the perl engine so
#   that switching between accounts can be faster.
# - The above options can be turned on/off via the preferrences menu.
#
# Revision 2.16  1997/04/23 18:08:48  curt
# Source ~/.wishrc.tcl on startup if it exists.
#
# Revision 2.15  1997/04/16 20:30:25  curt
# Reduced color version of splash.gif renamed to splash-32.gif
#
# Revision 2.14  1997/04/07 21:13:33  curt
# Add a $cbb(web_browser) variable which can be set from ~/.cbbrc.tcl
# If netscape is the browser, and there is a copy running, don't start
# a new copy.
#
# Revision 2.13  1997/04/03 03:54:48  curt
# Enable auto save without prompting when switching to a new account.
# Contributed by Jonathan I. Kamens <jik@kamens.brookline.ma.us>
#
# Revision 2.12  1997/04/03 03:40:29  curt
# Added a --version option.
#
# Revision 2.11  1997/01/10 22:03:31  curt
# Transfer fixups and a few other misc. fixes contributed by
#   Lionel Mallet <Lionel.Mallet@sophia.inria.fr>
#
# Revision 2.10  1997/01/09 04:03:03  curt
# Allow user to specify colors of alternating transaction lines.
#
# Revision 2.9  1997/01/09 03:56:58  curt
# Added contrib script loan.pl.
# User sizable account list.
# Removed some old gnuplot baggage from install.pl.
#
# Revision 2.8  1997/01/02 04:38:35  curt
# Changes over the 1996 holidays:
#   - Converted listbox to text widget.  This allows us to do nice
#     things with alternating background colors, highliting, red
#     negative numbers, etc.
#   - Negative transactions are now drawn in red.
#   - Added a Goto <Today> option.
#   - <Home> & <End> were double bound.  Now, listbox can be traversed with
#     <Meta-Home> and <Meta-End>
#
# Revision 2.7  1996/12/17 14:53:58  curt
# Updated copyright date.
#
# Revision 2.6  1996/12/16 04:18:18  curt
# Continuing the great overhaul of December 1996.
#
# Revision 2.5  1996/12/14 17:15:23  curt
# The great overhaul of December '96.
#
# Revision 2.4  1996/12/11 04:32:29  curt
# Several minor tweaks.
#
# Revision 2.3  1996/12/11 01:03:42  curt
# Added balloon help support.
#
# Revision 2.2  1996/12/09 23:54:54  curt
# Updated splash screen image.
#
# Revision 2.1  1996/12/08 07:37:49  curt
# Initial revision.
#

