/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashMap;

public class HashMappedList
extends HashMap {
    public HashMappedList() {
        this(8);
    }

    public HashMappedList(int n) throws IllegalArgumentException {
        super(n);
        this.isList = true;
    }

    public Object get(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return this.objectValueTable[n];
    }

    @Override
    public Object remove(Object object) {
        int n = this.getLookup(object, object.hashCode());
        if (n < 0) {
            return null;
        }
        Object object2 = super.remove(object);
        this.removeRow(n);
        return object2;
    }

    public Object remove(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return this.remove(this.objectKeyTable[n]);
    }

    public boolean add(Object object, Object object2) {
        int n = this.getLookup(object, object.hashCode());
        if (n >= 0) {
            return false;
        }
        super.put(object, object2);
        return true;
    }

    @Override
    public Object put(Object object, Object object2) {
        return super.put(object, object2);
    }

    public Object set(int n, Object object) throws IndexOutOfBoundsException {
        this.checkRange(n);
        Object object2 = this.objectKeyTable[n];
        this.objectKeyTable[n] = object;
        return object2;
    }

    public boolean insert(int n, Object object, Object object2) throws IndexOutOfBoundsException {
        int n2;
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.getLookup(object, object.hashCode());
        if (n3 >= 0) {
            return false;
        }
        if (n == this.size()) {
            return this.add(object, object2);
        }
        HashMappedList hashMappedList = new HashMappedList(this.size());
        for (n2 = n; n2 < this.size(); ++n2) {
            hashMappedList.add(this.getKey(n2), this.get(n2));
        }
        for (n2 = this.size() - 1; n2 >= n; --n2) {
            this.remove(n2);
        }
        for (n2 = 0; n2 < hashMappedList.size(); ++n2) {
            this.add(hashMappedList.getKey(n2), hashMappedList.get(n2));
        }
        return true;
    }

    public boolean set(int n, Object object, Object object2) throws IndexOutOfBoundsException {
        this.checkRange(n);
        if (this.keySet().contains(object) && this.getIndex(object) != n) {
            return false;
        }
        super.remove(this.objectKeyTable[n]);
        super.put(object, object2);
        return true;
    }

    public boolean setKey(int n, Object object) throws IndexOutOfBoundsException {
        this.checkRange(n);
        Object object2 = this.objectValueTable[n];
        return this.set(n, object, object2);
    }

    public boolean setValue(int n, Object object) throws IndexOutOfBoundsException {
        Object object2 = this.objectValueTable[n];
        boolean bl = object == null ? object2 != null : !object.equals(object2);
        this.objectValueTable[n] = object;
        return bl;
    }

    public Object getKey(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        return this.objectKeyTable[n];
    }

    public int getIndex(Object object) {
        return this.getLookup(object, object.hashCode());
    }

    public Object[] toValuesArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray == null || objectArray.length < n) {
            objectArray = new Object[n];
        }
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.objectValueTable[i];
        }
        return objectArray;
    }

    public Object[] toKeysArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray == null || objectArray.length < n) {
            objectArray = new Object[n];
        }
        if (n > 0) {
            System.arraycopy(this.objectKeyTable, 0, objectArray, 0, n);
        }
        return objectArray;
    }

    private void checkRange(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

