/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import com.beust.jcommander.Parameter;
import jadx.api.JadxArgs;
import jadx.cli.JadxCLIArgs;
import jadx.cli.LogHelper;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.settings.WindowLocation;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.EditorTheme;
import jadx.gui.utils.FontUtils;
import jadx.gui.utils.LangLocale;
import jadx.gui.utils.NLS;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.JFrame;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxSettings
extends JadxCLIArgs {
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettings.class);
    private static final Path USER_HOME = Paths.get(System.getProperty("user.home"), new String[0]);
    private static final int RECENT_PROJECTS_COUNT = 15;
    private static final int CURRENT_SETTINGS_VERSION = 9;
    private static final Font DEFAULT_FONT = new RSyntaxTextArea().getFont();
    static final Set<String> SKIP_FIELDS = new HashSet<String>(Arrays.asList("files", "input", "outDir", "outDirSrc", "outDirRes", "outputFormat", "verbose", "quiet", "logLevel", "printVersion", "printHelp"));
    private Path lastSaveProjectPath = USER_HOME;
    private Path lastOpenFilePath = USER_HOME;
    private Path lastSaveFilePath = USER_HOME;
    private boolean flattenPackage = false;
    private boolean checkForUpdates = false;
    private List<Path> recentProjects = new ArrayList<Path>();
    private String fontStr = "";
    private String editorThemePath = "";
    private LangLocale langLocale = NLS.defaultLocale();
    private boolean autoStartJobs = false;
    protected String excludedPackages = "";
    private boolean autoSaveProject = false;
    private boolean showHeapUsageBar = true;
    private Map<String, WindowLocation> windowPos = new HashMap<String, WindowLocation>();
    private int mainWindowExtendedState = 0;
    private int treeWidth = 130;
    private int settingsVersion = 0;
    @JadxSettingsAdapter.GsonExclude
    @Parameter(names={"-sc", "--select-class"}, description="GUI: Open the selected class and show the decompiled code")
    private String cmdSelectClass = null;

    public static JadxSettings makeDefault() {
        JadxSettings jadxSettings = new JadxSettings();
        jadxSettings.fixOnLoad();
        return jadxSettings;
    }

    public void sync() {
        JadxSettingsAdapter.store(this);
    }

    private void partialSync(Consumer<JadxSettings> updater) {
        JadxSettings settings = JadxSettingsAdapter.load();
        updater.accept(settings);
        JadxSettingsAdapter.store(settings);
    }

    public void fixOnLoad() {
        if (this.threadsCount <= 0) {
            this.threadsCount = JadxArgs.DEFAULT_THREADS_COUNT;
        }
        if (this.deobfuscationMinLength < 0) {
            this.deobfuscationMinLength = 0;
        }
        if (this.deobfuscationMaxLength < 0) {
            this.deobfuscationMaxLength = 0;
        }
        if (this.settingsVersion != 9) {
            this.upgradeSettings(this.settingsVersion);
        }
    }

    public String getCmdSelectClass() {
        return this.cmdSelectClass;
    }

    public Path getLastOpenFilePath() {
        return this.lastOpenFilePath;
    }

    public void setLastOpenFilePath(Path lastOpenFilePath) {
        this.lastOpenFilePath = lastOpenFilePath;
        this.partialSync(settings -> {
            settings.lastOpenFilePath = lastOpenFilePath;
        });
    }

    public Path getLastSaveProjectPath() {
        return this.lastSaveProjectPath;
    }

    public Path getLastSaveFilePath() {
        return this.lastSaveFilePath;
    }

    public void setLastSaveProjectPath(Path lastSaveProjectPath) {
        this.lastSaveProjectPath = lastSaveProjectPath;
        this.partialSync(settings -> {
            settings.lastSaveProjectPath = lastSaveProjectPath;
        });
    }

    public void setLastSaveFilePath(Path lastSaveFilePath) {
        this.lastSaveFilePath = lastSaveFilePath;
        this.partialSync(settings -> {
            settings.lastSaveFilePath = lastSaveFilePath;
        });
    }

    public boolean isFlattenPackage() {
        return this.flattenPackage;
    }

    public void setFlattenPackage(boolean flattenPackage) {
        this.flattenPackage = flattenPackage;
        this.partialSync(settings -> {
            settings.flattenPackage = flattenPackage;
        });
    }

    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    public void setCheckForUpdates(boolean checkForUpdates) {
        this.checkForUpdates = checkForUpdates;
        this.sync();
    }

    public Iterable<Path> getRecentProjects() {
        return this.recentProjects;
    }

    public void addRecentProject(Path projectPath) {
        this.recentProjects.remove(projectPath);
        this.recentProjects.add(0, projectPath);
        int count = this.recentProjects.size();
        if (count > 15) {
            this.recentProjects.subList(15, count).clear();
        }
        this.partialSync(settings -> {
            settings.recentProjects = this.recentProjects;
        });
    }

    public void saveWindowPos(Window window) {
        WindowLocation pos = new WindowLocation(window.getClass().getSimpleName(), window.getBounds());
        this.windowPos.put(pos.getWindowId(), pos);
        this.partialSync(settings -> {
            settings.windowPos = this.windowPos;
        });
    }

    public boolean loadWindowPos(Window window) {
        int extendedState;
        WindowLocation pos = this.windowPos.get(window.getClass().getSimpleName());
        if (pos == null || pos.getBounds() == null) {
            return false;
        }
        if (window instanceof MainWindow && (extendedState = this.getMainWindowExtendedState()) != 0) {
            ((JFrame)window).setExtendedState(extendedState);
            return true;
        }
        if (!JadxSettings.isContainedInAnyScreen(pos)) {
            return false;
        }
        window.setBounds(pos.getBounds());
        return true;
    }

    private static boolean isContainedInAnyScreen(WindowLocation pos) {
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            if (!gd.getDefaultConfiguration().getBounds().contains(pos.getBounds())) continue;
            return true;
        }
        return false;
    }

    public boolean isShowHeapUsageBar() {
        return this.showHeapUsageBar;
    }

    public void setShowHeapUsageBar(boolean showHeapUsageBar) {
        this.showHeapUsageBar = showHeapUsageBar;
        this.partialSync(settings -> {
            settings.showHeapUsageBar = showHeapUsageBar;
        });
    }

    public String getExcludedPackages() {
        return this.excludedPackages;
    }

    public void setExcludedPackages(String excludedPackages) {
        this.excludedPackages = excludedPackages;
    }

    public void setThreadsCount(int threadsCount) {
        this.threadsCount = threadsCount;
    }

    public void setFallbackMode(boolean fallbackMode) {
        this.fallbackMode = fallbackMode;
    }

    public void setSkipResources(boolean skipResources) {
        this.skipResources = skipResources;
    }

    public void setSkipSources(boolean skipSources) {
        this.skipSources = skipSources;
    }

    public void setShowInconsistentCode(boolean showInconsistentCode) {
        this.showInconsistentCode = showInconsistentCode;
    }

    public LangLocale getLangLocale() {
        return this.langLocale;
    }

    public void setLangLocale(LangLocale langLocale) {
        this.langLocale = langLocale;
    }

    public void setCfgOutput(boolean cfgOutput) {
        this.cfgOutput = cfgOutput;
    }

    public void setRawCfgOutput(boolean rawCfgOutput) {
        this.rawCfgOutput = rawCfgOutput;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDeobfuscationOn(boolean deobfuscationOn) {
        this.deobfuscationOn = deobfuscationOn;
    }

    public void setDeobfuscationMinLength(int deobfuscationMinLength) {
        this.deobfuscationMinLength = deobfuscationMinLength;
    }

    public void setDeobfuscationMaxLength(int deobfuscationMaxLength) {
        this.deobfuscationMaxLength = deobfuscationMaxLength;
    }

    public void setDeobfuscationForceSave(boolean deobfuscationForceSave) {
        this.deobfuscationForceSave = deobfuscationForceSave;
    }

    public void setDeobfuscationUseSourceNameAsAlias(boolean deobfuscationUseSourceNameAsAlias) {
        this.deobfuscationUseSourceNameAsAlias = deobfuscationUseSourceNameAsAlias;
    }

    public void updateRenameFlag(JadxArgs.RenameEnum flag, boolean enabled) {
        if (enabled) {
            this.renameFlags.add(flag);
        } else {
            this.renameFlags.remove(flag);
        }
    }

    public void setEscapeUnicode(boolean escapeUnicode) {
        this.escapeUnicode = escapeUnicode;
    }

    public void setReplaceConsts(boolean replaceConsts) {
        this.replaceConsts = replaceConsts;
    }

    public void setRespectBytecodeAccessModifiers(boolean respectBytecodeAccessModifiers) {
        this.respectBytecodeAccessModifiers = respectBytecodeAccessModifiers;
    }

    public void setUseImports(boolean useImports) {
        this.useImports = useImports;
    }

    public void setInlineAnonymousClasses(boolean inlineAnonymousClasses) {
        this.inlineAnonymousClasses = inlineAnonymousClasses;
    }

    public void setFsCaseSensitive(boolean fsCaseSensitive) {
        this.fsCaseSensitive = fsCaseSensitive;
    }

    public boolean isAutoStartJobs() {
        return this.autoStartJobs;
    }

    public void setAutoStartJobs(boolean autoStartJobs) {
        this.autoStartJobs = autoStartJobs;
    }

    public boolean isAutoSaveProject() {
        return this.autoSaveProject;
    }

    public void setAutoSaveProject(boolean autoSaveProject) {
        this.autoSaveProject = autoSaveProject;
    }

    public void setExportAsGradleProject(boolean exportAsGradleProject) {
        this.exportAsGradleProject = exportAsGradleProject;
    }

    public int getTreeWidth() {
        return this.treeWidth;
    }

    public void setTreeWidth(int treeWidth) {
        this.treeWidth = treeWidth;
        this.partialSync(settings -> {
            settings.treeWidth = this.treeWidth;
        });
    }

    public Font getFont() {
        if (this.fontStr.isEmpty()) {
            return DEFAULT_FONT;
        }
        try {
            return FontUtils.loadByStr(this.fontStr);
        }
        catch (Exception e) {
            LOG.warn("Failed to load font: {}, reset to default", (Object)this.fontStr, (Object)e);
            this.setFont(DEFAULT_FONT);
            return DEFAULT_FONT;
        }
    }

    public void setFont(@Nullable Font font) {
        this.fontStr = font == null ? "" : FontUtils.convertToStr(font);
    }

    public void setLogLevel(LogHelper.LogLevelEnum level) {
        this.logLevel = level;
    }

    public String getEditorThemePath() {
        return this.editorThemePath;
    }

    public void setEditorThemePath(String editorThemePath) {
        this.editorThemePath = editorThemePath;
    }

    public int getMainWindowExtendedState() {
        return this.mainWindowExtendedState;
    }

    public void setMainWindowExtendedState(int mainWindowExtendedState) {
        this.mainWindowExtendedState = mainWindowExtendedState;
        this.partialSync(settings -> {
            settings.mainWindowExtendedState = mainWindowExtendedState;
        });
    }

    private void upgradeSettings(int fromVersion) {
        LOG.debug("upgrade settings from version: {} to {}", (Object)fromVersion, (Object)9);
        if (fromVersion == 0) {
            this.setDeobfuscationMinLength(3);
            this.setDeobfuscationUseSourceNameAsAlias(true);
            this.setDeobfuscationForceSave(true);
            this.setThreadsCount(1);
            this.setReplaceConsts(true);
            this.setSkipResources(false);
            this.setAutoStartJobs(false);
            ++fromVersion;
        }
        if (fromVersion == 1) {
            this.setEditorThemePath(EditorTheme.getDefaultTheme().getPath());
            ++fromVersion;
        }
        if (fromVersion == 2) {
            if (this.getDeobfuscationMinLength() == 4) {
                this.setDeobfuscationMinLength(3);
            }
            ++fromVersion;
        }
        if (fromVersion == 3) {
            this.setLangLocale(NLS.defaultLocale());
            ++fromVersion;
        }
        if (fromVersion == 4) {
            this.setUseImports(true);
            ++fromVersion;
        }
        if (fromVersion == 5) {
            this.setRespectBytecodeAccessModifiers(false);
            ++fromVersion;
        }
        if (fromVersion == 6) {
            if (this.getFont().getFontName().equals("Hack Regular")) {
                this.setFont(null);
            }
            ++fromVersion;
        }
        if (fromVersion == 7) {
            this.outDir = null;
            this.outDirSrc = null;
            this.outDirRes = null;
            ++fromVersion;
        }
        if (fromVersion == 8) {
            ++fromVersion;
        }
        this.settingsVersion = 9;
        this.sync();
    }

    @Override
    protected JadxCLIArgs newInstance() {
        return new JadxSettings();
    }
}

