/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.utils;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.attributes.nodes.JadxError;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.IDexNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorsCounter {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorsCounter.class);
    private final Set<IAttributeNode> errorNodes = new HashSet<IAttributeNode>();
    private int errorsCount;
    private final Set<IAttributeNode> warnNodes = new HashSet<IAttributeNode>();
    private int warnsCount;

    public int getErrorCount() {
        return this.errorsCount;
    }

    public int getWarnsCount() {
        return this.warnsCount;
    }

    private synchronized <N extends IDexNode & IAttributeNode> String addError(N node, String error, @Nullable Throwable e) {
        this.errorNodes.add(node);
        ++this.errorsCount;
        String msg = ErrorsCounter.formatMsg(node, error);
        if (e == null) {
            LOG.error(msg);
        } else if (e instanceof JadxOverflowException) {
            e = new JadxOverflowException(e.getMessage());
            LOG.error("{}, details: {}", (Object)msg, (Object)e.getMessage());
        } else {
            LOG.error(msg, e);
        }
        ((IAttributeNode)node).addAttr(AType.JADX_ERROR, new JadxError(error, e));
        ((IAttributeNode)node).remove(AFlag.INCONSISTENT_CODE);
        return msg;
    }

    private synchronized <N extends IDexNode & IAttributeNode> String addWarning(N node, String warn) {
        this.warnNodes.add(node);
        ++this.warnsCount;
        ((IAttributeNode)node).addAttr(AType.JADX_WARN, warn);
        if (!((IAttributeNode)node).contains(AType.JADX_ERROR)) {
            ((IAttributeNode)node).add(AFlag.INCONSISTENT_CODE);
        }
        String msg = ErrorsCounter.formatMsg(node, warn);
        LOG.warn(msg);
        return msg;
    }

    public static String classError(ClassNode cls, String errorMsg, Throwable e) {
        return cls.dex().root().getErrorsCounter().addError(cls, errorMsg, e);
    }

    public static String classWarn(ClassNode cls, String warnMsg) {
        return cls.dex().root().getErrorsCounter().addWarning(cls, warnMsg);
    }

    public static String methodError(MethodNode mth, String errorMsg, Throwable e) {
        return mth.root().getErrorsCounter().addError(mth, errorMsg, e);
    }

    public static String methodWarn(MethodNode mth, String warnMsg) {
        return mth.root().getErrorsCounter().addWarning(mth, warnMsg);
    }

    public static String formatMsg(IDexNode node, String msg) {
        return msg + " in " + node.typeName() + ": " + node + ", dex: " + node.dex().getDexFile().getName();
    }

    public void printReport() {
        if (this.getErrorCount() > 0) {
            LOG.error("{} errors occurred in following nodes:", (Object)this.getErrorCount());
            ArrayList<String> errors = new ArrayList<String>(this.errorNodes.size());
            for (IAttributeNode node : this.errorNodes) {
                String nodeName = node.getClass().getSimpleName().replace("Node", "");
                errors.add(nodeName + ": " + node);
            }
            Collections.sort(errors);
            for (String err : errors) {
                LOG.error("  {}", (Object)err);
            }
        }
        if (this.getWarnsCount() > 0) {
            LOG.warn("{} warnings in {} nodes", (Object)this.getWarnsCount(), (Object)this.warnNodes.size());
        }
    }
}

