/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy;

import java.util.Comparator;
import org.gradle.api.internal.FeaturePreviews;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.Versioned;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.StaticVersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.Version;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;

public class DefaultVersionComparator
implements VersionComparator {
    private Comparator<Version> baseComparator;
    private final FeaturePreviews featurePreviews;

    public DefaultVersionComparator() {
        this(null);
    }

    public DefaultVersionComparator(FeaturePreviews featurePreviews) {
        this.featurePreviews = featurePreviews;
        this.computeBaseComparator();
    }

    @Override
    public int compare(Versioned element1, Versioned element2) {
        Version version1 = element1.getVersion();
        Version version2 = element2.getVersion();
        return this.baseComparator.compare(version1, version2);
    }

    @Override
    public Comparator<Version> asVersionComparator() {
        return this.baseComparator;
    }

    public void configure() {
        this.computeBaseComparator();
    }

    private void computeBaseComparator() {
        this.baseComparator = this.featurePreviews != null && this.featurePreviews.isFeatureEnabled(FeaturePreviews.Feature.VERSION_ORDERING_V2) ? new StaticVersionComparator(StaticVersionComparator.UPDATED_SPECIAL_MEANINGS) : new StaticVersionComparator(StaticVersionComparator.SPECIAL_MEANINGS);
    }
}

