/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.db.Cursor;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.Environment;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class CurrentTransaction {
    private static WeakHashMap envMap = new WeakHashMap();
    private LockMode writeLockMode;
    private boolean cdbMode;
    private boolean txnMode;
    private boolean lockingMode;
    private Environment env;
    private ThreadLocal localTrans = new ThreadLocal();
    private ThreadLocal localCdbCursors;

    public static CurrentTransaction getInstance(Environment environment) {
        CurrentTransaction currentTransaction = CurrentTransaction.getInstanceInternal(environment);
        return currentTransaction.isTxnMode() ? currentTransaction : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CurrentTransaction getInstanceInternal(Environment environment) {
        WeakHashMap weakHashMap = envMap;
        synchronized (weakHashMap) {
            CurrentTransaction currentTransaction = null;
            WeakReference weakReference = (WeakReference)envMap.get(environment);
            if (weakReference != null) {
                currentTransaction = (CurrentTransaction)weakReference.get();
            }
            if (currentTransaction == null) {
                currentTransaction = new CurrentTransaction(environment);
                envMap.put(environment, new WeakReference<CurrentTransaction>(currentTransaction));
            }
            return currentTransaction;
        }
    }

    private CurrentTransaction(Environment environment) {
        this.env = environment;
        try {
            EnvironmentConfig environmentConfig = environment.getConfig();
            this.txnMode = environmentConfig.getTransactional();
            this.lockingMode = DbCompat.getInitializeLocking(environmentConfig);
            this.writeLockMode = this.txnMode || this.lockingMode ? LockMode.RMW : LockMode.DEFAULT;
            this.cdbMode = DbCompat.getInitializeCDB(environmentConfig);
            if (this.cdbMode) {
                this.localCdbCursors = new ThreadLocal();
            }
        }
        catch (DatabaseException databaseException) {
            throw new RuntimeExceptionWrapper(databaseException);
        }
    }

    final boolean isLockingMode() {
        return this.lockingMode;
    }

    final boolean isTxnMode() {
        return this.txnMode;
    }

    final boolean isCdbMode() {
        return this.cdbMode;
    }

    final LockMode getWriteLockMode() {
        return this.writeLockMode;
    }

    public final Environment getEnvironment() {
        return this.env;
    }

    public final Transaction getTransaction() {
        Trans trans = (Trans)this.localTrans.get();
        return trans != null ? trans.txn : null;
    }

    boolean isAutoCommitAllowed() throws DatabaseException {
        return this.getTransaction() == null && DbCompat.getThreadTransaction(this.env) == null;
    }

    public final Transaction beginTransaction(TransactionConfig transactionConfig) throws DatabaseException {
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null) {
            if (trans.txn != null) {
                Transaction transaction = trans.txn;
                trans = new Trans(trans, transactionConfig);
                trans.txn = this.env.beginTransaction(transaction, transactionConfig);
                this.localTrans.set(trans);
            } else {
                trans.txn = this.env.beginTransaction(null, transactionConfig);
                trans.config = transactionConfig;
            }
        } else {
            trans = new Trans(null, transactionConfig);
            trans.txn = this.env.beginTransaction(null, transactionConfig);
            this.localTrans.set(trans);
        }
        return trans.txn;
    }

    public final Transaction commitTransaction() throws DatabaseException, IllegalStateException {
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null && trans.txn != null) {
            Transaction transaction = this.closeTxn(trans);
            trans.txn.commit();
            return transaction;
        }
        throw new IllegalStateException("No transaction is active");
    }

    public final Transaction abortTransaction() throws DatabaseException, IllegalStateException {
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null && trans.txn != null) {
            Transaction transaction = this.closeTxn(trans);
            trans.txn.abort();
            return transaction;
        }
        throw new IllegalStateException("No transaction is active");
    }

    final boolean isReadUncommitted() {
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null && trans.config != null) {
            return trans.config.getReadUncommitted();
        }
        return false;
    }

    private Transaction closeTxn(Trans trans) {
        this.localTrans.set(trans.parent);
        return trans.parent != null ? trans.parent.txn : null;
    }

    Cursor openCursor(Database database, CursorConfig cursorConfig, boolean bl, Transaction transaction) throws DatabaseException {
        if (this.cdbMode) {
            Cursor cursor;
            CursorConfig cursorConfig2;
            List list;
            CdbCursors cdbCursors = null;
            WeakHashMap<Database, CdbCursors> weakHashMap = (WeakHashMap<Database, CdbCursors>)this.localCdbCursors.get();
            if (weakHashMap == null) {
                weakHashMap = new WeakHashMap<Database, CdbCursors>();
                this.localCdbCursors.set(weakHashMap);
            } else {
                cdbCursors = (CdbCursors)weakHashMap.get(database);
            }
            if (cdbCursors == null) {
                cdbCursors = new CdbCursors();
                weakHashMap.put(database, cdbCursors);
            }
            if (bl) {
                if (cdbCursors.readCursors.size() > 0) {
                    throw new IllegalStateException("cannot open CDB write cursor when read cursor is open");
                }
                list = cdbCursors.writeCursors;
                cursorConfig2 = new CursorConfig();
                DbCompat.setWriteCursor(cursorConfig2, true);
            } else {
                list = cdbCursors.readCursors;
                cursorConfig2 = null;
            }
            if (list.size() > 0) {
                Cursor cursor2 = (Cursor)list.get(0);
                cursor = cursor2.dup(false);
            } else {
                cursor = database.openCursor(null, cursorConfig2);
            }
            list.add(cursor);
            return cursor;
        }
        return database.openCursor(transaction, cursorConfig);
    }

    Cursor dupCursor(Cursor cursor, boolean bl, boolean bl2) throws DatabaseException {
        if (this.cdbMode) {
            Database database;
            CdbCursors cdbCursors;
            WeakHashMap weakHashMap = (WeakHashMap)this.localCdbCursors.get();
            if (weakHashMap != null && (cdbCursors = (CdbCursors)weakHashMap.get(database = cursor.getDatabase())) != null) {
                List list;
                List list2 = list = bl ? cdbCursors.writeCursors : cdbCursors.readCursors;
                if (list.contains(cursor)) {
                    Cursor cursor2 = cursor.dup(bl2);
                    list.add(cursor2);
                    return cursor2;
                }
            }
            throw new IllegalStateException("cursor to dup not tracked");
        }
        return cursor.dup(bl2);
    }

    void closeCursor(Cursor cursor) throws DatabaseException {
        if (cursor == null) {
            return;
        }
        if (this.cdbMode) {
            Database database;
            CdbCursors cdbCursors;
            WeakHashMap weakHashMap = (WeakHashMap)this.localCdbCursors.get();
            if (weakHashMap != null && (cdbCursors = (CdbCursors)weakHashMap.get(database = cursor.getDatabase())) != null && (cdbCursors.readCursors.remove(cursor) || cdbCursors.writeCursors.remove(cursor))) {
                cursor.close();
                return;
            }
            throw new IllegalStateException("closing CDB cursor that was not known to be open");
        }
        cursor.close();
    }

    boolean isCDBCursorOpen(Database database) throws DatabaseException {
        CdbCursors cdbCursors;
        WeakHashMap weakHashMap;
        return this.cdbMode && (weakHashMap = (WeakHashMap)this.localCdbCursors.get()) != null && (cdbCursors = (CdbCursors)weakHashMap.get(database)) != null && (cdbCursors.readCursors.size() > 0 || cdbCursors.writeCursors.size() > 0);
    }

    static final class CdbCursors {
        List writeCursors = new ArrayList();
        List readCursors = new ArrayList();

        CdbCursors() {
        }
    }

    private static class Trans {
        private Trans parent;
        private Transaction txn;
        private TransactionConfig config;

        private Trans(Trans trans, TransactionConfig transactionConfig) {
            this.parent = trans;
            this.config = transactionConfig;
        }
    }
}

