/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.DocString;
import org.armedbear.lisp.FileError;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LogicalPathname;
import org.armedbear.lisp.Pathname;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleError;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.URLPathname;
import org.armedbear.lisp.Utilities;
import org.armedbear.lisp.ZipCache;

public class JarPathname
extends URLPathname {
    public static final String JAR_URI_SUFFIX = "!/";
    public static final String JAR_URI_PREFIX = "jar:";
    @DocString(name="match-wild-jar-pathname", args="wild-jar-pathname", returns="pathnames", doc="Returns the pathnames matching WILD-JAR-PATHNAME which must be both wild and a JAR-PATHNAME")
    static final Primitive MATCH_WILD_JAR_PATHNAME = new pf_match_wild_jar_pathname();

    protected JarPathname() {
    }

    public static JarPathname create() {
        return new JarPathname();
    }

    public static JarPathname create(JarPathname p) {
        JarPathname result = new JarPathname();
        result.copyFrom(p);
        return result;
    }

    public static JarPathname createFromPathname(Pathname p) {
        JarPathname result = new JarPathname();
        URLPathname rootDevice = new URLPathname();
        if (p instanceof URLPathname) {
            rootDevice.copyFrom(p);
        } else if (p instanceof Pathname) {
            rootDevice = URLPathname.create(p);
        } else {
            Lisp.simple_error("Argument is already a JAR-PATHNAME: ~a", p);
        }
        result.setDevice(new Cons(rootDevice, (LispObject)Lisp.NIL));
        return result;
    }

    public static JarPathname createFromEntry(JarPathname p) {
        JarPathname result = new JarPathname();
        result.copyFrom(p).setDirectory(Lisp.NIL).setName(Lisp.NIL).setType(Lisp.NIL);
        Pathname entryPath = p.getEntryPath();
        LispObject device = result.getDevice();
        device = device.reverse().push(entryPath).reverse();
        result.setDevice(device);
        return result;
    }

    public static JarPathname createFromFile(String s) {
        return JarPathname.create("jar:file:" + s + JAR_URI_SUFFIX);
    }

    public static JarPathname createEntryFromFile(String jar, String entry) {
        return JarPathname.create("jar:file:" + jar + JAR_URI_SUFFIX + entry);
    }

    public static JarPathname createEntryFromJar(JarPathname jar, String entry) {
        if (jar.isArchiveEntry()) {
            Lisp.simple_error("Failed to create the entry ~a in ~a", entry, jar);
            return (JarPathname)Lisp.UNREACHED;
        }
        JarPathname result = new JarPathname();
        result.copyFrom(jar);
        Object path = new String(entry);
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        Pathname p = Pathname.create((String)path);
        result.setDirectory(p.getDirectory()).setName(p.getName()).setType(p.getType());
        return result;
    }

    static List<String> enumerate(String s) {
        ArrayList<String> result = new ArrayList<String>();
        int i = s.lastIndexOf(JAR_URI_PREFIX);
        if (i == -1) {
            Lisp.parse_error("Failed to find any occurence of 'jar:' prefixes:" + s);
            return null;
        }
        if ((i += JAR_URI_PREFIX.length()) % JAR_URI_PREFIX.length() != 0) {
            Lisp.parse_error("Failed to parse 'jar:' prefixes:" + s);
            return null;
        }
        int prefixCount = i / JAR_URI_PREFIX.length();
        String withoutPrefixes = s.substring(i);
        String[] parts = withoutPrefixes.split(JAR_URI_SUFFIX);
        String notEndingInSuffix = withoutPrefixes + "nonce";
        String[] suffixParts = notEndingInSuffix.split(JAR_URI_SUFFIX);
        int suffixCount = suffixParts.length - 1;
        if (suffixCount != prefixCount) {
            Lisp.parse_error("Mismatched 'jar:' prefix and '/!' suffixes in jar: " + s);
            return null;
        }
        if (parts.length == 1) {
            if (!s.endsWith(JAR_URI_SUFFIX)) {
                Lisp.error(new SimpleError("No trailing jar uri suffix: " + s));
                return null;
            }
            if (!JarPathname.isValidURL(parts[0])) {
                Lisp.error(new SimpleError("Not a valid URI: " + parts[0]));
                return null;
            }
            result.add(parts[0]);
            return result;
        }
        result.add(parts[0]);
        for (int j = 1; j < prefixCount; ++j) {
            String ns = parts[j] + JAR_URI_SUFFIX;
            result.add(ns);
        }
        if (parts.length == prefixCount + 1) {
            result.add("/" + parts[parts.length - 1]);
        }
        return result;
    }

    public static JarPathname create(String s) {
        URLPathname rootPathname;
        if (!s.startsWith(JAR_URI_PREFIX)) {
            Lisp.parse_error("Cannot create a PATHNAME-JAR from namestring: " + s);
            return (JarPathname)Lisp.UNREACHED;
        }
        List<String> contents = JarPathname.enumerate(s);
        if (contents == null) {
            Lisp.parse_error("Couldn't parse PATHNAME-JAR from namestring: " + s);
            return (JarPathname)Lisp.UNREACHED;
        }
        JarPathname result = new JarPathname();
        String rootNamestring = contents.get(0);
        if (!JarPathname.isValidURL(rootNamestring)) {
            Pathname root = Pathname.create(rootNamestring);
            rootPathname = URLPathname.createFromFile(root);
        } else {
            rootPathname = URLPathname.create(rootNamestring);
        }
        LispObject jars = Lisp.NIL;
        jars = jars.push(rootPathname);
        if (contents.size() == 1) {
            result.setDevice(jars);
            return result;
        }
        for (int i = 1; i < contents.size(); ++i) {
            String ns = contents.get(i);
            if (ns.endsWith(JAR_URI_SUFFIX)) {
                String nsWithoutSuffix = ns.substring(0, ns.length() - JAR_URI_SUFFIX.length());
                Pathname pathname = Pathname.create(nsWithoutSuffix);
                Pathname jar = new Pathname();
                jar.copyFrom(pathname);
                jars = jars.push(jar);
                continue;
            }
            Pathname p = Pathname.create(contents.get(i));
            result.copyFrom(p);
        }
        jars = jars.nreverse();
        result.setDevice(jars);
        result.validateComponents();
        return result;
    }

    public LispObject validateComponents() {
        if (!(this.getDevice() instanceof Cons)) {
            return Lisp.type_error("Invalid DEVICE for JAR-PATHNAME", this.getDevice(), Symbol.CONS);
        }
        LispObject jars = this.getDevice();
        LispObject rootJar = this.getRootJar();
        if (!(rootJar instanceof URLPathname)) {
            return Lisp.type_error("The first element in the DEVICE component of a JAR-PATHNAME is not of expected type", rootJar, Symbol.URL_PATHNAME);
        }
        jars = jars.cdr();
        while (!jars.car().equals(Lisp.NIL)) {
            LispObject jar = jars.car();
            if (!(jar instanceof Pathname) && !(jar instanceof URLPathname)) {
                return Lisp.type_error("The value in DEVICE component of a JAR-PATHNAME is not of expected type", jar, Lisp.list(Symbol.OR, Symbol.PATHNAME, Symbol.URL_PATHNAME));
            }
            jars = jars.cdr();
        }
        return Lisp.T;
    }

    @Override
    public String getNamestring() {
        String ns;
        StringBuffer sb = new StringBuffer();
        LispObject jars = this.getJars();
        if (jars.equals(Lisp.NIL) || jars.equals(Keyword.UNSPECIFIC)) {
            return null;
        }
        for (int i = 0; i < jars.length() - 1; ++i) {
            sb.append(JAR_URI_PREFIX);
        }
        LispObject root = this.getRootJar();
        if (root instanceof URLPathname) {
            ns = ((URLPathname)root).getNamestringAsURL();
            sb.append(JAR_URI_PREFIX).append(ns).append(JAR_URI_SUFFIX);
        } else if (root instanceof Pathname) {
            ns = ((Pathname)root).getNamestring();
            sb.append(JAR_URI_PREFIX).append("file:").append(ns).append(JAR_URI_SUFFIX);
        } else {
            Lisp.simple_error("Unable to generate namestring for jar with root pathname ~a", root);
        }
        LispObject innerJars = jars.cdr();
        while (innerJars.car() != Lisp.NIL) {
            Pathname jar = (Pathname)innerJars.car();
            Pathname p = new Pathname();
            p.copyFrom(jar).setDevice(Lisp.NIL);
            String ns2 = p.getNamestring();
            sb.append(ns2).append(JAR_URI_SUFFIX);
            innerJars = innerJars.cdr();
        }
        if (this.getDirectory() != Lisp.NIL || this.getName() != Lisp.NIL || this.getType() != Lisp.NIL) {
            Pathname withoutDevice = new Pathname();
            withoutDevice.copyFrom(this).setDevice(Lisp.NIL);
            String withoutDeviceNamestring = withoutDevice.getNamestring();
            if (withoutDeviceNamestring.startsWith("/")) {
                sb.append(withoutDeviceNamestring.substring(1));
            } else {
                sb.append(withoutDeviceNamestring);
            }
        }
        return sb.toString();
    }

    LispObject getRootJar() {
        LispObject jars = this.getJars();
        if (!(jars instanceof Cons)) {
            Lisp.type_error("JAR-PATHNAME device is not a cons", jars, Symbol.CONS);
            return (LispObject)Lisp.UNREACHED;
        }
        return jars.car();
    }

    String getRootJarAsURLString() {
        return JAR_URI_PREFIX + ((URLPathname)this.getRootJar()).getNamestring() + JAR_URI_SUFFIX;
    }

    LispObject getJars() {
        return this.getDevice();
    }

    public static LispObject truename(Pathname pathname, boolean errorIfDoesNotExist) {
        if (!(pathname instanceof JarPathname)) {
            return URLPathname.truename(pathname, errorIfDoesNotExist);
        }
        JarPathname p = new JarPathname();
        p.copyFrom(pathname);
        if (p.isLocalFile()) {
            LispObject rootJarTruename;
            Pathname rootJar = URLPathname.hasExplicitFile((Pathname)p.getRootJar()) ? new URLPathname() : new Pathname();
            rootJar.copyFrom((Pathname)p.getRootJar());
            if (rootJar.getDevice().equals(Lisp.NIL) && !Utilities.isPlatformWindows) {
                rootJar.setDevice(Keyword.UNSPECIFIC);
            }
            if ((rootJarTruename = Pathname.truename(rootJar, errorIfDoesNotExist)).equals(Lisp.NIL)) {
                return Pathname.doTruenameExit(rootJar, errorIfDoesNotExist);
            }
            LispObject otherJars = p.getJars().cdr();
            URLPathname newRootJar = rootJarTruename instanceof Pathname ? URLPathname.createFromFile((Pathname)rootJarTruename) : (URLPathname)rootJarTruename;
            p.setDevice(new Cons(newRootJar, otherJars));
        }
        if (!p.isArchiveEntry()) {
            ZipCache.Archive archive = ZipCache.getArchive(p);
            if (archive == null) {
                return Pathname.doTruenameExit(pathname, errorIfDoesNotExist);
            }
            return p;
        }
        ZipEntry entry = ZipCache.getZipEntry(p);
        if (entry == null) {
            return Pathname.doTruenameExit(pathname, errorIfDoesNotExist);
        }
        return p;
    }

    @Override
    public boolean isLocalFile() {
        Pathname p = (Pathname)this.getRootJar();
        if (p != null) {
            return p.isLocalFile();
        }
        return false;
    }

    public boolean isArchiveEntry() {
        return !this.getDirectory().equals(Lisp.NIL) || !this.getName().equals(Lisp.NIL) || !this.getType().equals(Lisp.NIL);
    }

    public JarPathname getArchive() {
        if (!this.isArchiveEntry()) {
            return (JarPathname)Lisp.simple_error("Pathname already represents an archive.", new Object[0]);
        }
        JarPathname archive = new JarPathname();
        archive.copyFrom(this);
        archive.setDirectory(Lisp.NIL).setName(Lisp.NIL).setType(Lisp.NIL);
        return archive;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.JAR_PATHNAME;
    }

    @Override
    public LispObject typeOf() {
        return Symbol.JAR_PATHNAME;
    }

    @Override
    public InputStream getInputStream() {
        InputStream result;
        if (!this.isArchiveEntry()) {
            Lisp.simple_error("Can only get input stream for an entry in a JAR-PATHNAME.", this);
        }
        if ((result = ZipCache.getEntryAsInputStream(this)) == null) {
            Lisp.error(new FileError("Failed to get InputStream", this));
        }
        return result;
    }

    public static LispObject listDirectory(JarPathname pathname) {
        Object directory = pathname.asEntryPath();
        if (pathname.getDirectory() == Lisp.NIL) {
            return Lisp.simple_error("Not a directory in a jar ~a", pathname);
        }
        directory = ((String)directory).length() == 0 ? "/*" : (((String)directory).endsWith("/") ? "/" + (String)directory + "*" : "/" + (String)directory + "/*");
        Pathname wildcard = Pathname.create((String)directory);
        LispObject result = Lisp.NIL;
        Iterator<Map.Entry<JarPathname, ZipEntry>> iterator = ZipCache.getEntriesIterator(pathname);
        while (iterator.hasNext()) {
            Map.Entry<JarPathname, ZipEntry> e = iterator.next();
            JarPathname entry = e.getKey();
            if (Symbol.PATHNAME_MATCH_P.execute((LispObject)entry, wildcard).equals(Lisp.NIL)) continue;
            result = result.push(entry);
        }
        return result.nreverse();
    }

    @Override
    public long getLastModified() {
        if (!this.isArchiveEntry()) {
            ZipCache.Archive archive = ZipCache.getArchive(this);
            if (archive != null) {
                return archive.lastModified;
            }
        } else {
            ZipEntry entry = ZipCache.getZipEntry(this);
            if (entry != null) {
                return entry.getTime();
            }
        }
        return 0L;
    }

    static JarPathname joinEntry(JarPathname root, Pathname entry) {
        JarPathname result = new JarPathname();
        result.copyFrom(root).setDirectory(entry.getDirectory()).setName(entry.getName()).setType(entry.getType());
        return result;
    }

    private static class pf_match_wild_jar_pathname
    extends Primitive {
        pf_match_wild_jar_pathname() {
            super(Symbol.MATCH_WILD_JAR_PATHNAME, "wild-jar-pathname");
        }

        @Override
        public LispObject execute(LispObject arg) {
            Pathname pathname = Lisp.coerceToPathname(arg);
            if (pathname instanceof LogicalPathname) {
                pathname = LogicalPathname.translateLogicalPathname((LogicalPathname)pathname);
            }
            if (!pathname.isJar()) {
                return new FileError("Not a jar pathname.", pathname);
            }
            if (!pathname.isWild()) {
                return new FileError("Not a wild pathname.", pathname);
            }
            JarPathname jarPathname = new JarPathname();
            jarPathname.copyFrom(pathname).setDirectory(Lisp.NIL).setName(Lisp.NIL).setType(Lisp.NIL);
            JarPathname wildcard = (JarPathname)Symbol.TRUENAME.execute(jarPathname);
            Iterator<Map.Entry<JarPathname, ZipEntry>> iterator = ZipCache.getEntriesIterator(wildcard);
            wildcard.setDirectory(pathname.getDirectory()).setName(pathname.getName()).setType(pathname.getType());
            LispObject result = Lisp.NIL;
            while (iterator.hasNext()) {
                Map.Entry<JarPathname, ZipEntry> e = iterator.next();
                JarPathname entry = e.getKey();
                LispObject matches = Symbol.PATHNAME_MATCH_P.execute((LispObject)entry, wildcard);
                if (matches.equals(Lisp.NIL)) continue;
                result = new Cons(entry, result);
            }
            return result;
        }
    }
}

