# Docs: Contributing and developing Bundler

_If you're looking for documentation on how to use Bundler: visit [bundler.io](http://bundler.io/), or run `bundle help` from the command line. You may also be interested in [troubleshooting common issues](TROUBLESHOOTING.md) found when using Bundler._

Bundler welcomes contributions from *everyone*. While contributing, please follow the project [code of conduct](http://bundler.io/conduct.html), so that everyone can be included.

If you'd like to help make Bundler better, you totally rock! Thanks for helping us make Bundler better.

## Contributing

* [Overview & getting started](contributing/README.md)
* [How you can help: your first contributions!](contributing/HOW_YOU_CAN_HELP.md)
* [Bug triage](contributing/BUG_TRIAGE.md)
* [Getting help](contributing/GETTING_HELP.md)
* [Filing issues](contributing/ISSUES.md)
* [Community](contributing/COMMUNITY.md)

## Development

* [Overview](development/README.md)
* [Development setup](development/SETUP.md)
* [Submitting pull requests](development/PULL_REQUESTS.md)
* [Adding new features](development/NEW_FEATURES.md)
* [Releasing Bundler](development/RELEASING.md)

## Documentation

* [Overview](documentation/README.md)
* [Writing docs for man pages](documentation/WRITING.md)
* [Documentation vision](documentation/VISION.md)
