/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiButtonIcon, EuiFlexGroup, EuiFlexItem, EuiToolTip } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { isBoolean } from 'lodash';
export function AddDeleteButtons(props) {
  var testSubj = props.testSubj;

  var createDelete = function createDelete() {
    if (props.disableDelete) {
      return null;
    }

    return /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiToolTip, {
      content: props.deleteTooltip
    }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
      "data-test-subj": "".concat(testSubj, "DeleteBtn"),
      "aria-label": props.deleteTooltip,
      color: "danger",
      iconType: "trash",
      onClick: props.onDelete
    })));
  };

  var createAdd = function createAdd() {
    if (props.disableAdd) {
      return null;
    }

    return /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiToolTip, {
      content: props.addTooltip
    }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
      "data-test-subj": "".concat(testSubj, "AddBtn"),
      "aria-label": props.addTooltip,
      iconType: "plusInCircle",
      onClick: props.onAdd
    })));
  };

  var createClone = function createClone() {
    var cloneBtn = null;

    if (props.onClone && !props.disableAdd) {
      cloneBtn = /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiToolTip, {
        content: props.cloneTooltip
      }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
        "data-test-subj": "".concat(testSubj, "CloneBtn"),
        "aria-label": props.cloneTooltip,
        iconType: "copy",
        onClick: props.onClone
      })));
    }

    return cloneBtn;
  };

  var createActivatePanel = function createActivatePanel() {
    var activatePanelBtn = null;

    if (isBoolean(props.isPanelActive)) {
      var tooltip = props.isPanelActive ? props.deactivatePanelTooltip : props.activatePanelTooltip;
      var iconType = props.isPanelActive ? 'eye' : 'eyeClosed';
      activatePanelBtn = /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiToolTip, {
        content: tooltip
      }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
        "data-test-subj": "".concat(testSubj, "ActivatePanelBtn"),
        "aria-label": tooltip,
        iconType: iconType,
        onClick: props.togglePanelActivation
      })));
    }

    return activatePanelBtn;
  };

  var deleteBtn = createDelete();
  var addBtn = createAdd();
  var cloneBtn = createClone();
  var activatePanelBtn = createActivatePanel();
  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: "s",
    responsive: props.responsive,
    justifyContent: "flexEnd"
  }, activatePanelBtn, cloneBtn, addBtn, deleteBtn);
}
AddDeleteButtons.defaultProps = {
  testSubj: 'Add',
  activeTooltip: i18n.translate('visTypeTimeseries.addDeleteButtons.addButtonDefaultTooltip', {
    defaultMessage: 'Add'
  }),
  addTooltip: i18n.translate('visTypeTimeseries.addDeleteButtons.addButtonDefaultTooltip', {
    defaultMessage: 'Add'
  }),
  deleteTooltip: i18n.translate('visTypeTimeseries.addDeleteButtons.deleteButtonDefaultTooltip', {
    defaultMessage: 'Delete'
  }),
  cloneTooltip: i18n.translate('visTypeTimeseries.addDeleteButtons.cloneButtonDefaultTooltip', {
    defaultMessage: 'Clone'
  }),
  activatePanelTooltip: i18n.translate('visTypeTimeseries.addDeleteButtons.reEnableTooltip', {
    defaultMessage: 'Re-enable'
  }),
  deactivatePanelTooltip: i18n.translate('visTypeTimeseries.addDeleteButtons.temporarilyDisableTooltip', {
    defaultMessage: 'Temporarily Disable'
  })
};