function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState } from 'react';
import { EuiForm, EuiButtonIcon, EuiFieldText, EuiFormRow, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { QueryStringInput } from '../../../../data/public';
import { useKibana } from '../../../../kibana_react/public';

function FilterRow(_ref) {
  var id = _ref.id,
      arrayIndex = _ref.arrayIndex,
      customLabel = _ref.customLabel,
      value = _ref.value,
      autoFocus = _ref.autoFocus,
      disableRemove = _ref.disableRemove,
      dataTestSubj = _ref.dataTestSubj,
      agg = _ref.agg,
      onChangeValue = _ref.onChangeValue,
      onRemoveFilter = _ref.onRemoveFilter;

  var _useKibana = useKibana(),
      services = _useKibana.services;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      showCustomLabel = _useState2[0],
      setShowCustomLabel = _useState2[1];

  var filterLabel = i18n.translate('visDefaultEditor.controls.filters.filterLabel', {
    defaultMessage: 'Filter {index}',
    values: {
      index: arrayIndex + 1
    }
  });

  var onBlur = function onBlur() {
    if (value.query.length > 0) {
      // Store filter to the query log so that it is available in autocomplete.
      services.data.query.addToQueryLog(services.appName, value);
    }
  };

  var FilterControl = /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiButtonIcon, {
    iconType: "tag",
    "aria-label": i18n.translate('visDefaultEditor.controls.filters.toggleFilterButtonAriaLabel', {
      defaultMessage: 'Toggle filter label'
    }),
    "aria-expanded": showCustomLabel,
    "aria-controls": "visEditorFilterLabel".concat(arrayIndex),
    onClick: function onClick() {
      return setShowCustomLabel(!showCustomLabel);
    }
  }), /*#__PURE__*/React.createElement(EuiButtonIcon, {
    iconType: "trash",
    color: "danger",
    disabled: disableRemove,
    "aria-label": i18n.translate('visDefaultEditor.controls.filters.removeFilterButtonAriaLabel', {
      defaultMessage: 'Remove this filter'
    }),
    onClick: function onClick() {
      return onRemoveFilter(id);
    }
  }));
  return /*#__PURE__*/React.createElement(EuiForm, null, /*#__PURE__*/React.createElement(EuiFormRow, {
    label: "".concat(filterLabel).concat(customLabel ? " - ".concat(customLabel) : ''),
    labelAppend: FilterControl,
    fullWidth: true
  }, /*#__PURE__*/React.createElement(QueryStringInput, {
    query: value,
    indexPatterns: [agg.getIndexPattern()],
    onChange: function onChange(query) {
      return onChangeValue(id, query, customLabel);
    },
    onBlur: onBlur,
    disableAutoFocus: !autoFocus,
    dataTestSubj: dataTestSubj,
    bubbleSubmitEvent: true,
    languageSwitcherPopoverAnchorPosition: "leftDown"
  })), showCustomLabel ? /*#__PURE__*/React.createElement(EuiFormRow, {
    id: "visEditorFilterLabel".concat(arrayIndex),
    label: i18n.translate('visDefaultEditor.controls.filters.definiteFilterLabel', {
      defaultMessage: 'Filter {index} label',
      description: "'Filter {index}' represents the name of the filter as a noun, similar to 'label for filter 1'.",
      values: {
        index: arrayIndex + 1
      }
    }),
    fullWidth: true,
    compressed: true
  }, /*#__PURE__*/React.createElement(EuiFieldText, {
    value: customLabel,
    placeholder: i18n.translate('visDefaultEditor.controls.filters.labelPlaceholder', {
      defaultMessage: 'Label'
    }),
    onChange: function onChange(ev) {
      return onChangeValue(id, value, ev.target.value);
    },
    fullWidth: true,
    compressed: true
  })) : null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }));
}

export { FilterRow };