/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiFlexGroup, EuiFlexItem, EuiTitle, EuiButton, EuiPageContentHeader, EuiPageContentHeaderSection } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
export var Header = function Header(_ref) {
  var canEdit = _ref.canEdit,
      canDelete = _ref.canDelete,
      canViewInApp = _ref.canViewInApp,
      type = _ref.type,
      viewUrl = _ref.viewUrl,
      onDeleteClick = _ref.onDeleteClick;
  return /*#__PURE__*/React.createElement(EuiPageContentHeader, null, /*#__PURE__*/React.createElement(EuiPageContentHeaderSection, null, /*#__PURE__*/React.createElement(EuiTitle, null, canEdit ? /*#__PURE__*/React.createElement("h1", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "savedObjectsManagement.view.editItemTitle",
    defaultMessage: "Edit {title}",
    values: {
      title: type
    }
  })) : /*#__PURE__*/React.createElement("h1", null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "savedObjectsManagement.view.viewItemTitle",
    defaultMessage: "View {title}",
    values: {
      title: type
    }
  })))), /*#__PURE__*/React.createElement(EuiPageContentHeaderSection, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    responsive: false
  }, canViewInApp && /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButton, {
    size: "s",
    href: viewUrl,
    iconType: "eye",
    "data-test-subj": "savedObjectEditViewInApp"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "savedObjectsManagement.view.viewItemButtonLabel",
    defaultMessage: "View {title}",
    values: {
      title: type
    }
  }))), canDelete && /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiButton, {
    color: "danger",
    size: "s",
    iconType: "trash",
    onClick: function onClick() {
      return onDeleteClick();
    },
    "data-test-subj": "savedObjectEditDelete"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "savedObjectsManagement.view.deleteItemButtonLabel",
    defaultMessage: "Delete {title}",
    values: {
      title: type
    }
  }))))));
};