function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import ReactResizeDetector from 'react-resize-detector';
import MonacoEditor from 'react-monaco-editor';
import { monaco } from '@kbn/monaco';
import { LIGHT_THEME, DARK_THEME } from './editor_theme';
import './editor.scss';
export var CodeEditor = /*#__PURE__*/function (_React$Component) {
  _inherits(CodeEditor, _React$Component);

  var _super = _createSuper(CodeEditor);

  function CodeEditor() {
    var _this;

    _classCallCheck(this, CodeEditor);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "_editor", null);

    _defineProperty(_assertThisInitialized(_this), "_editorWillMount", function (__monaco) {
      if (__monaco !== monaco) {
        throw new Error('react-monaco-editor is using a different version of monaco');
      }

      if (_this.props.overrideEditorWillMount) {
        _this.props.overrideEditorWillMount();

        return;
      }

      if (_this.props.editorWillMount) {
        _this.props.editorWillMount();
      }

      monaco.languages.onLanguage(_this.props.languageId, function () {
        if (_this.props.suggestionProvider) {
          monaco.languages.registerCompletionItemProvider(_this.props.languageId, _this.props.suggestionProvider);
        }

        if (_this.props.signatureProvider) {
          monaco.languages.registerSignatureHelpProvider(_this.props.languageId, _this.props.signatureProvider);
        }

        if (_this.props.hoverProvider) {
          monaco.languages.registerHoverProvider(_this.props.languageId, _this.props.hoverProvider);
        }

        if (_this.props.languageConfiguration) {
          monaco.languages.setLanguageConfiguration(_this.props.languageId, _this.props.languageConfiguration);
        }
      }); // Register the theme

      monaco.editor.defineTheme('euiColors', _this.props.useDarkTheme ? DARK_THEME : LIGHT_THEME);
    });

    _defineProperty(_assertThisInitialized(_this), "_editorDidMount", function (editor, __monaco) {
      if (__monaco !== monaco) {
        throw new Error('react-monaco-editor is using a different version of monaco');
      }

      _this._editor = editor;

      if (_this.props.editorDidMount) {
        _this.props.editorDidMount(editor);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "_updateDimensions", function () {
      if (_this._editor) {
        _this._editor.layout();
      }
    });

    return _this;
  }

  _createClass(CodeEditor, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          languageId = _this$props.languageId,
          value = _this$props.value,
          onChange = _this$props.onChange,
          width = _this$props.width,
          height = _this$props.height,
          options = _this$props.options;
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(MonacoEditor, {
        theme: "euiColors",
        language: languageId,
        value: value,
        onChange: onChange,
        editorWillMount: this._editorWillMount,
        editorDidMount: this._editorDidMount,
        width: width,
        height: height,
        options: options
      }), /*#__PURE__*/React.createElement(ReactResizeDetector, {
        handleWidth: true,
        handleHeight: true,
        onResize: this._updateDimensions
      }));
    }
  }]);

  return CodeEditor;
}(React.Component);