function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { PureComponent } from 'react';
import { injectI18n, FormattedMessage } from '@kbn/i18n/react';
import { EuiAccordion, EuiButtonIcon, EuiFieldText, EuiForm, EuiFormRow, EuiPanel, EuiSpacer } from '@elastic/eui';
import { RangeControlEditor } from './range_control_editor';
import { ListControlEditor } from './list_control_editor';
import { getTitle, CONTROL_TYPES } from '../../editor_utils';

var ControlEditorUi = /*#__PURE__*/function (_PureComponent) {
  _inherits(ControlEditorUi, _PureComponent);

  var _super = _createSuper(ControlEditorUi);

  function ControlEditorUi() {
    var _this;

    _classCallCheck(this, ControlEditorUi);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "changeLabel", function (event) {
      _this.props.handleLabelChange(_this.props.controlIndex, event.target.value);
    });

    _defineProperty(_assertThisInitialized(_this), "removeControl", function () {
      _this.props.handleRemoveControl(_this.props.controlIndex);
    });

    _defineProperty(_assertThisInitialized(_this), "moveUpControl", function () {
      _this.props.moveControl(_this.props.controlIndex, -1);
    });

    _defineProperty(_assertThisInitialized(_this), "moveDownControl", function () {
      _this.props.moveControl(_this.props.controlIndex, 1);
    });

    _defineProperty(_assertThisInitialized(_this), "changeIndexPattern", function (indexPatternId) {
      _this.props.handleIndexPatternChange(_this.props.controlIndex, indexPatternId);
    });

    _defineProperty(_assertThisInitialized(_this), "changeFieldName", function (fieldName) {
      _this.props.handleFieldNameChange(_this.props.controlIndex, fieldName);
    });

    return _this;
  }

  _createClass(ControlEditorUi, [{
    key: "renderEditor",
    value: function renderEditor() {
      var controlEditor = null;

      switch (this.props.controlParams.type) {
        case CONTROL_TYPES.LIST:
          controlEditor = /*#__PURE__*/React.createElement(ListControlEditor, {
            controlIndex: this.props.controlIndex,
            controlParams: this.props.controlParams,
            handleIndexPatternChange: this.changeIndexPattern,
            handleFieldNameChange: this.changeFieldName,
            getIndexPattern: this.props.getIndexPattern,
            handleOptionsChange: this.props.handleOptionsChange,
            parentCandidates: this.props.parentCandidates,
            handleParentChange: this.props.handleParentChange,
            deps: this.props.deps
          });
          break;

        case CONTROL_TYPES.RANGE:
          controlEditor = /*#__PURE__*/React.createElement(RangeControlEditor, {
            controlIndex: this.props.controlIndex,
            controlParams: this.props.controlParams,
            handleIndexPatternChange: this.changeIndexPattern,
            handleFieldNameChange: this.changeFieldName,
            getIndexPattern: this.props.getIndexPattern,
            handleOptionsChange: this.props.handleOptionsChange,
            deps: this.props.deps
          });
          break;

        default:
          throw new Error("Unhandled control editor type ".concat(this.props.controlParams.type));
      }

      var labelId = "controlLabel".concat(this.props.controlIndex);
      return /*#__PURE__*/React.createElement(EuiForm, null, /*#__PURE__*/React.createElement(EuiFormRow, {
        id: labelId,
        label: /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inputControl.editor.controlEditor.controlLabel",
          defaultMessage: "Control Label"
        })
      }, /*#__PURE__*/React.createElement(EuiFieldText, {
        value: this.props.controlParams.label,
        onChange: this.changeLabel
      })), controlEditor);
    }
  }, {
    key: "renderEditorButtons",
    value: function renderEditorButtons() {
      return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(EuiButtonIcon, {
        "aria-label": this.props.intl.formatMessage({
          id: 'inputControl.editor.controlEditor.moveControlUpAriaLabel',
          defaultMessage: 'Move control up'
        }),
        color: "primary",
        onClick: this.moveUpControl,
        iconType: "sortUp",
        "data-test-subj": "inputControlEditorMoveUpControl".concat(this.props.controlIndex)
      }), /*#__PURE__*/React.createElement(EuiButtonIcon, {
        "aria-label": this.props.intl.formatMessage({
          id: 'inputControl.editor.controlEditor.moveControlDownAriaLabel',
          defaultMessage: 'Move control down'
        }),
        color: "primary",
        onClick: this.moveDownControl,
        iconType: "sortDown",
        "data-test-subj": "inputControlEditorMoveDownControl".concat(this.props.controlIndex)
      }), /*#__PURE__*/React.createElement(EuiButtonIcon, {
        "aria-label": this.props.intl.formatMessage({
          id: 'inputControl.editor.controlEditor.removeControlAriaLabel',
          defaultMessage: 'Remove control'
        }),
        color: "danger",
        onClick: this.removeControl,
        iconType: "cross",
        "data-test-subj": "inputControlEditorRemoveControl".concat(this.props.controlIndex)
      }));
    }
  }, {
    key: "render",
    value: function render() {
      return /*#__PURE__*/React.createElement(EuiPanel, {
        grow: false,
        className: "icvControlEditor__panel"
      }, /*#__PURE__*/React.createElement(EuiAccordion, {
        id: "controlEditorAccordion",
        buttonContent: getTitle(this.props.controlParams, this.props.controlIndex),
        extraAction: this.renderEditorButtons(),
        initialIsOpen: true
      }, /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "s"
      }), this.renderEditor()));
    }
  }]);

  return ControlEditorUi;
}(PureComponent);

export var ControlEditor = injectI18n(ControlEditorUi);