function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { esFilters } from '../../data/public';
import { getSavedObjectFinder } from '../../saved_objects/public';
import { bootstrap } from './bootstrap';
import { defaultEmbeddableFactoryProvider, EmbeddablePanel, isRangeSelectTriggerContext, isValueClickTriggerContext } from './lib';
import { AttributeService } from './lib/embeddables/attribute_service';
import { EmbeddableStateTransfer } from './lib/state_transfer';
export var EmbeddablePublicPlugin = /*#__PURE__*/function () {
  function EmbeddablePublicPlugin(initializerContext) {
    var _this = this;

    _classCallCheck(this, EmbeddablePublicPlugin);

    _defineProperty(this, "embeddableFactoryDefinitions", new Map());

    _defineProperty(this, "embeddableFactories", new Map());

    _defineProperty(this, "customEmbeddableFactoryProvider", void 0);

    _defineProperty(this, "outgoingOnlyStateTransfer", {});

    _defineProperty(this, "isRegistryReady", false);

    _defineProperty(this, "getEmbeddableFactories", function () {
      _this.ensureFactoriesExist();

      return _this.embeddableFactories.values();
    });

    _defineProperty(this, "registerEmbeddableFactory", function (embeddableFactoryId, factory) {
      if (_this.embeddableFactoryDefinitions.has(embeddableFactoryId)) {
        throw new Error("Embeddable factory [embeddableFactoryId = ".concat(embeddableFactoryId, "] already registered in Embeddables API."));
      }

      _this.embeddableFactoryDefinitions.set(embeddableFactoryId, factory);

      return function () {
        return _this.getEmbeddableFactory(embeddableFactoryId);
      };
    });

    _defineProperty(this, "getEmbeddableFactory", function (embeddableFactoryId) {
      if (!_this.isRegistryReady) {
        throw new Error('Embeddable factories can only be retrieved after setup lifecycle.');
      }

      _this.ensureFactoryExists(embeddableFactoryId);

      var factory = _this.embeddableFactories.get(embeddableFactoryId);

      if (!factory) {
        throw new Error("Embeddable factory [embeddableFactoryId = ".concat(embeddableFactoryId, "] does not exist."));
      }

      return factory;
    });

    _defineProperty(this, "ensureFactoriesExist", function () {
      _this.embeddableFactoryDefinitions.forEach(function (def) {
        return _this.ensureFactoryExists(def.type);
      });
    });

    _defineProperty(this, "ensureFactoryExists", function (type) {
      if (!_this.embeddableFactories.get(type)) {
        var def = _this.embeddableFactoryDefinitions.get(type);

        if (!def) return;

        _this.embeddableFactories.set(type, _this.customEmbeddableFactoryProvider ? _this.customEmbeddableFactoryProvider(def) : defaultEmbeddableFactoryProvider(def));
      }
    });
  }

  _createClass(EmbeddablePublicPlugin, [{
    key: "setup",
    value: function setup(core, _ref) {
      var _this2 = this;

      var uiActions = _ref.uiActions;
      bootstrap(uiActions);
      return {
        registerEmbeddableFactory: this.registerEmbeddableFactory,
        setCustomEmbeddableFactoryProvider: function setCustomEmbeddableFactoryProvider(provider) {
          if (_this2.customEmbeddableFactoryProvider) {
            throw new Error('Custom embeddable factory provider is already set, and can only be set once');
          }

          _this2.customEmbeddableFactoryProvider = provider;
        }
      };
    }
  }, {
    key: "start",
    value: function start(core, _ref2) {
      var _this3 = this;

      var data = _ref2.data,
          uiActions = _ref2.uiActions,
          inspector = _ref2.inspector;
      this.embeddableFactoryDefinitions.forEach(function (def) {
        _this3.embeddableFactories.set(def.type, _this3.customEmbeddableFactoryProvider ? _this3.customEmbeddableFactoryProvider(def) : defaultEmbeddableFactoryProvider(def));
      });
      this.outgoingOnlyStateTransfer = new EmbeddableStateTransfer(core.application.navigateToApp);
      this.isRegistryReady = true;

      var filtersFromContext = /*#__PURE__*/function () {
        var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(context) {
          return regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  _context.prev = 0;

                  if (!isRangeSelectTriggerContext(context)) {
                    _context.next = 5;
                    break;
                  }

                  _context.next = 4;
                  return data.actions.createFiltersFromRangeSelectAction(context.data);

                case 4:
                  return _context.abrupt("return", _context.sent);

                case 5:
                  if (!isValueClickTriggerContext(context)) {
                    _context.next = 9;
                    break;
                  }

                  _context.next = 8;
                  return data.actions.createFiltersFromValueClickAction(context.data);

                case 8:
                  return _context.abrupt("return", _context.sent);

                case 9:
                  // eslint-disable-next-line no-console
                  console.warn("Can't extract filters from action.", context);
                  _context.next = 15;
                  break;

                case 12:
                  _context.prev = 12;
                  _context.t0 = _context["catch"](0);
                  // eslint-disable-next-line no-console
                  console.warn('Error extracting filters from action. Returning empty filter list.', _context.t0);

                case 15:
                  return _context.abrupt("return", []);

                case 16:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee, null, [[0, 12]]);
        }));

        return function filtersFromContext(_x) {
          return _ref3.apply(this, arguments);
        };
      }();

      var filtersAndTimeRangeFromContext = /*#__PURE__*/function () {
        var _ref4 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(context) {
          var filters, _esFilters$extractTim, timeRangeFilter, restOfFilters;

          return regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
              switch (_context2.prev = _context2.next) {
                case 0:
                  _context2.next = 2;
                  return filtersFromContext(context);

                case 2:
                  filters = _context2.sent;

                  if (context.data.timeFieldName) {
                    _context2.next = 5;
                    break;
                  }

                  return _context2.abrupt("return", {
                    filters: filters
                  });

                case 5:
                  _esFilters$extractTim = esFilters.extractTimeFilter(context.data.timeFieldName, filters), timeRangeFilter = _esFilters$extractTim.timeRangeFilter, restOfFilters = _esFilters$extractTim.restOfFilters;
                  return _context2.abrupt("return", {
                    filters: restOfFilters,
                    timeRange: timeRangeFilter ? esFilters.convertRangeFilterToTimeRangeString(timeRangeFilter) : undefined
                  });

                case 7:
                case "end":
                  return _context2.stop();
              }
            }
          }, _callee2);
        }));

        return function filtersAndTimeRangeFromContext(_x2) {
          return _ref4.apply(this, arguments);
        };
      }();

      var getEmbeddablePanelHoc = function getEmbeddablePanelHoc(stateTransfer) {
        return function (_ref5) {
          var embeddable = _ref5.embeddable,
              hideHeader = _ref5.hideHeader;
          return /*#__PURE__*/React.createElement(EmbeddablePanel, {
            hideHeader: hideHeader,
            embeddable: embeddable,
            stateTransfer: stateTransfer ? stateTransfer : _this3.outgoingOnlyStateTransfer,
            getActions: uiActions.getTriggerCompatibleActions,
            getEmbeddableFactory: _this3.getEmbeddableFactory,
            getAllEmbeddableFactories: _this3.getEmbeddableFactories,
            overlays: core.overlays,
            notifications: core.notifications,
            application: core.application,
            inspector: inspector,
            SavedObjectFinder: getSavedObjectFinder(core.savedObjects, core.uiSettings)
          });
        };
      };

      return {
        getEmbeddableFactory: this.getEmbeddableFactory,
        getEmbeddableFactories: this.getEmbeddableFactories,
        getAttributeService: function getAttributeService(type) {
          return new AttributeService(type, core.savedObjects.client);
        },
        filtersFromContext: filtersFromContext,
        filtersAndTimeRangeFromContext: filtersAndTimeRangeFromContext,
        getStateTransfer: function getStateTransfer(history) {
          return history ? new EmbeddableStateTransfer(core.application.navigateToApp, history) : _this3.outgoingOnlyStateTransfer;
        },
        EmbeddablePanel: getEmbeddablePanelHoc(),
        getEmbeddablePanel: getEmbeddablePanelHoc
      };
    }
  }, {
    key: "stop",
    value: function stop() {}
  }]);

  return EmbeddablePublicPlugin;
}();