/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { getAngularModule, getServices, getUrlTracker } from '../../kibana_services';
getAngularModule().config(function ($routeProvider) {
  $routeProvider.otherwise({
    resolveRedirectTo: function resolveRedirectTo($rootScope) {
      var path = window.location.hash.substr(1);
      getUrlTracker().restorePreviousUrl();
      $rootScope.$applyAsync(function () {
        var _getServices = getServices(),
            kibanaLegacy = _getServices.kibanaLegacy;

        var _kibanaLegacy$navigat = kibanaLegacy.navigateToLegacyKibanaUrl(path),
            navigated = _kibanaLegacy$navigat.navigated;

        if (!navigated) {
          kibanaLegacy.navigateToDefaultApp();
        }
      }); // prevent angular from completing the navigation

      return new Promise(function () {});
    }
  });
});