function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiButton, EuiButtonEmpty, EuiForm, EuiFormRow, EuiModalBody, EuiModalFooter, EuiModalHeader, EuiModalHeaderTitle, EuiSwitch } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import React, { Component } from 'react';
import { getDisplayValueFromFilter } from '../../../common';
import { FilterLabel } from '../filter_bar';
import { mapAndFlattenFilters } from '../../query';
export var ApplyFiltersPopoverContent = /*#__PURE__*/function (_Component) {
  _inherits(ApplyFiltersPopoverContent, _Component);

  var _super = _createSuper(ApplyFiltersPopoverContent);

  function ApplyFiltersPopoverContent(props) {
    var _this;

    _classCallCheck(this, ApplyFiltersPopoverContent);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "isFilterSelected", function (i) {
      return _this.state.isFilterSelected[i];
    });

    _defineProperty(_assertThisInitialized(_this), "toggleFilterSelected", function (i) {
      var isFilterSelected = _toConsumableArray(_this.state.isFilterSelected);

      isFilterSelected[i] = !isFilterSelected[i];

      _this.setState({
        isFilterSelected: isFilterSelected
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onSubmit", function () {
      var selectedFilters = _this.props.filters.filter(function (filter, i) {
        return _this.state.isFilterSelected[i];
      });

      _this.props.onSubmit(selectedFilters);
    });

    _this.state = {
      isFilterSelected: props.filters.map(function () {
        return true;
      })
    };
    return _this;
  }

  _createClass(ApplyFiltersPopoverContent, [{
    key: "getLabel",
    value: function getLabel(filter) {
      var valueLabel = getDisplayValueFromFilter(filter, this.props.indexPatterns);
      return /*#__PURE__*/React.createElement(FilterLabel, {
        filter: filter,
        valueLabel: valueLabel
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      if (this.props.filters.length === 0) {
        return '';
      }

      var mappedFilters = mapAndFlattenFilters(this.props.filters);
      var form = /*#__PURE__*/React.createElement(EuiForm, null, mappedFilters.map(function (filter, i) {
        return /*#__PURE__*/React.createElement(EuiFormRow, {
          key: i
        }, /*#__PURE__*/React.createElement(EuiSwitch, {
          label: _this2.getLabel(filter),
          checked: _this2.isFilterSelected(i),
          onChange: function onChange() {
            return _this2.toggleFilterSelected(i);
          }
        }));
      }));
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiModalHeader, null, /*#__PURE__*/React.createElement(EuiModalHeaderTitle, null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "data.filter.applyFilters.popupHeader",
        defaultMessage: "Select filters to apply"
      }))), /*#__PURE__*/React.createElement(EuiModalBody, null, form), /*#__PURE__*/React.createElement(EuiModalFooter, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
        onClick: this.props.onCancel
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "data.filter.applyFiltersPopup.cancelButtonLabel",
        defaultMessage: "Cancel"
      })), /*#__PURE__*/React.createElement(EuiButton, {
        onClick: this.onSubmit,
        "data-test-subj": "applyFiltersPopoverButton",
        fill: true
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "data.filter.applyFiltersPopup.saveButtonLabel",
        defaultMessage: "Apply"
      }))));
    }
  }]);

  return ApplyFiltersPopoverContent;
}(Component);

_defineProperty(ApplyFiltersPopoverContent, "defaultProps", {
  filters: []
});