function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import * as React from 'react';
import { BehaviorSubject } from 'rxjs';
import { filter, map } from 'rxjs/operators';
import { i18n } from '@kbn/i18n';
import { CONTEXT_MENU_TRIGGER } from '../../embeddable/public';
import { esFilters } from '../../data/public';
import { getSavedObjectFinder } from '../../saved_objects/public';
import { ExitFullScreenButton as ExitFullScreenButtonUi } from '../../kibana_react/public';
import { createKbnUrlTracker, Storage } from '../../kibana_utils/public';
import { initAngularBootstrap } from '../../kibana_legacy/public';
import { FeatureCatalogueCategory } from '../../../plugins/home/public';
import { DEFAULT_APP_CATEGORIES } from '../../../core/public';
import { ACTION_CLONE_PANEL, ACTION_EXPAND_PANEL, ACTION_REPLACE_PANEL, ClonePanelAction, DASHBOARD_CONTAINER_TYPE, DashboardContainerFactoryDefinition, ExpandPanelAction, ReplacePanelAction } from './application';
import { createDashboardUrlGenerator, DASHBOARD_APP_URL_GENERATOR } from './url_generator';
import { createSavedDashboardLoader } from './saved_dashboards';
import { DashboardConstants } from './dashboard_constants';
import { addEmbeddableToDashboardUrl } from './url_utils/url_helper';
import { PlaceholderEmbeddableFactory } from './application/embeddable/placeholder';
import { createDashboardContainerByValueRenderer } from './application';
export var DashboardPlugin = /*#__PURE__*/function () {
  function DashboardPlugin(initializerContext) {
    _classCallCheck(this, DashboardPlugin);

    this.initializerContext = initializerContext;

    _defineProperty(this, "appStateUpdater", new BehaviorSubject(function () {
      return {};
    }));

    _defineProperty(this, "stopUrlTracking", undefined);

    _defineProperty(this, "getActiveUrl", undefined);

    _defineProperty(this, "currentHistory", undefined);

    _defineProperty(this, "dashboardUrlGenerator", void 0);
  }

  _createClass(DashboardPlugin, [{
    key: "setup",
    value: function setup(core, _ref) {
      var _this = this;

      var share = _ref.share,
          uiActions = _ref.uiActions,
          embeddable = _ref.embeddable,
          home = _ref.home,
          kibanaLegacy = _ref.kibanaLegacy,
          data = _ref.data,
          usageCollection = _ref.usageCollection;
      var expandPanelAction = new ExpandPanelAction();
      uiActions.registerAction(expandPanelAction);
      uiActions.attachAction(CONTEXT_MENU_TRIGGER, expandPanelAction.id);
      var startServices = core.getStartServices();

      if (share) {
        this.dashboardUrlGenerator = share.urlGenerators.registerUrlGenerator(createDashboardUrlGenerator( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
          var _yield$startServices, _yield$startServices2, coreStart, selfStart;

          return regeneratorRuntime.wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  _context.next = 2;
                  return startServices;

                case 2:
                  _yield$startServices = _context.sent;
                  _yield$startServices2 = _slicedToArray(_yield$startServices, 3);
                  coreStart = _yield$startServices2[0];
                  selfStart = _yield$startServices2[2];
                  return _context.abrupt("return", {
                    appBasePath: coreStart.application.getUrlForApp('dashboards'),
                    useHashedUrl: coreStart.uiSettings.get('state:storeInSessionStorage'),
                    savedDashboardLoader: selfStart.getSavedDashboardLoader()
                  });

                case 7:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee);
        }))));
      }

      var getStartServices = /*#__PURE__*/function () {
        var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
          var _yield$core$getStartS, _yield$core$getStartS2, coreStart, deps, useHideChrome, ExitFullScreenButton;

          return regeneratorRuntime.wrap(function _callee2$(_context2) {
            while (1) {
              switch (_context2.prev = _context2.next) {
                case 0:
                  _context2.next = 2;
                  return core.getStartServices();

                case 2:
                  _yield$core$getStartS = _context2.sent;
                  _yield$core$getStartS2 = _slicedToArray(_yield$core$getStartS, 2);
                  coreStart = _yield$core$getStartS2[0];
                  deps = _yield$core$getStartS2[1];

                  useHideChrome = function useHideChrome() {
                    var _ref4 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
                      toggleChrome: true
                    },
                        toggleChrome = _ref4.toggleChrome;

                    React.useEffect(function () {
                      if (toggleChrome) {
                        coreStart.chrome.setIsVisible(false);
                      }

                      return function () {
                        if (toggleChrome) {
                          coreStart.chrome.setIsVisible(true);
                        }
                      };
                    }, [toggleChrome]);
                  };

                  ExitFullScreenButton = function ExitFullScreenButton(_ref5) {
                    var toggleChrome = _ref5.toggleChrome,
                        props = _objectWithoutProperties(_ref5, ["toggleChrome"]);

                    useHideChrome({
                      toggleChrome: toggleChrome
                    });
                    return /*#__PURE__*/React.createElement(ExitFullScreenButtonUi, props);
                  };

                  return _context2.abrupt("return", {
                    capabilities: coreStart.application.capabilities,
                    application: coreStart.application,
                    notifications: coreStart.notifications,
                    overlays: coreStart.overlays,
                    embeddable: deps.embeddable,
                    inspector: deps.inspector,
                    SavedObjectFinder: getSavedObjectFinder(coreStart.savedObjects, coreStart.uiSettings),
                    ExitFullScreenButton: ExitFullScreenButton,
                    uiActions: deps.uiActions
                  });

                case 9:
                case "end":
                  return _context2.stop();
              }
            }
          }, _callee2);
        }));

        return function getStartServices() {
          return _ref3.apply(this, arguments);
        };
      }();

      var factory = new DashboardContainerFactoryDefinition(getStartServices, function () {
        return _this.currentHistory;
      });
      embeddable.registerEmbeddableFactory(factory.type, factory);
      var placeholderFactory = new PlaceholderEmbeddableFactory();
      embeddable.registerEmbeddableFactory(placeholderFactory.type, placeholderFactory);

      var _createKbnUrlTracker = createKbnUrlTracker({
        baseUrl: core.http.basePath.prepend('/app/dashboards'),
        defaultSubUrl: "#".concat(DashboardConstants.LANDING_PAGE_PATH),
        storageKey: "lastUrl:".concat(core.http.basePath.get(), ":dashboard"),
        navLinkUpdater$: this.appStateUpdater,
        toastNotifications: core.notifications.toasts,
        stateParams: [{
          kbnUrlKey: '_g',
          stateUpdate$: data.query.state$.pipe(filter(function (_ref6) {
            var changes = _ref6.changes;
            return !!(changes.globalFilters || changes.time || changes.refreshInterval);
          }), map(function (_ref7) {
            var _state$filters;

            var state = _ref7.state;
            return _objectSpread(_objectSpread({}, state), {}, {
              filters: (_state$filters = state.filters) === null || _state$filters === void 0 ? void 0 : _state$filters.filter(esFilters.isFilterPinned)
            });
          }))
        }],
        getHistory: function getHistory() {
          return _this.currentHistory;
        }
      }),
          appMounted = _createKbnUrlTracker.appMounted,
          appUnMounted = _createKbnUrlTracker.appUnMounted,
          stopUrlTracker = _createKbnUrlTracker.stop,
          getActiveUrl = _createKbnUrlTracker.getActiveUrl,
          restorePreviousUrl = _createKbnUrlTracker.restorePreviousUrl;

      this.getActiveUrl = getActiveUrl;

      this.stopUrlTracking = function () {
        stopUrlTracker();
      };

      var app = {
        id: DashboardConstants.DASHBOARDS_ID,
        title: 'Dashboard',
        order: -1001,
        euiIconType: 'dashboardApp',
        defaultPath: "#".concat(DashboardConstants.LANDING_PAGE_PATH),
        updater$: this.appStateUpdater,
        category: DEFAULT_APP_CATEGORIES.kibana,
        mount: function () {
          var _mount = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(params) {
            var _yield$core$getStartS3, _yield$core$getStartS4, coreStart, pluginsStart, dashboardStart, embeddableStart, navigation, shareStart, dataStart, _pluginsStart$kibanaL, dashboardConfig, navigateToDefaultApp, navigateToLegacyKibanaUrl, savedObjects, deps, _yield$import, renderApp, unmount;

            return regeneratorRuntime.wrap(function _callee3$(_context3) {
              while (1) {
                switch (_context3.prev = _context3.next) {
                  case 0:
                    _context3.next = 2;
                    return core.getStartServices();

                  case 2:
                    _yield$core$getStartS3 = _context3.sent;
                    _yield$core$getStartS4 = _slicedToArray(_yield$core$getStartS3, 3);
                    coreStart = _yield$core$getStartS4[0];
                    pluginsStart = _yield$core$getStartS4[1];
                    dashboardStart = _yield$core$getStartS4[2];
                    _this.currentHistory = params.history;
                    appMounted();
                    embeddableStart = pluginsStart.embeddable, navigation = pluginsStart.navigation, shareStart = pluginsStart.share, dataStart = pluginsStart.data, _pluginsStart$kibanaL = pluginsStart.kibanaLegacy, dashboardConfig = _pluginsStart$kibanaL.dashboardConfig, navigateToDefaultApp = _pluginsStart$kibanaL.navigateToDefaultApp, navigateToLegacyKibanaUrl = _pluginsStart$kibanaL.navigateToLegacyKibanaUrl, savedObjects = pluginsStart.savedObjects;
                    deps = {
                      pluginInitializerContext: _this.initializerContext,
                      core: coreStart,
                      dashboardConfig: dashboardConfig,
                      navigateToDefaultApp: navigateToDefaultApp,
                      navigateToLegacyKibanaUrl: navigateToLegacyKibanaUrl,
                      navigation: navigation,
                      share: shareStart,
                      data: dataStart,
                      savedObjectsClient: coreStart.savedObjects.client,
                      savedDashboards: dashboardStart.getSavedDashboardLoader(),
                      chrome: coreStart.chrome,
                      addBasePath: coreStart.http.basePath.prepend,
                      uiSettings: coreStart.uiSettings,
                      savedQueryService: dataStart.query.savedQueries,
                      embeddable: embeddableStart,
                      dashboardCapabilities: coreStart.application.capabilities.dashboard,
                      embeddableCapabilities: {
                        visualizeCapabilities: coreStart.application.capabilities.visualize,
                        mapsCapabilities: coreStart.application.capabilities.maps
                      },
                      localStorage: new Storage(localStorage),
                      usageCollection: usageCollection,
                      scopedHistory: function scopedHistory() {
                        return _this.currentHistory;
                      },
                      savedObjects: savedObjects,
                      restorePreviousUrl: restorePreviousUrl
                    }; // make sure the index pattern list is up to date

                    _context3.next = 13;
                    return dataStart.indexPatterns.clearCache();

                  case 13:
                    _context3.next = 15;
                    return import('./application/application');

                  case 15:
                    _yield$import = _context3.sent;
                    renderApp = _yield$import.renderApp;
                    params.element.classList.add('dshAppContainer');
                    unmount = renderApp(params.element, params.appBasePath, deps);
                    return _context3.abrupt("return", function () {
                      unmount();
                      appUnMounted();
                    });

                  case 20:
                  case "end":
                    return _context3.stop();
                }
              }
            }, _callee3);
          }));

          function mount(_x) {
            return _mount.apply(this, arguments);
          }

          return mount;
        }()
      };
      initAngularBootstrap();
      core.application.register(app);
      kibanaLegacy.forwardApp(DashboardConstants.DASHBOARDS_ID, DashboardConstants.DASHBOARDS_ID, function (path) {
        var _ref8 = /(\?.*)/.exec(path) || [],
            _ref9 = _slicedToArray(_ref8, 2),
            tail = _ref9[1]; // carry over query if it exists


        return "#/list".concat(tail || '');
      });
      kibanaLegacy.forwardApp(DashboardConstants.DASHBOARD_ID, DashboardConstants.DASHBOARDS_ID, function (path) {
        var _ref10 = /dashboard\/?(.*?)($|\?.*)/.exec(path) || [],
            _ref11 = _slicedToArray(_ref10, 3),
            id = _ref11[1],
            tail = _ref11[2];

        if (!id && !tail) {
          // unrecognized sub url
          return '#/list';
        }

        if (!id && tail) {
          // unsaved dashboard, but probably state in URL
          return "#/create".concat(tail || '');
        } // persisted dashboard, probably with url state


        return "#/view/".concat(id).concat(tail || '');
      });

      if (home) {
        home.featureCatalogue.register({
          id: DashboardConstants.DASHBOARD_ID,
          title: i18n.translate('dashboard.featureCatalogue.dashboardTitle', {
            defaultMessage: 'Dashboard'
          }),
          description: i18n.translate('dashboard.featureCatalogue.dashboardDescription', {
            defaultMessage: 'Display and share a collection of visualizations and saved searches.'
          }),
          icon: 'dashboardApp',
          path: "/app/dashboards#".concat(DashboardConstants.LANDING_PAGE_PATH),
          showOnHomePage: true,
          category: FeatureCatalogueCategory.DATA
        });
      }
    }
  }, {
    key: "addEmbeddableToDashboard",
    value: function addEmbeddableToDashboard(core, _ref12) {
      var embeddableId = _ref12.embeddableId,
          embeddableType = _ref12.embeddableType;

      if (!this.getActiveUrl) {
        throw new Error('dashboard is not ready yet.');
      }

      var lastDashboardUrl = this.getActiveUrl();
      var dashboardUrl = addEmbeddableToDashboardUrl(lastDashboardUrl, embeddableId, embeddableType);
      core.application.navigateToApp('dashboards', {
        path: dashboardUrl
      });
    }
  }, {
    key: "start",
    value: function start(core, plugins) {
      var notifications = core.notifications;
      var uiActions = plugins.uiActions,
          _plugins$data = plugins.data,
          indexPatterns = _plugins$data.indexPatterns,
          search = _plugins$data.search;
      var SavedObjectFinder = getSavedObjectFinder(core.savedObjects, core.uiSettings);
      var changeViewAction = new ReplacePanelAction(core, SavedObjectFinder, notifications, plugins.embeddable.getEmbeddableFactories);
      uiActions.registerAction(changeViewAction);
      uiActions.attachAction(CONTEXT_MENU_TRIGGER, changeViewAction.id);
      var clonePanelAction = new ClonePanelAction(core);
      uiActions.registerAction(clonePanelAction);
      uiActions.attachAction(CONTEXT_MENU_TRIGGER, clonePanelAction.id);
      var savedDashboardLoader = createSavedDashboardLoader({
        savedObjectsClient: core.savedObjects.client,
        indexPatterns: indexPatterns,
        search: search,
        chrome: core.chrome,
        overlays: core.overlays
      });
      var dashboardContainerFactory = plugins.embeddable.getEmbeddableFactory(DASHBOARD_CONTAINER_TYPE);
      return {
        getSavedDashboardLoader: function getSavedDashboardLoader() {
          return savedDashboardLoader;
        },
        addEmbeddableToDashboard: this.addEmbeddableToDashboard.bind(this, core),
        dashboardUrlGenerator: this.dashboardUrlGenerator,
        DashboardContainerByValueRenderer: createDashboardContainerByValueRenderer({
          factory: dashboardContainerFactory
        })
      };
    }
  }, {
    key: "stop",
    value: function stop() {
      if (this.stopUrlTracking) {
        this.stopUrlTracking();
      }
    }
  }]);

  return DashboardPlugin;
}();