/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import React from 'react';
import { EuiFlexGroup, EuiFlexItem, EuiBadge, EuiText, EuiToolTip } from '@elastic/eui';

var mapStatusCodeToBadgeColor = function mapStatusCodeToBadgeColor(statusCode) {
  if (statusCode <= 199) {
    return 'default';
  }

  if (statusCode <= 299) {
    return 'secondary';
  }

  if (statusCode <= 399) {
    return 'primary';
  }

  if (statusCode <= 499) {
    return 'warning';
  }

  return 'danger';
};

export var NetworkRequestStatusBar = function NetworkRequestStatusBar(_ref) {
  var requestInProgress = _ref.requestInProgress,
      requestResult = _ref.requestResult;
  var content = null;

  if (requestInProgress) {
    content = /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiBadge, {
      color: "hollow"
    }, i18n.translate('console.requestInProgressBadgeText', {
      defaultMessage: 'Request in progress'
    })));
  } else if (requestResult) {
    var endpoint = requestResult.endpoint,
        method = requestResult.method,
        statusCode = requestResult.statusCode,
        statusText = requestResult.statusText,
        timeElapsedMs = requestResult.timeElapsedMs;
    content = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiToolTip, {
      position: "top",
      content: /*#__PURE__*/React.createElement(EuiText, {
        size: "s"
      }, "".concat(method, " ").concat(endpoint.startsWith('/') ? endpoint : '/' + endpoint))
    }, /*#__PURE__*/React.createElement(EuiBadge, {
      color: mapStatusCodeToBadgeColor(statusCode)
    }, statusCode, "\xA0-\xA0", statusText))), /*#__PURE__*/React.createElement(EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/React.createElement(EuiToolTip, {
      position: "top",
      content: /*#__PURE__*/React.createElement(EuiText, {
        size: "s"
      }, i18n.translate('console.requestTimeElapasedBadgeTooltipContent', {
        defaultMessage: 'Time Elapsed'
      }))
    }, /*#__PURE__*/React.createElement(EuiText, {
      size: "s"
    }, /*#__PURE__*/React.createElement(EuiBadge, {
      color: "default"
    }, timeElapsedMs, "\xA0", 'ms')))));
  }

  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    direction: "row",
    gutterSize: "s",
    responsive: false
  }, content);
};