function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { MappedColors } from './mapped_colors';
import { seedColors } from './seed_colors';
/**
 * Accepts an array of strings or numbers that are used to create a
 * a lookup table that associates the values (key) with a hex color (value).
 * Returns a function that accepts a value (i.e. a string or number)
 * and returns a hex color associated with that value.
 */

export var ColorsService = /*#__PURE__*/function () {
  function ColorsService() {
    _classCallCheck(this, ColorsService);

    _defineProperty(this, "_mappedColors", void 0);

    _defineProperty(this, "seedColors", seedColors);
  }

  _createClass(ColorsService, [{
    key: "init",
    value: function init(uiSettings) {
      this._mappedColors = new MappedColors(uiSettings);
    }
  }, {
    key: "createColorLookupFunction",
    value: function createColorLookupFunction(arrayOfStringsOrNumbers) {
      var _this = this;

      var colorMapping = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      if (!Array.isArray(arrayOfStringsOrNumbers)) {
        throw new Error("createColorLookupFunction expects an array but recived: ".concat(_typeof(arrayOfStringsOrNumbers)));
      }

      arrayOfStringsOrNumbers.forEach(function (val) {
        if (!_.isString(val) && !_.isNumber(val) && !_.isUndefined(val)) {
          throw new TypeError('createColorLookupFunction expects an array of strings, numbers, or undefined values');
        }
      });
      this.mappedColors.mapKeys(arrayOfStringsOrNumbers);
      return function (value) {
        return colorMapping[value] || _this.mappedColors.get(value);
      };
    }
  }, {
    key: "mappedColors",
    get: function get() {
      if (!this._mappedColors) {
        throw new Error('ColorService not yet initialized');
      }

      return this._mappedColors;
    }
  }]);

  return ColorsService;
}();