function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiButton, EuiButtonEmpty, EuiCallOut, EuiCodeBlock, EuiEmptyPrompt, EuiPage, EuiPageBody, EuiPageContent } from '@elastic/eui';
import React from 'react';
import * as Rx from 'rxjs';
import { tap } from 'rxjs/operators';
import { FormattedMessage } from '@kbn/i18n/react';
export var FatalErrorsScreen = /*#__PURE__*/function (_React$Component) {
  _inherits(FatalErrorsScreen, _React$Component);

  var _super = _createSuper(FatalErrorsScreen);

  function FatalErrorsScreen() {
    var _this;

    _classCallCheck(this, FatalErrorsScreen);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      errors: []
    });

    _defineProperty(_assertThisInitialized(_this), "subscription", void 0);

    _defineProperty(_assertThisInitialized(_this), "onClickGoBack", function (e) {
      e.preventDefault();
      window.history.back();
    });

    _defineProperty(_assertThisInitialized(_this), "onClickClearSession", function (e) {
      e.preventDefault();
      localStorage.clear();
      sessionStorage.clear();
      window.location.hash = '';
      window.location.reload();
    });

    return _this;
  }

  _createClass(FatalErrorsScreen, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this2 = this;

      this.subscription = Rx.merge( // reload the page if hash-based navigation is attempted
      Rx.fromEvent(window, 'hashchange').pipe(tap(function () {
        window.location.reload();
      })), // consume error notifications and set them to the component state
      this.props.errorInfo$.pipe(tap(function (error) {
        _this2.setState(function (state) {
          return _objectSpread(_objectSpread({}, state), {}, {
            errors: [].concat(_toConsumableArray(state.errors), [error])
          });
        });
      }))).subscribe({
        error: function error(_error) {
          // eslint-disable-next-line no-console
          console.error('Uncaught error in fatal error screen internals', _error);
        }
      });
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this.subscription) {
        this.subscription.unsubscribe();
        this.subscription = undefined;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      return /*#__PURE__*/React.createElement(EuiPage, {
        style: {
          minHeight: '100vh'
        }
      }, /*#__PURE__*/React.createElement(EuiPageBody, null, /*#__PURE__*/React.createElement(EuiPageContent, {
        verticalPosition: "center",
        horizontalPosition: "center"
      }, /*#__PURE__*/React.createElement(EuiEmptyPrompt, {
        iconType: "alert",
        iconColor: "danger",
        title: /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "core.fatalErrors.somethingWentWrongTitle",
          defaultMessage: "Something went wrong"
        })),
        body: /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "core.fatalErrors.tryRefreshingPageDescription",
          defaultMessage: "Try refreshing the page. If that doesn't work, go back to the previous page or clear your session data."
        })),
        actions: [/*#__PURE__*/React.createElement(EuiButton, {
          color: "primary",
          fill: true,
          onClick: this.onClickClearSession,
          "data-test-subj": "clearSession"
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "core.fatalErrors.clearYourSessionButtonLabel",
          defaultMessage: "Clear your session"
        })), /*#__PURE__*/React.createElement(EuiButtonEmpty, {
          onClick: this.onClickGoBack,
          "data-test-subj": "goBack"
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "core.fatalErrors.goBackButtonLabel",
          defaultMessage: "Go back"
        }))]
      }), this.state.errors.map(function (error, i) {
        return /*#__PURE__*/React.createElement(EuiCallOut, {
          key: i,
          title: error.message,
          color: "danger",
          iconType: "alert"
        }, /*#__PURE__*/React.createElement(EuiCodeBlock, {
          language: "bash",
          className: "eui-textBreakAll"
        }, "Version: ".concat(_this3.props.kibanaVersion) + '\n' + "Build: ".concat(_this3.props.buildNumber) + '\n' + (error.stack ? error.stack : '')));
      }))));
    }
  }]);

  return FatalErrorsScreen;
}(React.Component);