function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import moment from 'moment-timezone';
import { METRIC_TYPE } from './';
export var ApplicationUsage = /*#__PURE__*/function () {
  function ApplicationUsage() {
    _classCallCheck(this, ApplicationUsage);

    _defineProperty(this, "currentUsage", void 0);
  }

  _createClass(ApplicationUsage, [{
    key: "start",
    value: function start() {
      var _this = this;

      // Count any clicks and assign it to the current app
      if (window) window.addEventListener('click', function () {
        return _this.currentUsage && _this.currentUsage.numberOfClicks++;
      });
    }
  }, {
    key: "appChanged",
    value: function appChanged(appId) {
      var currentUsage = this.currentUsage;

      if (appId) {
        this.currentUsage = {
          type: METRIC_TYPE.APPLICATION_USAGE,
          appId: appId,
          startTime: moment(),
          numberOfClicks: 0
        };
      } else {
        this.currentUsage = void 0;
      }

      return currentUsage;
    }
  }]);

  return ApplicationUsage;
}();