"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiFocusTrap = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactFocusLock = _interopRequireDefault(require("react-focus-lock"));

var _outside_click_detector = require("../outside_click_detector");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var OutsideEventDetector = function OutsideEventDetector(_ref) {
  var children = _ref.children,
      handleEvent = _ref.handleEvent,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "handleEvent"]);
  return _react.default.createElement("div", (0, _extends2.default)({
    onMouseDown: handleEvent,
    onTouchStart: handleEvent
  }, rest), children);
};
/**
 * A DOM node, a selector string (which will be passed to
 * `document.querySelector()` to find the DOM node), or a function that
 * returns a DOM node.
 */


OutsideEventDetector.propTypes = {
  handleEvent: _propTypes.default.any.isRequired
};

var EuiFocusTrap =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiFocusTrap, _Component);

  function EuiFocusTrap() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiFocusTrap);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiFocusTrap)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      hasBeenDisabledByClick: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "lastInterceptedEvent", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "preventFocusExit", false);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setInitialFocus", function (initialFocus) {
      var node = initialFocus instanceof HTMLElement ? initialFocus : null;

      if (typeof initialFocus === 'string') {
        node = document.querySelector(initialFocus);
      } else if (typeof initialFocus === 'function') {
        node = initialFocus();
      }

      if (!node) return; // `data-autofocus` is part of the 'react-focus-lock' API

      node.setAttribute('data-autofocus', 'true');
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "toggleDisabled", function () {
      var shouldDisable = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : !_this.state.hasBeenDisabledByClick;

      _this.setState({
        hasBeenDisabledByClick: shouldDisable
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "toggleExitPrevented", function () {
      var shouldPrevent = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : !_this.preventFocusExit;
      _this.preventFocusExit = shouldPrevent;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOutsideClick", function (event) {
      _this.toggleExitPrevented(false);

      if (_this.preventFocusExit && _this.lastInterceptedEvent && event.target === _this.lastInterceptedEvent.target) return;

      _this.toggleDisabled(true);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleBubbledEvent", function (e) {
      _this.lastInterceptedEvent = e.nativeEvent;

      _this.toggleExitPrevented(true);
    });
    return _this;
  }

  (0, _createClass2.default)(EuiFocusTrap, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.setInitialFocus(this.props.initialFocus);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.disabled === true && this.props.disabled === false) {
        // eslint-disable-next-line react/no-did-update-set-state
        this.setState({
          hasBeenDisabledByClick: false
        });
      }
    } // Programmatically sets focus on a nested DOM node; optional

  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          _this$props$clickOuts = _this$props.clickOutsideDisables,
          clickOutsideDisables = _this$props$clickOuts === void 0 ? false : _this$props$clickOuts,
          _this$props$disabled = _this$props.disabled,
          disabled = _this$props$disabled === void 0 ? false : _this$props$disabled,
          _this$props$returnFoc = _this$props.returnFocus,
          returnFocus = _this$props$returnFoc === void 0 ? true : _this$props$returnFoc,
          style = _this$props.style,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["children", "clickOutsideDisables", "disabled", "returnFocus", "style"]);
      var isDisabled = disabled || this.state.hasBeenDisabledByClick;

      var lockProps = _objectSpread({
        disabled: isDisabled,
        returnFocus: returnFocus
      }, rest);

      return clickOutsideDisables ? _react.default.createElement(_outside_click_detector.EuiOutsideClickDetector, {
        isDisabled: isDisabled,
        onOutsideClick: this.handleOutsideClick
      }, _react.default.createElement(OutsideEventDetector, {
        handleEvent: this.handleBubbledEvent
      }, _react.default.createElement(_reactFocusLock.default, (0, _extends2.default)({
        lockProps: {
          style: style
        }
      }, lockProps), children))) : _react.default.createElement(_reactFocusLock.default, (0, _extends2.default)({
        lockProps: {
          style: style
        }
      }, lockProps), children);
    }
  }]);
  return EuiFocusTrap;
}(_react.Component);

exports.EuiFocusTrap = EuiFocusTrap;
EuiFocusTrap.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  clickOutsideDisables: _propTypes.default.bool,
  initialFocus: _propTypes.default.oneOfType([_propTypes.default.any.isRequired, _propTypes.default.string.isRequired, _propTypes.default.func.isRequired]),
  style: _propTypes.default.any
};
EuiFocusTrap.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "setInitialFocus",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "initialFocus",
      "type": null
    }],
    "returns": null
  }, {
    "name": "toggleDisabled",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "shouldDisable",
      "type": null
    }],
    "returns": null
  }, {
    "name": "toggleExitPrevented",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "shouldPrevent",
      "type": null
    }],
    "returns": null
  }, {
    "name": "handleOutsideClick",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "event",
      "type": null
    }],
    "returns": null
  }, {
    "name": "handleBubbledEvent",
    "docblock": null,
    "modifiers": [],
    "params": [{
      "name": "e",
      "type": null
    }],
    "returns": null
  }],
  "displayName": "EuiFocusTrap",
  "props": {
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "clickOutsideDisables": {
      "type": {
        "name": "bool"
      },
      "required": false,
      "description": ""
    },
    "initialFocus": {
      "type": {
        "name": "union",
        "value": [{
          "name": "any"
        }, {
          "name": "string"
        }, {
          "name": "func"
        }]
      },
      "required": false,
      "description": ""
    },
    "style": {
      "type": {
        "name": "any"
      },
      "required": false,
      "description": ""
    }
  }
};