"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useContainerCallbacks = void 0;

var _react = require("react");

var _services = require("../../services");

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function isMouseEvent(event) {
  return _typeof(event) === 'object' && 'pageX' in event && 'pageY' in event;
}

var pxToPercent = function pxToPercent(proportion, whole) {
  return proportion / whole * 100;
};

var getPanelMinSize = function getPanelMinSize(panelMinSize, containerSize, resizerSize) {
  var panelMinSizePercent = 0;
  var panelMinSizeInt = parseInt(panelMinSize);

  if (panelMinSize.indexOf('px') > -1) {
    panelMinSizePercent = pxToPercent(panelMinSizeInt, containerSize);
  } else if (panelMinSize.indexOf('%') > -1) {
    panelMinSizePercent = panelMinSizeInt + resizerSize / containerSize * panelMinSizeInt;
  }

  return panelMinSizePercent;
};

var useContainerCallbacks = function useContainerCallbacks(_ref) {
  var isHorizontal = _ref.isHorizontal,
      state = _ref.state,
      setState = _ref.setState,
      containerRef = _ref.containerRef,
      registryRef = _ref.registryRef,
      onPanelWidthChange = _ref.onPanelWidthChange;
  var getContainerSize = (0, _react.useCallback)(function () {
    return isHorizontal ? containerRef.current.getBoundingClientRect().width : containerRef.current.getBoundingClientRect().height;
  }, [containerRef, isHorizontal]);
  var getResizerButtonsSize = (0, _react.useCallback)(function () {
    // get sum of all of resizer button sizes to proper calculate panels ratio
    var allResizers = containerRef.current.getElementsByClassName('euiResizableButton');
    var size = isHorizontal ? allResizers[0].offsetWidth : allResizers[0].offsetHeight;
    return size * allResizers.length;
  }, [containerRef, isHorizontal]);
  var onMouseDown = (0, _react.useCallback)(function (event) {
    var currentTarget = event.currentTarget;
    var clientX = isMouseEvent(event) ? event.clientX : event.touches[0].clientX;
    var clientY = isMouseEvent(event) ? event.clientY : event.touches[0].clientY;
    setState(function (prevState) {
      return _objectSpread({}, prevState, {
        isDragging: true,
        currentResizerPos: isHorizontal ? clientX : clientY,
        previousPanelId: currentTarget.previousElementSibling.id,
        nextPanelId: currentTarget.nextElementSibling.id,
        resizersSize: getResizerButtonsSize()
      });
    });
  }, [getResizerButtonsSize, isHorizontal, setState]);
  var onKeyDown = (0, _react.useCallback)(function (event) {
    var key = event.key,
        currentTarget = event.currentTarget;
    var shouldResizeHorizontalPanel = isHorizontal && (key === _services.keys.ARROW_LEFT || key === _services.keys.ARROW_RIGHT);
    var shouldResizeVerticalPanel = !isHorizontal && (key === _services.keys.ARROW_UP || key === _services.keys.ARROW_DOWN);
    var prevPanelId = currentTarget.previousElementSibling.id;
    var nextPanelId = currentTarget.nextElementSibling.id;

    if ((shouldResizeHorizontalPanel || shouldResizeVerticalPanel) && prevPanelId && nextPanelId) {
      event.preventDefault();
      var registry = registryRef.current;

      var _registry$getResizerS = registry.getResizerSiblings(prevPanelId, nextPanelId),
          _registry$getResizerS2 = _slicedToArray(_registry$getResizerS, 2),
          prevPanel = _registry$getResizerS2[0],
          nextPanel = _registry$getResizerS2[1];

      var resizersSize = getResizerButtonsSize();
      var containerSize = getContainerSize();
      var prevPanelSize = pxToPercent(prevPanel.getSizePx() - (key === _services.keys.ARROW_UP || key === _services.keys.ARROW_LEFT ? 10 : -10), containerSize - resizersSize);
      var nextPanelSize = pxToPercent(nextPanel.getSizePx() - (key === _services.keys.ARROW_DOWN || key === _services.keys.ARROW_RIGHT ? 10 : -10), containerSize - resizersSize);
      setState(_objectSpread({}, state, {
        isDragging: false
      }));
      var panelObject = registry.fetchAllPanels(prevPanelId, nextPanelId, containerSize - resizersSize);

      if (prevPanelSize !== nextPanelSize && onPanelWidthChange) {
        var _objectSpread2;

        onPanelWidthChange(_objectSpread({}, panelObject, (_objectSpread2 = {}, _defineProperty(_objectSpread2, prevPanelId, prevPanelSize), _defineProperty(_objectSpread2, nextPanelId, nextPanelSize), _objectSpread2)));
        prevPanel.setSize(prevPanelSize);
        nextPanel.setSize(nextPanelSize);
      }
    }
  }, // `setState` is safe to omit from `useCallback`
  // (https://reactjs.org/docs/hooks-reference.html#usestate)
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [getContainerSize, getResizerButtonsSize, isHorizontal, onPanelWidthChange, registryRef]);
  var onMouseMove = (0, _react.useCallback)(function (event) {
    if (state.isDragging && state.previousPanelId && state.nextPanelId) {
      var clientX = isMouseEvent(event) ? event.clientX : event.touches[0].clientX;
      var clientY = isMouseEvent(event) ? event.clientY : event.touches[0].clientY;
      var x = isHorizontal ? clientX : clientY;
      var registry = registryRef.current;

      var _registry$getResizerS3 = registry.getResizerSiblings(state.previousPanelId, state.nextPanelId),
          _registry$getResizerS4 = _slicedToArray(_registry$getResizerS3, 2),
          prevPanel = _registry$getResizerS4[0],
          nextPanel = _registry$getResizerS4[1];

      var delta = x - state.currentResizerPos;
      var containerSize = getContainerSize() - state.resizersSize;
      var prevPanelMin = getPanelMinSize(prevPanel.minSize, containerSize, state.resizersSize);
      var nextPanelMin = getPanelMinSize(nextPanel.minSize, containerSize, state.resizersSize);
      var prevPanelSize = pxToPercent(prevPanel.getSizePx() + delta, containerSize);
      var nextPanelSize = pxToPercent(nextPanel.getSizePx() - delta, containerSize);
      var panelObject = registry.fetchAllPanels(state.previousPanelId, state.nextPanelId, containerSize);

      if (prevPanelSize >= prevPanelMin && nextPanelSize >= nextPanelMin) {
        if (onPanelWidthChange) {
          var _objectSpread3;

          onPanelWidthChange(_objectSpread({}, panelObject, (_objectSpread3 = {}, _defineProperty(_objectSpread3, state.previousPanelId, prevPanelSize), _defineProperty(_objectSpread3, state.nextPanelId, nextPanelSize), _objectSpread3)));
        }

        prevPanel.setSize(prevPanelSize);
        nextPanel.setSize(nextPanelSize);
        setState(_objectSpread({}, state, {
          currentResizerPos: x
        }));
      }
    }
  }, [getContainerSize, isHorizontal, onPanelWidthChange, registryRef, setState, state]);
  return {
    onMouseDown: onMouseDown,
    onKeyDown: onKeyDown,
    onMouseMove: onMouseMove
  };
};

exports.useContainerCallbacks = useContainerCallbacks;