"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("../../../scales/constants");
var specs_1 = require("./specs");
var stacked_series_utils_1 = require("./stacked_series_utils");
var getXYValues = function (_a) {
    var x = _a.x, y1 = _a.y1, fittingIndex = _a.fittingIndex;
    return [typeof x === 'string' ? fittingIndex : x, y1];
};
exports.getValue = function (current, currentIndex, previous, next, type, endValue) {
    if (previous !== null && type === specs_1.Fit.Carry) {
        return __assign(__assign({}, current), { filled: {
                y1: previous.y1,
            } });
    }
    if (next !== null && type === specs_1.Fit.Lookahead) {
        return __assign(__assign({}, current), { filled: {
                y1: next.y1,
            } });
    }
    if (previous !== null && next !== null) {
        if (type === specs_1.Fit.Average) {
            return __assign(__assign({}, current), { filled: {
                    y1: (previous.y1 + next.y1) / 2,
                } });
        }
        if (current.x !== null && previous.x !== null && next.x !== null) {
            var _a = __read(getXYValues(previous), 2), x1 = _a[0], y1 = _a[1];
            var _b = __read(getXYValues(next), 2), x2 = _b[0], y2 = _b[1];
            var currentX = typeof current.x === 'string' ? currentIndex : current.x;
            if (type === specs_1.Fit.Nearest) {
                var x1Delta = Math.abs(currentX - x1);
                var x2Delta = Math.abs(currentX - x2);
                return __assign(__assign({}, current), { filled: {
                        y1: x1Delta > x2Delta ? y2 : y1,
                    } });
            }
            if (type === specs_1.Fit.Linear) {
                return __assign(__assign({}, current), { filled: {
                        y1: previous.y1 + (currentX - x1) * ((y2 - y1) / (x2 - x1)),
                    } });
            }
        }
    }
    else if ((previous !== null || next !== null) && (type === specs_1.Fit.Nearest || endValue === 'nearest')) {
        return __assign(__assign({}, current), { filled: {
                y1: previous !== null ? previous.y1 : next.y1,
            } });
    }
    if (endValue === undefined || typeof endValue === 'string') {
        return current;
    }
    return __assign(__assign({}, current), { filled: {
            y1: endValue,
        } });
};
exports.parseConfig = function (config) {
    if (!config) {
        return {
            type: specs_1.Fit.None,
        };
    }
    if (typeof config === 'string') {
        return {
            type: config,
        };
    }
    if (config.type === specs_1.Fit.Explicit && config.value === undefined) {
        return {
            type: specs_1.Fit.None,
        };
    }
    return {
        type: config.type,
        value: config.type === specs_1.Fit.Explicit ? config.value : undefined,
        endValue: config.endValue,
    };
};
exports.fitFunction = function (dataSeries, fitConfig, xScaleType, sorted) {
    if (sorted === void 0) { sorted = false; }
    var _a = exports.parseConfig(fitConfig), type = _a.type, value = _a.value, endValue = _a.endValue;
    if (type === specs_1.Fit.None) {
        return dataSeries;
    }
    var data = dataSeries.data;
    if (type === specs_1.Fit.Zero) {
        return __assign(__assign({}, dataSeries), { data: data.map(function (datum) { return (__assign(__assign({}, datum), { filled: {
                    y1: datum.y1 === null ? 0 : undefined,
                } })); }) });
    }
    if (type === specs_1.Fit.Explicit) {
        if (value === undefined) {
            return dataSeries;
        }
        return __assign(__assign({}, dataSeries), { data: data.map(function (datum) { return (__assign(__assign({}, datum), { filled: {
                    y1: datum.y1 === null ? value : undefined,
                } })); }) });
    }
    var sortedData = sorted || xScaleType === constants_1.ScaleType.Ordinal ? data : data.slice().sort(stacked_series_utils_1.datumXSortPredicate(xScaleType));
    var newData = [];
    var previousNonNullDatum = null;
    var nextNonNullDatum = null;
    for (var i = 0; i < sortedData.length; i++) {
        var j = i;
        var current = sortedData[i];
        if (current.y1 === null
            && nextNonNullDatum === null
            && (type === specs_1.Fit.Lookahead
                || type === specs_1.Fit.Nearest
                || type === specs_1.Fit.Average
                || type === specs_1.Fit.Linear
                || endValue === 'nearest')) {
            for (j = i + 1; j < sortedData.length; j++) {
                var value_1 = sortedData[j];
                if (value_1.y1 !== null && value_1.x !== null) {
                    nextNonNullDatum = __assign(__assign({}, value_1), { fittingIndex: j });
                    break;
                }
            }
        }
        var newValue = current.y1 === null ? exports.getValue(current, i, previousNonNullDatum, nextNonNullDatum, type, endValue) : current;
        newData[i] = newValue;
        if (current.y1 !== null && current.x !== null) {
            previousNonNullDatum = __assign(__assign({}, current), { fittingIndex: i });
        }
        if (nextNonNullDatum !== null && nextNonNullDatum.x <= current.x) {
            nextNonNullDatum = null;
        }
    }
    return __assign(__assign({}, dataSeries), { data: newData });
};
//# sourceMappingURL=fit_function.js.map