'\"
'\" Generated from file 'canvas_drag\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "canvas::drag" n 0\&.1 tklib "Variations on a canvas"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
canvas::drag \- Manage the dragging of canvas items or item groups
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBTk  8\&.5\fR
.sp
package require \fBcanvas::drag  ?0\&.1?\fR
.sp
\fB::canvas::drag\fR \fBon\fR \fIcanvas\fR \fItagOrId\fR \fIcmd\fR \fIoption\fR\&.\&.\&.
.sp
\fB::canvas::drag\fR \fBoff\fR \fIcanvas\fR \fItagOrId\fR
.sp
\fB::canvas::drag\fR \fBitem\fR \fIcanvas\fR \fItagOrId\fR \fIoption\fR\&.\&.\&.
.sp
\fB::canvas::drag\fR \fBgroup\fR \fIcanvas\fR \fItagOrId\fR \fIcmd\fR \fIoption\fR\&.\&.\&.
.sp
\fB{*}cmd\fR \fBstart\fR \fIcanvas\fR \fIitem\fR
.sp
\fB{*}cmd\fR \fBmove\fR \fIcanvas\fR \fIclientdata\fR \fIdx\fR \fIdy\fR
.sp
\fB{*}cmd\fR \fBdone\fR \fIcanvas\fR \fIclientdata\fR
.sp
.BE
.SH DESCRIPTION
This package provides utility commands to setup and rmeove dragging of
items or item groups on a canvas, hiding all complexity regarding
bindings from the user\&.
.SH API
.TP
\fB::canvas::drag\fR \fBon\fR \fIcanvas\fR \fItagOrId\fR \fIcmd\fR \fIoption\fR\&.\&.\&.
This command initializes item dragging on the \fIcanvas\fR widget,
with the items used as drag handles identified by \fItagOrId\fR\&.
The command prefix \fIcmd\fR, invoked for drag start and movement, is
responsible for the initialization and actual execution of the drag
operation\&.
.sp
The signature of the command prefix is described later, in
section \fBDrag callback\fR\&.
.sp
Similarly, the accepted options and their values are described
in section \fBOptions\fR
.sp
The result of the command is the empty string\&.
.TP
\fB::canvas::drag\fR \fBoff\fR \fIcanvas\fR \fItagOrId\fR
This command removes any drag operation set on the items of canvas
\fIcanvas\fR identified by \fItagOrId\fR\&.
.sp
The result of the command is the empty string\&.
.TP
\fB::canvas::drag\fR \fBitem\fR \fIcanvas\fR \fItagOrId\fR \fIoption\fR\&.\&.\&.
This is a convenience command wrapped around method \fBon\fR (see above)
to drag single items of the \fIcanvas\fR widget, identified by \fItagOrId\fR\&.
.sp
It uses an internal standard callback for this\&.
.sp
The result of the command is the empty string\&.
.TP
\fB::canvas::drag\fR \fBgroup\fR \fIcanvas\fR \fItagOrId\fR \fIcmd\fR \fIoption\fR\&.\&.\&.
This is a convenience command wrapped around method \fBon\fR (see above)
to drag single items of the \fIcanvas\fR widget, identified by \fItagOrId\fR\&.
.sp
It uses an internal standard callback for this\&. The callback
\fIcmd\fR specified has the same signature as the \fBDrag callback\fR,
except that
.RS
.IP [1]
The \fBmove\fR method is not invoked\&.
.IP [2]
The result of the \fBstart\fR method \fIhas to be\fR a
canvas tag refering to the whole group of items to move\&. In other words,
it must convert from drag handle (item id) to dragged groupt (tag)\&.
.RE
.sp
The result of the command is the empty string\&.
.PP
.SS "DRAG CALLBACK"
The drag callback is a command prefix invoked in the following two
ways:
.TP
\fB{*}cmd\fR \fBstart\fR \fIcanvas\fR \fIitem\fR
This form is invoked when has initiated dragging using drag handle
identified by the canvas \fIitem\fR id\&.
The callback now has to perform anything necessary for its type of
drag operation\&.
.sp
The result of the command can be anything\&. It is stored by the
system as client information and passed unchanged to the movement
callback for its use\&. In this manner the drag callback is able to
maintain custom state from start to movement\&.
.TP
\fB{*}cmd\fR \fBmove\fR \fIcanvas\fR \fIclientdata\fR \fIdx\fR \fIdy\fR
This form is invoked when the mouse moved during a drag operation\&.
It is invoked with the client data from the start callback (or the
previous move callback) and the distances the mouse has traveled in
horizontal and vertical directions\&.
.sp
The result of the command can be anything\&. It is stored by the
system as client information and passed unchanged to the next movement
callback for its use\&. In this manner the drag callback is able to
maintain custom state from movement to movement\&.
.TP
\fB{*}cmd\fR \fBdone\fR \fIcanvas\fR \fIclientdata\fR
This form is invoked when the drag operation ends\&.
It is invoked with the client data from the last movement callback (or
start callback if there had been no motion)\&.
.sp
The result of the command is ignored\&.
.PP
.SS OPTIONS
The commands to create drag operations (\fBon\fR, \fBitem\fR,
and \fBgroup\fR) all accept the following options to configure the
new drag\&.
.TP
\fB-event\fR \fIspec\fR
The value of this option specifies the mouse button used to initiate
the drag operation, and the keyboard modifier, if any\&. Examples of
specifications:
.sp
To initiate a drag operation by pressing mouse button 3 on a
drag handle, use:
.CS

 -event 3
.CE
.IP
This is the default as well, if the option is not specified\&.
.sp
To initiate a drag operation by pressing mouse button 2 on a
drag handle while holding down the Control key, use:
.CS

 -event Control-2
.CE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIcanvas\fR of the
\fITklib Trackers\fR [http://core\&.tcl\&.tk/tklib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
canvas, dragging