/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.traccar.Context;
import org.traccar.api.BaseObjectResource;
import org.traccar.database.DeviceManager;
import org.traccar.helper.LogAction;
import org.traccar.model.Device;
import org.traccar.model.DeviceAccumulators;

@Path(value="devices")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DeviceResource
extends BaseObjectResource<Device> {
    public DeviceResource() {
        super(Device.class);
    }

    @GET
    public Collection<Device> get(@QueryParam(value="all") boolean all, @QueryParam(value="userId") long userId, @QueryParam(value="uniqueId") List<String> uniqueIds, @QueryParam(value="id") List<Long> deviceIds) throws SQLException {
        DeviceManager deviceManager = Context.getDeviceManager();
        Set<Object> result = null;
        if (all) {
            if (Context.getPermissionsManager().getUserAdmin(this.getUserId())) {
                result = deviceManager.getAllItems();
            } else {
                Context.getPermissionsManager().checkManager(this.getUserId());
                result = deviceManager.getManagedItems(this.getUserId());
            }
        } else if (uniqueIds.isEmpty() && deviceIds.isEmpty()) {
            if (userId == 0L) {
                userId = this.getUserId();
            }
            Context.getPermissionsManager().checkUser(this.getUserId(), userId);
            result = Context.getPermissionsManager().getUserAdmin(this.getUserId()) ? deviceManager.getAllUserItems(userId) : deviceManager.getUserItems(userId);
        } else {
            result = new HashSet();
            for (String uniqueId : uniqueIds) {
                Device device = deviceManager.getByUniqueId(uniqueId);
                Context.getPermissionsManager().checkDevice(this.getUserId(), device.getId());
                result.add(device.getId());
            }
            for (Long deviceId : deviceIds) {
                Context.getPermissionsManager().checkDevice(this.getUserId(), deviceId);
                result.add(deviceId);
            }
        }
        return deviceManager.getItems(result);
    }

    @Path(value="{id}/accumulators")
    @PUT
    public Response updateAccumulators(DeviceAccumulators entity) throws SQLException {
        if (!Context.getPermissionsManager().getUserAdmin(this.getUserId())) {
            Context.getPermissionsManager().checkManager(this.getUserId());
            Context.getPermissionsManager().checkPermission(Device.class, this.getUserId(), entity.getDeviceId());
        }
        Context.getDeviceManager().resetDeviceAccumulators(entity);
        LogAction.resetDeviceAccumulators(this.getUserId(), entity.getDeviceId());
        return Response.noContent().build();
    }
}

