/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.ByteArrayAdapter;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import java.util.Arrays;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChangeMasterSecretAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    @XmlJavaTypeAdapter(value=ByteArrayAdapter.class)
    private byte[] newValue = null;
    @XmlJavaTypeAdapter(value=ByteArrayAdapter.class)
    private byte[] oldValue = null;

    public ChangeMasterSecretAction(byte[] newValue) {
        this.newValue = newValue;
    }

    public ChangeMasterSecretAction() {
    }

    public void setNewValue(byte[] newValue) {
        this.newValue = newValue;
    }

    public byte[] getNewValue() {
        return this.newValue;
    }

    public byte[] getOldValue() {
        return this.oldValue;
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        this.oldValue = tlsContext.getMasterSecret();
        tlsContext.setMasterSecret(this.newValue);
        LOGGER.info("Changed MasterSecret from " + ArrayConverter.bytesToHexString((byte[])this.oldValue) + " to " + ArrayConverter.bytesToHexString((byte[])this.newValue));
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.oldValue = null;
        this.setExecuted(null);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Arrays.hashCode(this.newValue);
        hash = 71 * hash + Arrays.hashCode(this.oldValue);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeMasterSecretAction other = (ChangeMasterSecretAction)obj;
        if (!Arrays.equals(this.newValue, other.newValue)) {
            return false;
        }
        return Arrays.equals(this.oldValue, other.oldValue);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

