/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.ConnectionBoundAction;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChangeCompressionAction
extends ConnectionBoundAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private CompressionMethod newValue = null;
    private CompressionMethod oldValue = null;

    public ChangeCompressionAction(CompressionMethod newValue) {
        this.newValue = newValue;
    }

    public ChangeCompressionAction() {
    }

    public void setNewValue(CompressionMethod newValue) {
        this.newValue = newValue;
    }

    public CompressionMethod getNewValue() {
        return this.newValue;
    }

    public CompressionMethod getOldValue() {
        return this.oldValue;
    }

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        TlsContext tlsContext = state.getTlsContext(this.getConnectionAlias());
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        this.oldValue = tlsContext.getSelectedCompressionMethod();
        tlsContext.setSelectedCompressionMethod(this.newValue);
        tlsContext.getRecordLayer().updateCompressor();
        tlsContext.getRecordLayer().updateDecompressor();
        LOGGER.info("Changed selected CompressionMethod from " + (this.oldValue == null ? "null" : this.oldValue.name()) + " to " + this.newValue.name());
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.oldValue = null;
        this.setExecuted(null);
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 23 * hash + Objects.hashCode((Object)this.newValue);
        hash = 23 * hash + Objects.hashCode((Object)this.oldValue);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeCompressionAction other = (ChangeCompressionAction)obj;
        if (this.newValue != other.newValue) {
            return false;
        }
        return this.oldValue == other.oldValue;
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

