/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.serializer;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSL2ServerHelloSerializer
extends ProtocolMessageSerializer<SSL2ServerHelloMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final SSL2ServerHelloMessage message;

    public SSL2ServerHelloSerializer(SSL2ServerHelloMessage message, TlsContext tlsContext) {
        super(message, tlsContext.getChooser().getSelectedProtocolVersion());
        this.message = message;
    }

    @Override
    public byte[] serializeProtocolMessageContent() {
        LOGGER.debug("Serialize SSL2ServerHello");
        this.writeMessageLength(this.message);
        this.writeType(this.message);
        this.writeSessionIdHit(this.message);
        this.writeCetificateType(this.message);
        this.writeProtocolVersion(this.message);
        this.writeCertificateLength(this.message);
        this.writeCipherSuitesLength(this.message);
        this.writeSessionIDLength(this.message);
        this.writeCertificate(this.message);
        this.writeCipherSuites(this.message);
        this.writeSessionID(this.message);
        return this.getAlreadySerialized();
    }

    private void writeMessageLength(SSL2ServerHelloMessage message) {
        if ((Integer)message.getPaddingLength().getValue() != 0) {
            throw new UnsupportedOperationException("Long record headers are not supported");
        }
        this.appendInt((Integer)message.getMessageLength().getValue(), 2);
        LOGGER.debug("MessageLength: " + message.getMessageLength().getValue());
    }

    private void writeType(SSL2ServerHelloMessage message) {
        this.appendByte((Byte)message.getType().getValue());
        LOGGER.debug("Type: " + message.getType().getValue());
    }

    private void writeSessionIdHit(SSL2ServerHelloMessage message) {
        this.appendByte((Byte)message.getSessionIdHit().getValue());
        LOGGER.debug("SessionIdHit: " + message.getSessionIdHit().getValue());
    }

    private void writeCetificateType(SSL2ServerHelloMessage message) {
        this.appendByte((Byte)message.getCertificateType().getValue());
        LOGGER.debug("CertificateType: " + message.getCertificateType().getValue());
    }

    private void writeProtocolVersion(SSL2ServerHelloMessage message) {
        this.appendBytes((byte[])message.getProtocolVersion().getValue());
        LOGGER.debug("ProtocolVersion: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getProtocolVersion().getValue())));
    }

    private void writeCertificateLength(SSL2ServerHelloMessage message) {
        this.appendInt((Integer)message.getCertificateLength().getValue(), 2);
        LOGGER.debug("CertificateLength: " + message.getCertificateLength().getValue());
    }

    private void writeCipherSuitesLength(SSL2ServerHelloMessage message) {
        this.appendInt((Integer)message.getCipherSuitesLength().getValue(), 2);
        LOGGER.debug("ChipherSuitesLength: " + message.getCipherSuitesLength().getValue());
    }

    private void writeSessionIDLength(SSL2ServerHelloMessage message) {
        this.appendInt((Integer)message.getSessionIdLength().getValue(), 2);
        LOGGER.debug("SessionIDLength: " + message.getSessionIdLength().getValue());
    }

    private void writeCertificate(SSL2ServerHelloMessage message) {
        this.appendBytes((byte[])message.getCertificate().getValue());
        LOGGER.debug("Certificate: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getCertificate().getValue())));
    }

    private void writeCipherSuites(SSL2ServerHelloMessage message) {
        this.appendBytes((byte[])message.getCipherSuites().getValue());
        LOGGER.debug("CipherSuites: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getCipherSuites().getValue())));
    }

    private void writeSessionID(SSL2ServerHelloMessage message) {
        this.appendBytes((byte[])message.getSessionId().getValue());
        LOGGER.debug("SessionID: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getSessionId().getValue())));
    }
}

