/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.AlpnExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.alpn.AlpnEntry;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.AlpnEntryParser;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import java.util.LinkedList;

public class AlpnExtensionParser
extends ExtensionParser<AlpnExtensionMessage> {
    public AlpnExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(AlpnExtensionMessage msg) {
        msg.setAlpnExtensionLength(this.parseIntField(2));
        byte[] anouncedProtocols = this.parseByteArrayField((Integer)msg.getAlpnExtensionLength().getValue());
        msg.setAlpnAnnouncedProtocols(anouncedProtocols);
        LinkedList<AlpnEntry> entryList = new LinkedList<AlpnEntry>();
        int pointer = 0;
        while (pointer < anouncedProtocols.length) {
            AlpnEntryParser parser = new AlpnEntryParser(pointer, anouncedProtocols);
            entryList.add(parser.parse());
            pointer = parser.getPointer();
        }
        msg.setAlpnEntryList(entryList);
    }

    @Override
    protected AlpnExtensionMessage createExtensionMessage() {
        return new AlpnExtensionMessage();
    }
}

