/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.padding;

import de.rub.nds.tlsattacker.attacks.constants.PaddingRecordGeneratorType;
import de.rub.nds.tlsattacker.attacks.padding.LongPaddingGenerator;
import de.rub.nds.tlsattacker.attacks.padding.LongRecordPaddingGenerator;
import de.rub.nds.tlsattacker.attacks.padding.MediumPaddingGenerator;
import de.rub.nds.tlsattacker.attacks.padding.PaddingVectorGenerator;
import de.rub.nds.tlsattacker.attacks.padding.ShortPaddingGenerator;
import de.rub.nds.tlsattacker.attacks.padding.VeryShortPaddingGenerator;
import de.rub.nds.tlsattacker.attacks.padding.vector.PaddingVector;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;

public abstract class PaddingTraceGenerator {
    protected final PaddingVectorGenerator vectorGenerator;

    public PaddingTraceGenerator(PaddingRecordGeneratorType type) {
        switch (type) {
            case LONG_RECORD: {
                this.vectorGenerator = new LongRecordPaddingGenerator();
                break;
            }
            case LONG: {
                this.vectorGenerator = new LongPaddingGenerator();
                break;
            }
            case MEDIUM: {
                this.vectorGenerator = new MediumPaddingGenerator();
                break;
            }
            case SHORT: {
                this.vectorGenerator = new ShortPaddingGenerator();
                break;
            }
            case VERY_SHORT: {
                this.vectorGenerator = new VeryShortPaddingGenerator();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown RecordGenerator Type");
            }
        }
    }

    public abstract WorkflowTrace getPaddingOracleWorkflowTrace(Config var1, PaddingVector var2);

    public PaddingVectorGenerator getVectorGenerator() {
        return this.vectorGenerator;
    }
}

