/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov;

import com.drew.imaging.quicktime.QuickTimeHandler;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Metadata;
import com.drew.metadata.mov.QuickTimeDirectory;
import com.drew.metadata.mov.QuickTimeHandlerFactory;
import com.drew.metadata.mov.atoms.Atom;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public abstract class QuickTimeMediaHandler<T extends QuickTimeDirectory>
extends QuickTimeHandler<T> {
    public QuickTimeMediaHandler(Metadata metadata) {
        super(metadata);
        if (QuickTimeHandlerFactory.HANDLER_PARAM_CREATION_TIME != null && QuickTimeHandlerFactory.HANDLER_PARAM_MODIFICATION_TIME != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1904, 0, 1, 0, 0, 0);
            Date date = calendar.getTime();
            long macToUnixEpochOffset = date.getTime();
            String creationTimeStamp = new Date(QuickTimeHandlerFactory.HANDLER_PARAM_CREATION_TIME * 1000L + macToUnixEpochOffset).toString();
            String modificationTimeStamp = new Date(QuickTimeHandlerFactory.HANDLER_PARAM_MODIFICATION_TIME * 1000L + macToUnixEpochOffset).toString();
            this.directory.setString(20481, creationTimeStamp);
            this.directory.setString(20482, modificationTimeStamp);
        }
    }

    @Override
    public boolean shouldAcceptAtom(@NotNull Atom atom) {
        return atom.type.equals(this.getMediaInformation()) || atom.type.equals("stsd") || atom.type.equals("stts");
    }

    @Override
    public boolean shouldAcceptContainer(@NotNull Atom atom) {
        return atom.type.equals("stbl") || atom.type.equals("minf") || atom.type.equals("gmhd") || atom.type.equals("tmcd");
    }

    @Override
    public QuickTimeMediaHandler processAtom(@NotNull Atom atom, @Nullable byte[] payload) throws IOException {
        if (payload != null) {
            SequentialByteArrayReader reader = new SequentialByteArrayReader(payload);
            if (atom.type.equals(this.getMediaInformation())) {
                this.processMediaInformation(reader, atom);
            } else if (atom.type.equals("stsd")) {
                this.processSampleDescription(reader, atom);
            } else if (atom.type.equals("stts")) {
                this.processTimeToSample(reader, atom);
            }
        }
        return this;
    }

    protected abstract String getMediaInformation();

    protected abstract void processSampleDescription(@NotNull SequentialReader var1, @NotNull Atom var2) throws IOException;

    protected abstract void processMediaInformation(@NotNull SequentialReader var1, @NotNull Atom var2) throws IOException;

    protected abstract void processTimeToSample(@NotNull SequentialReader var1, @NotNull Atom var2) throws IOException;
}

