/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.component.RealTimeGetComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.CopyField;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.NumericValueFieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtomicUpdateDocumentMerger {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final IndexSchema schema;
    protected final SchemaField idField;

    public AtomicUpdateDocumentMerger(SolrQueryRequest queryReq) {
        this.schema = queryReq.getSchema();
        this.idField = this.schema.getUniqueKeyField();
    }

    public static boolean isAtomicUpdate(AddUpdateCommand cmd) {
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        for (SolrInputField sif : sdoc.values()) {
            Object val = sif.getValue();
            if (!(val instanceof Map) || val instanceof SolrDocumentBase) continue;
            return true;
        }
        return false;
    }

    public SolrInputDocument merge(SolrInputDocument fromDoc, SolrInputDocument toDoc) {
        for (SolrInputField sif : fromDoc.values()) {
            Object val = sif.getValue();
            if (val instanceof Map) {
                for (Map.Entry entry : ((Map)val).entrySet()) {
                    String key = (String)entry.getKey();
                    Object fieldVal = entry.getValue();
                    switch (key) {
                        case "add": {
                            this.doAdd(toDoc, sif, fieldVal);
                            break;
                        }
                        case "set": {
                            this.doSet(toDoc, sif, fieldVal);
                            break;
                        }
                        case "remove": {
                            this.doRemove(toDoc, sif, fieldVal);
                            break;
                        }
                        case "removeregex": {
                            this.doRemoveRegex(toDoc, sif, fieldVal);
                            break;
                        }
                        case "inc": {
                            this.doInc(toDoc, sif, fieldVal);
                            break;
                        }
                        case "add-distinct": {
                            this.doAddDistinct(toDoc, sif, fieldVal);
                            break;
                        }
                        default: {
                            Object id = toDoc.containsKey((Object)this.idField.getName()) ? toDoc.getFieldValue(this.idField.getName()) : fromDoc.getFieldValue(this.idField.getName());
                            String err = "Unknown operation for the an atomic update, operation ignored: " + key;
                            if (id != null) {
                                err = err + " for id:" + id;
                            }
                            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, err);
                        }
                    }
                    if (!this.idField.getName().equals(sif.getName())) continue;
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid update of id field: " + sif);
                }
                continue;
            }
            toDoc.put(sif.getName(), sif);
        }
        return toDoc;
    }

    public static boolean isSupportedFieldForInPlaceUpdate(SchemaField schemaField) {
        return !schemaField.indexed() && !schemaField.stored() && schemaField.hasDocValues() && !schemaField.multiValued() && schemaField.getType() instanceof NumericValueFieldType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> computeInPlaceUpdatableFields(AddUpdateCommand cmd) throws IOException {
        SolrInputDocument sdoc = cmd.getSolrInputDocument();
        IndexSchema schema = cmd.getReq().getSchema();
        SchemaField uniqueKeyField = schema.getUniqueKeyField();
        String uniqueKeyFieldName = null == uniqueKeyField ? null : uniqueKeyField.getName();
        HashSet<String> candidateFields = new HashSet<String>();
        SchemaField versionField = schema.getFieldOrNull("_version_");
        if (versionField == null || !AtomicUpdateDocumentMerger.isSupportedFieldForInPlaceUpdate(versionField)) {
            return Collections.emptySet();
        }
        String routeFieldOrNull = AtomicUpdateDocumentMerger.getRouteField(cmd);
        for (String fieldName : sdoc.getFieldNames()) {
            Object fieldValue = sdoc.getField(fieldName).getValue();
            if (fieldName.equals(uniqueKeyFieldName) || fieldName.equals("_version_") || fieldName.equals(routeFieldOrNull)) {
                if (!(fieldValue instanceof Map)) continue;
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Updating unique key, version or route field is not allowed: " + sdoc.getField(fieldName));
            }
            if (!(fieldValue instanceof Map)) {
                return Collections.emptySet();
            }
            Map fieldValueMap = (Map)fieldValue;
            for (Map.Entry entry : fieldValueMap.entrySet()) {
                String op = (String)entry.getKey();
                Object obj = entry.getValue();
                if (!op.equals("set") && !op.equals("inc")) {
                    return Collections.emptySet();
                }
                if (op.equals("set") && (obj == null || obj instanceof Collection && ((Collection)obj).isEmpty())) {
                    return Collections.emptySet();
                }
                if (!AtomicUpdateDocumentMerger.isChildDoc(((Map)fieldValue).get(op))) continue;
                return Collections.emptySet();
            }
            candidateFields.add(fieldName);
        }
        if (candidateFields.isEmpty()) {
            return Collections.emptySet();
        }
        for (String fieldName : candidateFields) {
            SchemaField schemaField = schema.getField(fieldName);
            if (!AtomicUpdateDocumentMerger.isSupportedFieldForInPlaceUpdate(schemaField)) {
                return Collections.emptySet();
            }
            for (CopyField copyField : schema.getCopyFieldsList(fieldName)) {
                if (AtomicUpdateDocumentMerger.isSupportedFieldForInPlaceUpdate(copyField.getDestination())) continue;
                return Collections.emptySet();
            }
        }
        SolrCore core = cmd.getReq().getCore();
        RefCounted<IndexWriter> holder = core.getSolrCoreState().getIndexWriter(core);
        Set segmentSortingFields = null;
        try {
            IndexWriter iw = holder.get();
            segmentSortingFields = iw.getConfig().getIndexSortFields();
        }
        finally {
            holder.decref();
        }
        for (String fieldName : candidateFields) {
            if (!segmentSortingFields.contains(fieldName)) continue;
            return Collections.emptySet();
        }
        return candidateFields;
    }

    private static String getRouteField(AddUpdateCommand cmd) {
        String result = null;
        SolrCore core = cmd.getReq().getCore();
        CloudDescriptor cloudDescriptor = core.getCoreDescriptor().getCloudDescriptor();
        if (cloudDescriptor != null) {
            String collectionName = cloudDescriptor.getCollectionName();
            ZkController zkController = core.getCoreContainer().getZkController();
            DocCollection collection = zkController.getClusterState().getCollection(collectionName);
            result = collection.getRouter().getRouteField(collection);
        }
        return result;
    }

    public static boolean isDerivedFromDoc(SolrInputDocument fullDoc, SolrInputDocument partialDoc) {
        for (SolrInputField subSif : partialDoc) {
            Collection fieldValues = fullDoc.getFieldValues(subSif.getName());
            if (fieldValues == null) {
                return false;
            }
            if (fieldValues.size() < subSif.getValueCount()) {
                return false;
            }
            Collection partialFieldValues = subSif.getValues();
            Stream<Object> nonChildDocElements = partialFieldValues.stream().filter(x -> !AtomicUpdateDocumentMerger.isChildDoc(x) || !fieldValues.stream().anyMatch(y -> AtomicUpdateDocumentMerger.isChildDoc(x) && AtomicUpdateDocumentMerger.isDerivedFromDoc((SolrInputDocument)y, (SolrInputDocument)x)));
            if (nonChildDocElements.allMatch(fieldValues::contains)) continue;
            return false;
        }
        return true;
    }

    public static SolrInputField getFieldFromHierarchy(SolrInputDocument completeHierarchy, String fieldPath) {
        List docPaths = StrUtils.splitSmart((String)fieldPath.substring(1), (char)'/');
        SolrInputField sifToReplace = null;
        SolrInputDocument currDoc = completeHierarchy;
        for (String subPathString : docPaths) {
            Pair<String, Integer> subPath = AtomicUpdateDocumentMerger.getPathAndIndexFromNestPath(subPathString);
            sifToReplace = currDoc.getField((String)subPath.getLeft());
            currDoc = (SolrInputDocument)((List)sifToReplace.getValues()).get((Integer)subPath.getRight());
        }
        return sifToReplace;
    }

    public boolean doInPlaceUpdateMerge(AddUpdateCommand cmd, Set<String> updatedFields) throws IOException {
        SolrInputDocument inputDoc = cmd.getSolrInputDocument();
        BytesRef idBytes = cmd.getIndexedId();
        updatedFields.add("_version_");
        SolrInputDocument oldDocument = RealTimeGetComponent.getInputDocument(cmd.getReq().getCore(), idBytes, null, updatedFields, RealTimeGetComponent.Resolution.DOC);
        if (oldDocument == RealTimeGetComponent.DELETED || oldDocument == null) {
            return false;
        }
        if (!oldDocument.containsKey((Object)"_version_")) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "There is no _version_ in previous document. id=" + cmd.getPrintableId());
        }
        Long oldVersion = (Long)oldDocument.remove((Object)"_version_").getValue();
        if (updatedFields != null) {
            HashSet names = new HashSet(oldDocument.getFieldNames());
            for (String fieldName : names) {
                if (fieldName.equals("_version_") || fieldName.equals("id") || updatedFields.contains(fieldName)) continue;
                oldDocument.remove((Object)fieldName);
            }
        }
        SolrInputDocument partialDoc = new SolrInputDocument(new String[0]);
        String uniqueKeyField = this.schema.getUniqueKeyField().getName();
        for (String fieldName : oldDocument.getFieldNames()) {
            SchemaField schemaField = this.schema.getField(fieldName);
            if (!fieldName.equals(uniqueKeyField) && !AtomicUpdateDocumentMerger.isSupportedFieldForInPlaceUpdate(schemaField)) continue;
            partialDoc.addField(fieldName, oldDocument.getFieldValue(fieldName));
        }
        this.merge(inputDoc, partialDoc);
        if (!partialDoc.containsKey((Object)this.schema.getUniqueKeyField().getName())) {
            partialDoc.addField(this.idField.getName(), inputDoc.getField(this.schema.getUniqueKeyField().getName()).getFirstValue());
        }
        cmd.prevVersion = oldVersion;
        cmd.solrDoc = partialDoc;
        return true;
    }

    public SolrInputDocument mergeChildDoc(SolrInputDocument sdoc, SolrInputDocument oldDocWithChildren, SolrInputDocument sdocWithChildren) {
        String updatedDocPath = (String)sdocWithChildren.getFieldValue("_nest_path_");
        SolrInputField sifToReplace = AtomicUpdateDocumentMerger.getFieldFromHierarchy(oldDocWithChildren, updatedDocPath);
        this.updateDocInSif(sifToReplace, sdocWithChildren, sdoc);
        return oldDocWithChildren;
    }

    public SolrInputDocument updateDocInSif(SolrInputField updateSif, SolrInputDocument cmdDocWChildren, SolrInputDocument updateDoc) {
        List sifToReplaceValues = (List)updateSif.getValues();
        boolean wasList = updateSif.getValue() instanceof Collection;
        int index = AtomicUpdateDocumentMerger.getDocIndexFromCollection(cmdDocWChildren, sifToReplaceValues);
        SolrInputDocument updatedDoc = this.merge(updateDoc, cmdDocWChildren);
        if (index == -1) {
            sifToReplaceValues.add(updatedDoc);
        } else {
            sifToReplaceValues.set(index, updatedDoc);
        }
        boolean singleVal = !wasList && sifToReplaceValues.size() <= 1;
        updateSif.setValue(singleVal ? sifToReplaceValues.get(0) : sifToReplaceValues);
        return cmdDocWChildren;
    }

    protected void doSet(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        String name = sif.getName();
        toDoc.setField(name, this.getNativeFieldValue(name, fieldVal));
    }

    protected void doAdd(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        String name = sif.getName();
        toDoc.addField(name, this.getNativeFieldValue(name, fieldVal));
    }

    protected void doAddDistinct(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        String name = sif.getName();
        SolrInputField existingField = toDoc.get((Object)name);
        SchemaField sf = this.schema.getField(name);
        Collection original = existingField != null ? existingField.getValues() : new ArrayList();
        int initialSize = original.size();
        if (fieldVal instanceof Collection) {
            for (Object object : (Collection)fieldVal) {
                Object obj = sf.getType().toNativeType(object);
                if (original.contains(obj)) continue;
                original.add(obj);
            }
        } else {
            Object object = sf.getType().toNativeType(fieldVal);
            if (!original.contains(object)) {
                original.add(object);
            }
        }
        if (original.size() > initialSize) {
            if (original.size() == 1) {
                this.doAdd(toDoc, sif, original.toArray()[0]);
            } else {
                toDoc.setField(name, (Object)original);
            }
        }
    }

    protected void doInc(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        SolrInputField numericField = toDoc.get((Object)sif.getName());
        SchemaField sf = this.schema.getField(sif.getName());
        if (numericField != null || sf.getDefaultValue() != null) {
            String oldValS = numericField != null ? numericField.getFirstValue().toString() : sf.getDefaultValue().toString();
            BytesRefBuilder term = new BytesRefBuilder();
            sf.getType().readableToIndexed(oldValS, term);
            Object oldVal = sf.getType().toObject(sf, term.get());
            String fieldValS = fieldVal.toString();
            Number result = oldVal instanceof Long ? (Number)((Long)oldVal + Long.parseLong(fieldValS)) : (Number)(oldVal instanceof Float ? (Number)Float.valueOf(((Float)oldVal).floatValue() + Float.parseFloat(fieldValS)) : (Number)(oldVal instanceof Double ? (Number)((Double)oldVal + Double.parseDouble(fieldValS)) : (Number)((Integer)oldVal + Integer.parseInt(fieldValS))));
            toDoc.setField(sif.getName(), (Object)result);
        } else {
            toDoc.setField(sif.getName(), fieldVal);
        }
    }

    protected void doRemove(SolrInputDocument toDoc, SolrInputField sif, Object fieldVal) {
        String name = sif.getName();
        SolrInputField existingField = toDoc.get((Object)name);
        if (existingField == null) {
            return;
        }
        Collection original = existingField.getValues();
        if (fieldVal instanceof Collection) {
            for (Object object : (Collection)fieldVal) {
                this.removeObj(original, object, name);
            }
        } else {
            this.removeObj(original, fieldVal, name);
        }
        toDoc.setField(name, (Object)original);
    }

    protected void doRemoveRegex(SolrInputDocument toDoc, SolrInputField sif, Object valuePatterns) {
        String name = sif.getName();
        SolrInputField existingField = toDoc.get((Object)name);
        if (existingField != null) {
            HashSet valueToRemove = new HashSet();
            Collection original = existingField.getValues();
            Collection<Pattern> patterns = this.preparePatterns(valuePatterns);
            for (Object value : original) {
                for (Pattern pattern : patterns) {
                    Matcher m = pattern.matcher(value.toString());
                    if (!m.matches()) continue;
                    valueToRemove.add(value);
                }
            }
            original.removeAll(valueToRemove);
            toDoc.setField(name, (Object)original);
        }
    }

    private Collection<Pattern> preparePatterns(Object fieldVal) {
        LinkedHashSet<Pattern> patterns = new LinkedHashSet<Pattern>(1);
        if (fieldVal instanceof Collection) {
            Collection patternVals = (Collection)fieldVal;
            for (Object patternVal : patternVals) {
                patterns.add(Pattern.compile(patternVal.toString()));
            }
        } else {
            patterns.add(Pattern.compile(fieldVal.toString()));
        }
        return patterns;
    }

    private Object getNativeFieldValue(String fieldName, Object val) {
        if (AtomicUpdateDocumentMerger.isChildDoc(val) || val == null || val instanceof Collection && ((Collection)val).isEmpty()) {
            return val;
        }
        SchemaField sf = this.schema.getField(fieldName);
        return sf.getType().toNativeType(val);
    }

    private static boolean isChildDoc(Object obj) {
        if (!(obj instanceof Collection)) {
            return obj instanceof SolrDocumentBase;
        }
        Collection objValues = (Collection)obj;
        if (objValues.size() == 0) {
            return false;
        }
        return objValues.iterator().next() instanceof SolrDocumentBase;
    }

    private void removeObj(Collection original, Object toRemove, String fieldName) {
        if (AtomicUpdateDocumentMerger.isChildDoc(toRemove)) {
            AtomicUpdateDocumentMerger.removeChildDoc(original, (SolrInputDocument)toRemove);
        } else {
            original.remove(this.getNativeFieldValue(fieldName, toRemove));
        }
    }

    private static void removeChildDoc(Collection original, SolrInputDocument docToRemove) {
        for (SolrInputDocument doc : original) {
            if (!AtomicUpdateDocumentMerger.isDerivedFromDoc(doc, docToRemove)) continue;
            original.remove(doc);
            return;
        }
    }

    private static int getDocIndexFromCollection(SolrInputDocument doc, List<SolrInputDocument> col) {
        for (int i = 0; i < col.size(); ++i) {
            if (!AtomicUpdateDocumentMerger.isDerivedFromDoc(col.get(i), doc)) continue;
            return i;
        }
        return -1;
    }

    private static Pair<String, Integer> getPathAndIndexFromNestPath(String nestPath) {
        List splitPath = StrUtils.splitSmart((String)nestPath, (char)'#');
        if (splitPath.size() == 1) {
            return Pair.of(splitPath.get(0), (Object)0);
        }
        return Pair.of(splitPath.get(0), (Object)Integer.parseInt((String)splitPath.get(1)));
    }
}

