/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.MultiValuedLongFieldSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.schema.DatePointFieldSource;
import org.apache.solr.schema.DateValueFieldType;
import org.apache.solr.schema.NumberType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.QParser;
import org.apache.solr.uninverting.UninvertingReader;
import org.apache.solr.util.DateMathParser;

public class DatePointField
extends PointField
implements DateValueFieldType {
    public DatePointField() {
        this.type = NumberType.DATE;
    }

    @Override
    public Object toNativeType(Object val) {
        if (val instanceof CharSequence) {
            return DateMathParser.parseMath(null, val.toString());
        }
        return super.toNativeType(val);
    }

    @Override
    public Query getPointRangeQuery(QParser parser, SchemaField field, String min, String max, boolean minInclusive, boolean maxInclusive) {
        long actualMax;
        long actualMin;
        if (min == null) {
            actualMin = Long.MIN_VALUE;
        } else {
            actualMin = DateMathParser.parseMath(null, min).getTime();
            if (!minInclusive) {
                if (actualMin == Long.MAX_VALUE) {
                    return new MatchNoDocsQuery();
                }
                ++actualMin;
            }
        }
        if (max == null) {
            actualMax = Long.MAX_VALUE;
        } else {
            actualMax = DateMathParser.parseMath(null, max).getTime();
            if (!maxInclusive) {
                if (actualMax == Long.MIN_VALUE) {
                    return new MatchNoDocsQuery();
                }
                --actualMax;
            }
        }
        return LongPoint.newRangeQuery((String)field.getName(), (long)actualMin, (long)actualMax);
    }

    @Override
    public Object toObject(SchemaField sf, BytesRef term) {
        return new Date(LongPoint.decodeDimension((byte[])term.bytes, (int)term.offset));
    }

    @Override
    public Object toObject(IndexableField f) {
        Number val = f.numericValue();
        if (val != null) {
            return new Date(val.longValue());
        }
        throw new AssertionError((Object)("Unexpected state. Field: '" + f + "'"));
    }

    @Override
    protected Query getExactQuery(SchemaField field, String externalVal) {
        return LongPoint.newExactQuery((String)field.getName(), (long)DateMathParser.parseMath(null, externalVal).getTime());
    }

    @Override
    public Query getSetQuery(QParser parser, SchemaField field, Collection<String> externalVals) {
        assert (externalVals.size() > 0);
        if (!field.indexed()) {
            return super.getSetQuery(parser, field, externalVals);
        }
        long[] values = new long[externalVals.size()];
        int i = 0;
        for (String val : externalVals) {
            values[i] = DateMathParser.parseMath(null, val).getTime();
            ++i;
        }
        return LongPoint.newSetQuery((String)field.getName(), (long[])values);
    }

    @Override
    protected String indexedToReadable(BytesRef indexedForm) {
        return Instant.ofEpochMilli(LongPoint.decodeDimension((byte[])indexedForm.bytes, (int)indexedForm.offset)).toString();
    }

    @Override
    public void readableToIndexed(CharSequence val, BytesRefBuilder result) {
        Date date = (Date)this.toNativeType(val.toString());
        result.grow(8);
        result.setLength(8);
        LongPoint.encodeDimension((long)date.getTime(), (byte[])result.bytes(), (int)0);
    }

    @Override
    public UninvertingReader.Type getUninversionType(SchemaField sf) {
        if (sf.multiValued()) {
            return null;
        }
        return UninvertingReader.Type.LONG_POINT;
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser parser) {
        field.checkFieldCacheSource();
        return new DatePointFieldSource(field.getName());
    }

    @Override
    protected ValueSource getSingleValueSource(SortedNumericSelector.Type choice, SchemaField field) {
        return new MultiValuedLongFieldSource(field.getName(), choice);
    }

    @Override
    public IndexableField createField(SchemaField field, Object value) {
        Date date = value instanceof Date ? (Date)value : DateMathParser.parseMath(null, value.toString());
        return new LongPoint(field.getName(), new long[]{date.getTime()});
    }

    @Override
    protected StoredField getStoredField(SchemaField sf, Object value) {
        return new StoredField(sf.getName(), ((Date)this.toNativeType(value)).getTime());
    }
}

