/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.toolbox;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Substring
implements CharSequence {
    private static final Pattern RE_NL = Pattern.compile("(\\r?\\n)");
    @NotNull
    private final String myString;
    private final int myStartOffset;
    private final int myEndOffset;

    public Substring(@NotNull String s) {
        if (s == null) {
            Substring.$$$reportNull$$$0(0);
        }
        this(s, 0, s.length());
    }

    public Substring(@NotNull String s, int start, int end) {
        if (s == null) {
            Substring.$$$reportNull$$$0(1);
        }
        this.myString = s;
        this.myStartOffset = start;
        this.myEndOffset = end;
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return this.toString().equals(o);
        }
        if (o instanceof Substring) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.getValue();
        if (string == null) {
            Substring.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getValue() {
        String string = this.getTextRange().substring(this.myString);
        if (string == null) {
            Substring.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getSuperString() {
        String string = this.myString;
        if (string == null) {
            Substring.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = TextRange.create((int)this.myStartOffset, (int)this.myEndOffset);
        if (textRange == null) {
            Substring.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @NotNull
    public List<Substring> split(@NotNull String regex) {
        if (regex == null) {
            Substring.$$$reportNull$$$0(6);
        }
        List<Substring> list = this.split(regex, Integer.MAX_VALUE);
        if (list == null) {
            Substring.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public List<Substring> split(@NotNull String regex, int maxSplits) {
        if (regex == null) {
            Substring.$$$reportNull$$$0(8);
        }
        List<Substring> list = this.split(Pattern.compile(regex), maxSplits);
        if (list == null) {
            Substring.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<Substring> split(@NotNull Pattern pattern) {
        if (pattern == null) {
            Substring.$$$reportNull$$$0(10);
        }
        List<Substring> list = this.split(pattern, Integer.MAX_VALUE);
        if (list == null) {
            Substring.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<Substring> split(@NotNull Pattern pattern, int maxSplits) {
        if (pattern == null) {
            Substring.$$$reportNull$$$0(12);
        }
        ArrayList<Substring> result = new ArrayList<Substring>();
        Matcher m = pattern.matcher(this.myString);
        int start = this.myStartOffset;
        int end = this.myEndOffset;
        int splitCount = 0;
        if (m.find(start)) {
            do {
                end = m.start();
                result.add(this.createAnotherSubstring(start, Math.min(end, this.myEndOffset)));
                start = m.end();
            } while (end < this.myEndOffset && m.find() && ++splitCount < maxSplits);
            if (start <= this.myEndOffset) {
                result.add(this.createAnotherSubstring(start, this.myEndOffset));
            }
        } else {
            result.add(this.createAnotherSubstring(start, end));
        }
        ArrayList<Substring> arrayList = result;
        if (arrayList == null) {
            Substring.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public List<Substring> splitLines() {
        List<Substring> list = this.split(RE_NL);
        if (list == null) {
            Substring.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    public Substring trim() {
        Substring substring = this.trimLeft().trimRight();
        if (substring == null) {
            Substring.$$$reportNull$$$0(15);
        }
        return substring;
    }

    @NotNull
    public Substring trimLeft() {
        int start;
        for (start = this.myStartOffset; start < this.myEndOffset && this.myString.charAt(start) <= ' '; ++start) {
        }
        return this.createAnotherSubstring(start, this.myEndOffset);
    }

    @NotNull
    public Substring trimRight() {
        int end;
        for (end = this.myEndOffset - 1; end > this.myStartOffset && this.myString.charAt(end) <= ' '; --end) {
        }
        return this.createAnotherSubstring(this.myStartOffset, end + 1);
    }

    @NotNull
    public Substring getMatcherGroup(@NotNull Matcher m, int group2) {
        if (m == null) {
            Substring.$$$reportNull$$$0(16);
        }
        Substring substring = this.substring(m.start(group2), m.end(group2));
        if (substring == null) {
            Substring.$$$reportNull$$$0(17);
        }
        return substring;
    }

    @Override
    public int length() {
        return this.myEndOffset - this.myStartOffset;
    }

    @Override
    public boolean isEmpty() {
        return this.length() <= 0;
    }

    @Override
    public char charAt(int i) {
        return this.myString.charAt(this.myStartOffset + i);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public boolean startsWith(@NotNull String prefix) {
        if (prefix == null) {
            Substring.$$$reportNull$$$0(18);
        }
        return this.indexOf(prefix) == 0;
    }

    public boolean endsWith(@NotNull String prefix) {
        if (prefix == null) {
            Substring.$$$reportNull$$$0(19);
        }
        return this.myString.lastIndexOf(prefix) == this.length() - prefix.length();
    }

    public int indexOf(@NotNull String s) {
        int n;
        if (s == null) {
            Substring.$$$reportNull$$$0(20);
        }
        return (n = this.myString.indexOf(s, this.myStartOffset)) >= 0 && n < this.myEndOffset ? n - this.myStartOffset : -1;
    }

    public boolean contains(@NotNull String s) {
        if (s == null) {
            Substring.$$$reportNull$$$0(21);
        }
        return this.indexOf(s) >= 0;
    }

    @NotNull
    public Substring substring(int start) {
        Substring substring = this.substring(start, this.length());
        if (substring == null) {
            Substring.$$$reportNull$$$0(22);
        }
        return substring;
    }

    @NotNull
    public Substring substring(int start, int end) {
        return this.createAnotherSubstring(this.myStartOffset + start, this.myStartOffset + end);
    }

    @NotNull
    public String concatTrimmedLines(@NotNull String separator) {
        if (separator == null) {
            Substring.$$$reportNull$$$0(23);
        }
        StringBuilder b = new StringBuilder();
        List<Substring> lines = this.splitLines();
        int n = lines.size();
        for (int i = 0; i < n; ++i) {
            b.append(lines.get(i).trim().toString());
            if (i >= n - 1) continue;
            b.append(separator);
        }
        String string = b.toString();
        if (string == null) {
            Substring.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    private Substring createAnotherSubstring(int start, int end) {
        return new Substring(this.myString, start, end);
    }

    @NotNull
    public Substring union(@NotNull Substring other) {
        if (other == null) {
            Substring.$$$reportNull$$$0(25);
        }
        if (!this.myString.equals(other.myString)) {
            throw new IllegalArgumentException(String.format("Substrings '%s' and '%s' must belong to the same origin", this, other));
        }
        TextRange unionRange = this.getTextRange().union(other.getTextRange());
        return new Substring(this.getSuperString(), unionRange.getStartOffset(), unionRange.getEndOffset());
    }

    public int getStartOffset() {
        return this.myStartOffset;
    }

    public int getStartLine() {
        return StringUtil.offsetToLineNumber((CharSequence)this.myString, (int)this.myStartOffset);
    }

    public int getEndOffset() {
        return this.myEndOffset;
    }

    public int getEndLine() {
        return StringUtil.offsetToLineNumber((CharSequence)this.myString, (int)this.myEndOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 22: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 22: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/toolbox/Substring";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/toolbox/Substring";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "splitLines";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatcherGroup";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "substring";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "concatTrimmedLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 22: 
            case 24: {
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getMatcherGroup";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "concatTrimmedLines";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 22: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

