/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.suggestionList;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.python.suggestionList.Suggestion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SuggestionsBuilder {
    private static final MySuggestionComparator SUGGESTION_COMPARATOR = new MySuggestionComparator();
    @NotNull
    private final List<Suggestion> myPrefixGroup;
    @NotNull
    private final List<Suggestion> myMainGroup;
    @NotNull
    private List<Suggestion> myCurrentGroup;

    public SuggestionsBuilder() {
        this.myPrefixGroup = new ArrayList<Suggestion>();
        this.myMainGroup = new ArrayList<Suggestion>();
        this.myCurrentGroup = this.myMainGroup;
    }

    public SuggestionsBuilder(@NotNull List<String> words) {
        if (words == null) {
            SuggestionsBuilder.$$$reportNull$$$0(0);
        }
        this.myPrefixGroup = new ArrayList<Suggestion>();
        this.myMainGroup = new ArrayList<Suggestion>();
        this.myCurrentGroup = this.myMainGroup;
        this.add(words);
    }

    public SuggestionsBuilder changeGroup(boolean main) {
        this.myCurrentGroup = main ? this.myMainGroup : this.myPrefixGroup;
        return this;
    }

    public final SuggestionsBuilder add(String ... words) {
        if (words == null) {
            SuggestionsBuilder.$$$reportNull$$$0(1);
        }
        return this.add(Arrays.asList(words));
    }

    public final SuggestionsBuilder add(@NotNull Collection<String> words) {
        if (words == null) {
            SuggestionsBuilder.$$$reportNull$$$0(2);
        }
        for (String word : words) {
            this.add(word, false);
        }
        return this;
    }

    public SuggestionsBuilder add(@NotNull String text2, boolean strong) {
        if (text2 == null) {
            SuggestionsBuilder.$$$reportNull$$$0(3);
        }
        this.myCurrentGroup.add(new Suggestion(text2, strong));
        this.myCurrentGroup.sort(SUGGESTION_COMPARATOR);
        return this;
    }

    @NotNull
    List<List<Suggestion>> getList() {
        ImmutableList immutableList = ContainerUtil.immutableList((Object[])new List[]{this.myPrefixGroup, this.myMainGroup});
        if (immutableList == null) {
            SuggestionsBuilder.$$$reportNull$$$0(4);
        }
        return immutableList;
    }

    public String toString() {
        return "SuggestionsBuilder{myPrefixGroup=" + this.myPrefixGroup + ", myMainGroup=" + this.myMainGroup + ", myCurrentGroup=" + this.myCurrentGroup + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SuggestionsBuilder)) {
            return false;
        }
        SuggestionsBuilder builder = (SuggestionsBuilder)o;
        if (!this.myPrefixGroup.equals(builder.myPrefixGroup)) {
            return false;
        }
        return this.myMainGroup.equals(builder.myMainGroup);
    }

    public int hashCode() {
        int result = this.myPrefixGroup.hashCode();
        result = 31 * result + this.myMainGroup.hashCode();
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/suggestionList/SuggestionsBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/suggestionList/SuggestionsBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySuggestionComparator
    implements Comparator<Suggestion> {
        private MySuggestionComparator() {
        }

        @Override
        public int compare(Suggestion o1, Suggestion o2) {
            return o1.getText().compareTo(o2.getText());
        }
    }
}

