/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.add;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.ComboBoxWithWidePopup;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.BasePySdkExtKt;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkSettings;
import com.jetbrains.python.sdk.PySdkToInstall;
import com.jetbrains.python.sdk.add.PyAddNewEnvPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanel;
import com.jetbrains.python.sdk.add.PyAddSdkPanelKt;
import com.jetbrains.python.sdk.add.PySdkPathChoosingComboBox;
import icons.PythonIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J\n\u0010+\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010,\u001a\u0004\u0018\u00010\u00052\u0006\u0010 \u001a\u00020\n2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020.0\u0007H\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0012R\u0011\u0010 \u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0012R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010$\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0012\u00a8\u0006/"}, d2={"Lcom/jetbrains/python/sdk/add/PyAddNewVirtualEnvPanel;", "Lcom/jetbrains/python/sdk/add/PyAddNewEnvPanel;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "existingSdks", "", "Lcom/intellij/openapi/projectRoots/Sdk;", "newProjectPath", "", "context", "Lcom/intellij/openapi/util/UserDataHolder;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Ljava/util/List;Ljava/lang/String;Lcom/intellij/openapi/util/UserDataHolder;)V", "baseSdkField", "Lcom/jetbrains/python/sdk/add/PySdkPathChoosingComboBox;", "envName", "getEnvName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "inheritSitePackagesField", "Lcom/intellij/ui/components/JBCheckBox;", "makeSharedField", "value", "getNewProjectPath", "setNewProjectPath", "(Ljava/lang/String;)V", "panelName", "getPanelName", "path", "getPath", "pathField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "projectBasePath", "Lorg/jetbrains/annotations/SystemIndependent;", "getProjectBasePath", "addChangeListener", "", "listener", "Ljava/lang/Runnable;", "getOrCreateSdk", "moduleToExcludeSdkFrom", "validateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.python.community.impl"})
public final class PyAddNewVirtualEnvPanel
extends PyAddNewEnvPanel {
    @NotNull
    private final String envName = "Virtualenv";
    @Nullable
    private String newProjectPath;
    @NotNull
    private final Icon icon;
    private final PySdkPathChoosingComboBox baseSdkField;
    private final TextFieldWithBrowseButton pathField;
    private final JBCheckBox inheritSitePackagesField;
    private final JBCheckBox makeSharedField;
    private final Project project;
    private final Module module;
    private final List<Sdk> existingSdks;
    private final UserDataHolder context;

    @Override
    @NotNull
    public String getEnvName() {
        return this.envName;
    }

    @Override
    @Nullable
    public String getNewProjectPath() {
        return this.newProjectPath;
    }

    @Override
    public void setNewProjectPath(@Nullable String value) {
        this.newProjectPath = value;
        this.pathField.setText(FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(this.getProjectBasePath())));
    }

    @NotNull
    public final String getPath() {
        String string = this.pathField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pathField.text");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string3)).toString();
    }

    @Override
    @NotNull
    public String getPanelName() {
        String string = PyBundle.message("python.add.sdk.panel.name.new.environment", new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PyBundle.message(\"python\u2026el.name.new.environment\")");
        return string;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public List<ValidationInfo> validateAll() {
        return CollectionsKt.listOfNotNull((Object[])new ValidationInfo[]{PyAddSdkPanel.Companion.validateEnvironmentDirectoryLocation(this.pathField), PyAddSdkPanel.Companion.validateSdkComboBox(this.baseSdkField, this)});
    }

    @Override
    @Nullable
    public Sdk getOrCreateSdk() {
        String string = this.pathField.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pathField.text");
        String root = string;
        Sdk sdk = this.baseSdkField.getSelectedSdk();
        boolean bl = false;
        boolean bl2 = false;
        Sdk it = sdk;
        boolean bl3 = false;
        Sdk baseSdk = it instanceof PySdkToInstall ? (Sdk)((PySdkToInstall)it).install(this.module, (Function0<? extends List<? extends PyDetectedSdk>>)((Function0)new Function0<List<? extends PyDetectedSdk>>(this){
            final /* synthetic */ PyAddNewVirtualEnvPanel this$0;
            {
                this.this$0 = pyAddNewVirtualEnvPanel;
                super(0);
            }

            @NotNull
            public final List<PyDetectedSdk> invoke() {
                return PySdkExtKt.detectSystemWideSdks(PyAddNewVirtualEnvPanel.access$getModule$p(this.this$0), PyAddNewVirtualEnvPanel.access$getExistingSdks$p(this.this$0), PyAddNewVirtualEnvPanel.access$getContext$p(this.this$0));
            }
        })) : it;
        if (baseSdk == null) {
            return null;
        }
        Task.WithResult<String, ExecutionException> task2 = new Task.WithResult<String, ExecutionException>(this, baseSdk, root, this.project, PyBundle.message("python.sdk.creating.virtualenv.title", new Object[0]), false){
            final /* synthetic */ PyAddNewVirtualEnvPanel this$0;
            final /* synthetic */ Sdk $baseSdk;
            final /* synthetic */ String $root;

            @NotNull
            protected String compute(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setIndeterminate(true);
                PyPackageManager pyPackageManager = PyPackageManager.getInstance(this.$baseSdk);
                Intrinsics.checkExpressionValueIsNotNull((Object)pyPackageManager, (String)"PyPackageManager.getInstance(baseSdk)");
                PyPackageManager packageManager = pyPackageManager;
                String string = packageManager.createVirtualEnv(this.$root, PyAddNewVirtualEnvPanel.access$getInheritSitePackagesField$p(this.this$0).isSelected());
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageManager.createVir\u2026PackagesField.isSelected)");
                return string;
            }
            {
                this.this$0 = $outer;
                this.$baseSdk = $captured_local_variable$1;
                this.$root = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
        boolean shared = this.makeSharedField.isSelected();
        String associatedPath = !shared ? this.getProjectBasePath() : null;
        Sdk sdk2 = PySdkExtKt.createSdkByGenerateTask((Task.WithResult<String, ExecutionException>)((Task.WithResult)task2), this.existingSdks, baseSdk, associatedPath, null);
        if (sdk2 == null) {
            return null;
        }
        Sdk sdk3 = sdk2;
        if (!shared) {
            PySdkExtKt.associateWithModule(sdk3, this.module, this.getNewProjectPath());
        }
        Module module = this.moduleToExcludeSdkFrom(root, this.project);
        if (module != null) {
            PySdkExtKt.excludeInnerVirtualEnv(module, sdk3);
        }
        PySdkSettings pySdkSettings = PySdkSettings.Companion.getInstance();
        boolean bl4 = false;
        boolean bl5 = false;
        PySdkSettings $this$with = pySdkSettings;
        boolean bl6 = false;
        String string2 = FileUtil.toSystemIndependentName((String)this.pathField.getText());
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FileUtil.toSystemIndependentName(pathField.text)");
        $this$with.setPreferredVirtualEnvBasePath(string2, this.getProjectBasePath());
        $this$with.setPreferredVirtualEnvBaseSdk(baseSdk.getHomePath());
        return sdk3;
    }

    @Override
    public void addChangeListener(@NotNull Runnable listener2) {
        Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
        JTextField jTextField = this.pathField.getTextField();
        Intrinsics.checkExpressionValueIsNotNull((Object)jTextField, (String)"pathField.textField");
        jTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(listener2){
            final /* synthetic */ Runnable $listener;

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                this.$listener.run();
            }
            {
                this.$listener = $captured_local_variable$0;
            }
        });
        ((ComboBoxWithWidePopup)this.baseSdkField.getChildComponent()).addItemListener(new ItemListener(listener2){
            final /* synthetic */ Runnable $listener;

            public final void itemStateChanged(ItemEvent it) {
                this.$listener.run();
            }
            {
                this.$listener = runnable;
            }
        });
    }

    private final Module moduleToExcludeSdkFrom(String path, Project project) {
        List list;
        if (project != null) {
            list = CollectionsKt.listOf((Object)project);
        } else {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            Object[] objectArray = projectManager.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ProjectManager.getInstance().openProjects");
            list = ArraysKt.asList((Object[])objectArray);
        }
        List possibleProjects = list;
        VirtualFile virtualFile = StandardFileSystems.local().refreshAndFindFileByPath(path);
        if (virtualFile == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"StandardFileSystems.loca\u2026Path(path) ?: return null");
        VirtualFile rootFile = virtualFile;
        return (Module)SequencesKt.firstOrNull((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)possibleProjects), (Function1)((Function1)new Function1<Project, Module>(rootFile){
            final /* synthetic */ VirtualFile $rootFile;

            @Nullable
            public final Module invoke(@NotNull Project it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return ModuleUtil.findModuleForFile((VirtualFile)this.$rootFile, (Project)it);
            }
            {
                this.$rootFile = virtualFile;
                super(1);
            }
        }))));
    }

    private final String getProjectBasePath() {
        String string;
        String string2 = this.getNewProjectPath();
        if (string2 == null) {
            Module module = this.module;
            string2 = string = module != null ? BasePySdkExtKt.getBasePath(module) : null;
        }
        if (string2 == null) {
            Project project = this.project;
            string = project != null ? project.getBasePath() : null;
        }
        return string;
    }

    public PyAddNewVirtualEnvPanel(@Nullable Project project, @Nullable Module module, @NotNull List<? extends Sdk> existingSdks, @Nullable String newProjectPath, @NotNull UserDataHolder context) {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        Intrinsics.checkParameterIsNotNull(existingSdks, (String)"existingSdks");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.project = project;
        this.module = module;
        this.existingSdks = existingSdks;
        this.context = context;
        this.envName = "Virtualenv";
        this.newProjectPath = newProjectPath;
        Icon icon = PythonIcons.Python.Virtualenv;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"PythonIcons.Python.Virtualenv");
        this.icon = icon;
        this.baseSdkField = new PySdkPathChoosingComboBox(null, null, 3, null);
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        PyAddNewVirtualEnvPanel pyAddNewVirtualEnvPanel = this;
        boolean bl = false;
        boolean bl2 = false;
        TextFieldWithBrowseButton $this$apply = textFieldWithBrowseButton2;
        boolean bl3 = false;
        $this$apply.setText(FileUtil.toSystemDependentName((String)PySdkSettings.Companion.getInstance().getPreferredVirtualEnvBasePath(this.getProjectBasePath())));
        $this$apply.addBrowseFolderListener(PyBundle.message("python.sdk.select.location.for.virtualenv.title", new Object[0]), null, this.project, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        pyAddNewVirtualEnvPanel.pathField = textFieldWithBrowseButton = textFieldWithBrowseButton2;
        this.inheritSitePackagesField = new JBCheckBox(PyBundle.message("sdk.create.venv.dialog.label.inherit.global.site.packages", new Object[0]));
        this.makeSharedField = new JBCheckBox(PyBundle.message("available.to.all.projects", new Object[0]));
        this.setLayout(new BorderLayout());
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addLabeledComponent(PyBundle.message("sdk.create.venv.dialog.label.location", new Object[0]), (JComponent)this.pathField).addLabeledComponent(PyBundle.message("base.interpreter", new Object[0]), (JComponent)((Object)this.baseSdkField)).addComponent((JComponent)this.inheritSitePackagesField).addComponent((JComponent)this.makeSharedField);
        Intrinsics.checkExpressionValueIsNotNull((Object)formBuilder, (String)"FormBuilder.createFormBu\u2026omponent(makeSharedField)");
        JPanel formPanel = formBuilder.getPanel();
        this.add((Component)formPanel, "North");
        PyAddSdkPanelKt.addBaseInterpretersAsync(this.baseSdkField, this.existingSdks, this.module, this.context);
    }

    public static final /* synthetic */ Module access$getModule$p(PyAddNewVirtualEnvPanel $this) {
        return $this.module;
    }

    public static final /* synthetic */ List access$getExistingSdks$p(PyAddNewVirtualEnvPanel $this) {
        return $this.existingSdks;
    }

    public static final /* synthetic */ UserDataHolder access$getContext$p(PyAddNewVirtualEnvPanel $this) {
        return $this.context;
    }

    public static final /* synthetic */ JBCheckBox access$getInheritSitePackagesField$p(PyAddNewVirtualEnvPanel $this) {
        return $this.inheritSitePackagesField;
    }
}

