/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.remote;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteFile;
import com.intellij.util.PathMappingSettings;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class PyRemoteSourceItem {
    private final String myPath;
    private final String myRootPath;
    private final int mySize;
    private String myLocalPrefix = null;

    public PyRemoteSourceItem(String path, String rootPath, int size) {
        this.myPath = path;
        this.myRootPath = rootPath;
        this.mySize = size;
    }

    public boolean shouldCopy(String basePath) {
        File localFile = this.getLocalFile(basePath);
        return this.shouldCopyTo(localFile);
    }

    public boolean shouldCopyTo(File localFile) {
        return !localFile.exists() || localFile.length() != (long)this.getSize();
    }

    public File getLocalFile(String basePath) {
        return new File(basePath, this.getLocalRelativePath());
    }

    public String getPath() {
        return this.myPath;
    }

    public String getRootPath() {
        return this.myRootPath;
    }

    public int getSize() {
        return this.mySize;
    }

    public String getLocalRelativePath() {
        if (this.myLocalPrefix != null) {
            return this.myLocalPrefix + (this.getModule().startsWith("?") ? "" : "/") + this.getModule();
        }
        return this.getModule();
    }

    public String getModule() {
        return this.myPath.substring(this.myRootPath.length());
    }

    public String getArcPath() {
        return this.getLocalRelativePath();
    }

    public void setLocalPrefix(String localPrefix) {
        this.myLocalPrefix = localPrefix = StringUtil.trimEnd((String)localPrefix, (String)"/");
    }

    public String getLocalPrefix() {
        return this.myLocalPrefix;
    }

    public void addRootMappingTo(@NotNull PathMappingSettings settings, @NotNull String sourcesLocalPath) {
        if (settings == null) {
            PyRemoteSourceItem.$$$reportNull$$$0(0);
        }
        if (sourcesLocalPath == null) {
            PyRemoteSourceItem.$$$reportNull$$$0(1);
        }
        settings.addMappingCheckUnique(FileUtil.toCanonicalPath((String)new File(sourcesLocalPath, this.generateRootFolderName()).getAbsolutePath()), this.getRootPath());
    }

    public static String localPathForRemoteRoot(@NotNull String sourcesLocalPath, @NotNull String remoteRoot) {
        if (sourcesLocalPath == null) {
            PyRemoteSourceItem.$$$reportNull$$$0(2);
        }
        if (remoteRoot == null) {
            PyRemoteSourceItem.$$$reportNull$$$0(3);
        }
        return FileUtil.toCanonicalPath((String)new File(sourcesLocalPath, PyRemoteSourceItem.generateRootFolderNameFor(remoteRoot)).getAbsolutePath());
    }

    public String generateRootFolderName() {
        if (this.getPath().equals(this.getRootPath())) {
            return RemoteFile.createRemoteFile((String)this.getPath()).getName();
        }
        return PyRemoteSourceItem.generateRootFolderNameFor(this.getRootPath());
    }

    @NotNull
    private static String generateRootFolderNameFor(String path) {
        String string = String.valueOf(path.hashCode());
        if (string == null) {
            PyRemoteSourceItem.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcesLocalPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/remote/PyRemoteSourceItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/remote/PyRemoteSourceItem";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRootFolderNameFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addRootMappingTo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "localPathForRemoteRoot";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

