/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.stubs.PyDecoratorStub;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyCallableTypeImpl;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDecoratorImpl
extends StubBasedPsiElementBase<PyDecoratorStub>
implements PyDecorator {
    public PyDecoratorImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyDecoratorImpl(PyDecoratorStub stub) {
        super((StubElement)stub, PyElementTypes.DECORATOR_CALL);
    }

    public String getName() {
        QualifiedName qname = this.getQualifiedName();
        return qname != null ? qname.getLastComponent() : null;
    }

    @Override
    @Nullable
    public final PyFunction getTarget() {
        return (PyFunction)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, PyFunction.class);
    }

    @Override
    @Nullable
    public PyExpression getExpression() {
        return (PyExpression)this.findChildByClass(PyExpression.class);
    }

    @Override
    public boolean isBuiltin() {
        ASTNode node = this.getNode().findChildByType(PythonDialectsTokenSetProvider.getInstance().getReferenceExpressionTokens());
        if (node != null) {
            PyReferenceExpression ref = (PyReferenceExpression)node.getPsi();
            PsiElement target = ref.getReference().resolve();
            return PyBuiltinCache.getInstance((PsiElement)this).isBuiltin(target);
        }
        return false;
    }

    @Override
    public boolean hasArgumentList() {
        return this.getExpression() instanceof PyCallExpression;
    }

    @Override
    public PyArgumentList getArgumentList() {
        PyCallExpression callExpr = PyUtil.as(this.getExpression(), PyCallExpression.class);
        return callExpr != null ? callExpr.getArgumentList() : null;
    }

    @Override
    @Nullable
    public QualifiedName getQualifiedName() {
        PyDecoratorStub stub = (PyDecoratorStub)this.getStub();
        if (stub != null) {
            return stub.getQualifiedName();
        }
        PyReferenceExpression refExpr = PyUtil.as(this.getCallee(), PyReferenceExpression.class);
        return refExpr != null ? refExpr.asQualifiedName() : null;
    }

    @Override
    @Nullable
    public PyExpression getCallee() {
        PyExpression exprAfterAt = this.getExpression();
        return exprAfterAt instanceof PyCallExpression ? ((PyCallExpression)exprAfterAt).getCallee() : exprAfterAt;
    }

    @Override
    @NotNull
    public List<PyCallableType> multiResolveCallee(@NotNull PyResolveContext resolveContext, int implicitOffset) {
        if (resolveContext == null) {
            PyDecoratorImpl.$$$reportNull$$$0(0);
        }
        Function mapping = callableType -> {
            if (!this.hasArgumentList()) {
                TypeEvalContext context = resolveContext.getTypeEvalContext();
                return new PyCallableTypeImpl(callableType.getParameters(context), callableType.getReturnType(context), callableType.getCallable(), callableType.getModifier(), callableType.getImplicitOffset() + 1);
            }
            return callableType;
        };
        List list = ContainerUtil.map(PyCallExpressionHelper.multiResolveCallee(this, resolveContext, implicitOffset), (Function)mapping);
        if (list == null) {
            PyDecoratorImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PyCallExpression.PyArgumentsMapping> multiMapArguments(@NotNull PyResolveContext resolveContext, int implicitOffset) {
        if (resolveContext == null) {
            PyDecoratorImpl.$$$reportNull$$$0(2);
        }
        List<PyCallExpression.PyArgumentsMapping> list = PyCallExpressionHelper.multiMapArguments(this, resolveContext, implicitOffset);
        if (list == null) {
            PyDecoratorImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public String toString() {
        return "PyDecorator: @" + PyUtil.getReadableRepr((PsiElement)this.getCallee(), true);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode node;
        ASTNode nameNode;
        if (name == null) {
            PyDecoratorImpl.$$$reportNull$$$0(4);
        }
        if ((nameNode = (node = this.getNode()).findChildByType((IElementType)PyTokenTypes.IDENTIFIER)) != null) {
            ASTNode nameElement = PyUtil.createNewName(this, name);
            node.replaceChild(nameNode, nameElement);
            return this;
        }
        throw new IncorrectOperationException("No name node");
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyDecoratorImpl.$$$reportNull$$$0(5);
        }
        if (key == null) {
            PyDecoratorImpl.$$$reportNull$$$0(6);
        }
        return PyCallExpressionHelper.getCallType(this, context, key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyDecoratorImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyDecoratorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveCallee";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiMapArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveCallee";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "multiMapArguments";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

