/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Consumer;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.AddSelfQuickFix;
import com.jetbrains.python.inspections.quickfix.RenameParameterQuickFix;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyMethodParametersInspection
extends PyInspection {
    public String MCS = "mcs";

    @Nullable
    public static PyMethodParametersInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(0);
        }
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String toolName = PyMethodParametersInspection.class.getSimpleName();
        return (PyMethodParametersInspection)inspectionProfile.getUnwrappedTool(toolName, element);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return PythonUiService.getInstance().createComboBoxWithLabel(PyPsiBundle.message("INSP.method.parameters.metaclass.method.first.argument.name", new Object[0]), new String[]{"mcs", "metacls"}, this.MCS, (Consumer<Object>)((Consumer)item -> {
            this.MCS = (String)item;
        }));
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(1);
        }
        return highlightDisplayLevel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            PyMethodParametersInspection.$$$reportNull$$$0(3);
        }
        return new Visitor(holder, session);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyMethodParametersInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyMethodParametersInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            for (PyInspectionExtension extension : PyInspectionExtension.EP_NAME.getExtensionList()) {
                if (!extension.ignoreMethodParameters(node, this.myTypeEvalContext)) continue;
                return;
            }
            PyUtil.MethodFlags flags = PyUtil.MethodFlags.of(node);
            if (flags != null) {
                PyParameterList plist = node.getParameterList();
                PyParameter[] params = plist.getParameters();
                String methodName = node.getName();
                String CLS = "cls";
                if (params.length == 0) {
                    if (flags.isStaticMethod()) {
                        return;
                    }
                    ASTNode name_node = node.getNameNode();
                    if (name_node != null) {
                        PsiElement open_paren = plist.getFirstChild();
                        PsiElement close_paren = plist.getLastChild();
                        if (open_paren != null && close_paren != null && "(".equals(open_paren.getText()) && ")".equals(close_paren.getText())) {
                            String paramName = flags.isMetaclassMethod() ? (flags.isClassMethod() ? PyMethodParametersInspection.this.MCS : "cls") : (flags.isClassMethod() ? "cls" : "self");
                            this.registerProblem((PsiElement)plist, PyPsiBundle.message("INSP.must.have.first.parameter", paramName), ProblemHighlightType.GENERIC_ERROR, null, new AddSelfQuickFix(paramName));
                        }
                    }
                } else {
                    PyNamedParameter first_param = params[0].getAsNamed();
                    if (first_param != null) {
                        String pname = first_param.getName();
                        if (pname == null) {
                            return;
                        }
                        String[] mangled = new String[]{"eslf", "sself", "elf", "felf", "slef", "seelf", "slf", "sslf", "sefl", "sellf", "sef", "seef"};
                        if (PyUtil.among(pname, mangled)) {
                            this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyPsiBundle.message("INSP.probably.mistyped.self", new Object[0]), new RenameParameterQuickFix("self"));
                            return;
                        }
                        if (flags.isMetaclassMethod()) {
                            String expectedName;
                            if (flags.isStaticMethod() && !"__new__".equals(methodName)) {
                                return;
                            }
                            String alternativeName = null;
                            if ("__new__".equals(methodName) || flags.isClassMethod()) {
                                expectedName = PyMethodParametersInspection.this.MCS;
                            } else if (flags.isSpecialMetaclassMethod()) {
                                expectedName = "cls";
                            } else {
                                expectedName = "self";
                                alternativeName = "cls";
                            }
                            if (!(expectedName.equals(pname) || alternativeName != null && alternativeName.equals(pname))) {
                                this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyPsiBundle.message("INSP.usually.named.$0", expectedName), new RenameParameterQuickFix(expectedName));
                            }
                        } else if (flags.isClassMethod() || "__new__".equals(methodName)) {
                            if (!"cls".equals(pname)) {
                                this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyPsiBundle.message("INSP.usually.named.$0", "cls"), new RenameParameterQuickFix("cls"));
                            }
                        } else if (!(flags.isStaticMethod() || first_param.isPositionalContainer() || "self".equals(pname))) {
                            if (flags.isMetaclassMethod() && "cls".equals(pname)) {
                                return;
                            }
                            this.registerProblem(PyUtil.sure(params[0].getNode()).getPsi(), PyPsiBundle.message("INSP.usually.named.self", new Object[0]), new RenameParameterQuickFix("self"));
                        }
                    } else if (!flags.isStaticMethod()) {
                        this.registerProblem((PsiElement)plist, PyPsiBundle.message("INSP.first.param.must.not.be.tuple", new Object[0]));
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyMethodParametersInspection$Visitor", "<init>"));
        }
    }
}

