/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.PyMoveAttributeToInitQuickFix;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.PythonUnitTestDetectorsKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyAttributeOutsideInitInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, session);
    }

    private static boolean isDefinedByProperty(@NotNull PyTargetExpression attribute, @NotNull Collection<Property> properties, @NotNull Map<String, PyTargetExpression> attributesInInit) {
        if (attribute == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(2);
        }
        if (properties == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(3);
        }
        if (attributesInInit == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(4);
        }
        return ((StreamEx)StreamEx.of(properties).filter(it -> PyAttributeOutsideInitInspection.isSetBy(attribute, it))).anyMatch(it -> attributesInInit.containsKey(it.getName()));
    }

    private static boolean isApplicable(@NotNull PyClass containingClass, @NotNull TypeEvalContext context) {
        if (containingClass == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(6);
        }
        return !PythonUnitTestDetectorsKt.isTestClass(containingClass, context) && !containingClass.isSubclass("django.db.models.base.Model", context);
    }

    @Nullable
    private static Collection<PyTargetExpression> getSetterTargetExpressions(@NotNull Property property) {
        if (property == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(7);
        }
        if (!property.getSetter().isDefined() || property.getSetter().value() == null) {
            return null;
        }
        PyFunction setter = property.getSetter().value().asMethod();
        if (setter == null) {
            return null;
        }
        return ((StreamEx)StreamEx.of(ControlFlowCache.getScope(setter).getTargetExpressions()).filter(PyUtil::isInstanceAttribute)).toList();
    }

    private static boolean isSetBy(@NotNull PyTargetExpression attribute, @NotNull Property property) {
        Collection<PyTargetExpression> propertyTargetExpressions;
        if (attribute == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(8);
        }
        if (property == null) {
            PyAttributeOutsideInitInspection.$$$reportNull$$$0(9);
        }
        return (propertyTargetExpressions = PyAttributeOutsideInitInspection.getSetterTargetExpressions(property)) != null && attribute.getName() != null && StreamEx.of(propertyTargetExpressions).map(targetExpression -> targetExpression.getName()).nonNull().anyMatch(name -> name.equals(attribute.getName()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributesInInit";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefinedByProperty";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSetterTargetExpressions";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isSetBy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class Visitor
    extends PyInspectionVisitor {
        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            PyClass containingClass = node.getContainingClass();
            if (containingClass == null) {
                return;
            }
            String name = node.getName();
            if (name != null && name.startsWith("_")) {
                return;
            }
            if (!PyAttributeOutsideInitInspection.isApplicable(containingClass, this.myTypeEvalContext)) {
                return;
            }
            if (node.getModifier() != null) {
                return;
            }
            Map<String, Property> localProperties = containingClass.getProperties();
            HashMap<String, PyTargetExpression> declaredAttributes = new HashMap<String, PyTargetExpression>();
            HashSet<String> inheritedProperties = new HashSet<String>();
            ((StreamEx)StreamEx.of(containingClass.getClassAttributes()).filter(attribute -> !localProperties.containsKey(attribute.getName()))).forEach(attribute -> declaredAttributes.put(attribute.getName(), (PyTargetExpression)attribute));
            PyFunction initMethod = containingClass.findMethodByName("__init__", false, this.myTypeEvalContext);
            if (initMethod != null) {
                PyClassImpl.collectInstanceAttributes(initMethod, declaredAttributes);
            }
            for (PyClass superClass : containingClass.getAncestorClasses(this.myTypeEvalContext)) {
                PyFunction superInit = superClass.findMethodByName("__init__", false, this.myTypeEvalContext);
                if (superInit != null) {
                    PyClassImpl.collectInstanceAttributes(superInit, declaredAttributes);
                }
                for (PyTargetExpression classAttr : superClass.getClassAttributes()) {
                    declaredAttributes.put(classAttr.getName(), classAttr);
                }
                inheritedProperties.addAll(superClass.getProperties().keySet());
            }
            HashMap<String, PyTargetExpression> attributes = new HashMap<String, PyTargetExpression>();
            PyClassImpl.collectInstanceAttributes(node, attributes);
            for (PyTargetExpression attribute2 : attributes.values()) {
                String attributeName = attribute2.getName();
                if (attributeName == null || declaredAttributes.containsKey(attributeName) || inheritedProperties.contains(attributeName) || localProperties.containsKey(attributeName) || PyAttributeOutsideInitInspection.isDefinedByProperty(attribute2, localProperties.values(), declaredAttributes)) continue;
                this.registerProblem((PsiElement)attribute2, PyPsiBundle.message("INSP.attribute.$0.outside.init", attributeName), new PyMoveAttributeToInitQuickFix());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyAttributeOutsideInitInspection$Visitor", "<init>"));
        }
    }
}

