/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a(\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0002\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0013H\u0002\u001a\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002\u001a\u001a\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0000\u001a\u000e\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f\u001a\u0016\u0010\"\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\"\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010$\u001a\u00020#\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"INLINE_PACKAGE_KEY", "Lcom/intellij/openapi/util/Key;", "", "STUBS_SUFFIX", "", "STUB_PACKAGE_KEY", "convertStubToRuntimePackageName", "Lcom/intellij/psi/util/QualifiedName;", "name", "doTransferStubPackageMarker", "", "resolvedSubdir", "Lcom/intellij/psi/PsiDirectory;", "findStubPackage", "dir", "referencedName", "checkForPackage", "withoutStubs", "getClassOrContentOrSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "getPyTyped", "element", "Lcom/intellij/psi/PsiElement;", "isInInlinePackage", "module", "Lcom/intellij/openapi/module/Module;", "isInStubPackage", "removeRuntimeModulesForWhomStubModulesFound", "", "Lcom/jetbrains/python/psi/resolve/RatedResolveResult;", "resolved", "transferStubPackageMarker", "Lcom/intellij/psi/PsiFile;", "resolvedSubmodule", "intellij.python.psi.impl"})
@JvmName(name="PyStubPackages")
public final class PyStubPackages {
    @NotNull
    public static final String STUBS_SUFFIX = "-stubs";
    private static final Key<Boolean> STUB_PACKAGE_KEY = new Key("PY_STUB_PACKAGE");
    private static final Key<Boolean> INLINE_PACKAGE_KEY = new Key("PY_INLINE_PACKAGE");

    @NotNull
    public static final QualifiedName convertStubToRuntimePackageName(@NotNull QualifiedName name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String top = name.getFirstComponent();
        if (top != null && StringsKt.endsWith$default((String)top, (String)STUBS_SUFFIX, (boolean)false, (int)2, null)) {
            QualifiedName qualifiedName = QualifiedName.fromComponents((String[])new String[]{StringsKt.removeSuffix((String)top, (CharSequence)STUBS_SUFFIX)}).append(name.removeHead(1));
            Intrinsics.checkExpressionValueIsNotNull((Object)qualifiedName, (String)"QualifiedName.fromCompon\u2026ppend(name.removeHead(1))");
            return qualifiedName;
        }
        return name;
    }

    @Nullable
    public static final PsiDirectory findStubPackage(@NotNull PsiDirectory dir, @NotNull String referencedName, boolean checkForPackage, boolean withoutStubs) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)referencedName, (String)"referencedName");
        if (!withoutStubs) {
            VirtualFile virtualFile = dir.getVirtualFile();
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile;
            boolean bl3 = false;
            Project project = dir.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"dir.project");
            VirtualFile virtualFile2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"it");
            if (Intrinsics.areEqual((Object)it, (Object)PyStubPackages.getClassOrContentOrSourceRoot(project, virtualFile2))) {
                PsiDirectory stubPackage;
                String stubPackageName = referencedName + STUBS_SUFFIX;
                PsiDirectory psiDirectory = stubPackage = dir.findSubdirectory(stubPackageName);
                if (Intrinsics.areEqual((Object)(psiDirectory != null ? psiDirectory.getName() : null), (Object)stubPackageName) && (!checkForPackage || PyUtil.isPackage(stubPackage, (PsiElement)dir))) {
                    PyStubPackages.doTransferStubPackageMarker(stubPackage);
                    return stubPackage;
                }
            }
        }
        return null;
    }

    @NotNull
    public static final PsiFile transferStubPackageMarker(@NotNull PsiDirectory dir, @NotNull PsiFile resolvedSubmodule) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)resolvedSubmodule, (String)"resolvedSubmodule");
        if (Intrinsics.areEqual((Object)((Boolean)dir.getUserData(STUB_PACKAGE_KEY)), (Object)true)) {
            resolvedSubmodule.putUserData(STUB_PACKAGE_KEY, (Object)true);
        }
        return resolvedSubmodule;
    }

    @NotNull
    public static final PsiDirectory transferStubPackageMarker(@NotNull PsiDirectory dir, @NotNull PsiDirectory resolvedSubdir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)resolvedSubdir, (String)"resolvedSubdir");
        if (Intrinsics.areEqual((Object)((Boolean)dir.getUserData(STUB_PACKAGE_KEY)), (Object)true)) {
            PyStubPackages.doTransferStubPackageMarker(resolvedSubdir);
        }
        return resolvedSubdir;
    }

    private static final void doTransferStubPackageMarker(PsiDirectory resolvedSubdir) {
        block0: {
            resolvedSubdir.putUserData(STUB_PACKAGE_KEY, (Object)true);
            PsiElement psiElement = PyUtil.turnDirIntoInit((PsiElement)resolvedSubdir);
            if (psiElement == null) break block0;
            psiElement.putUserData(STUB_PACKAGE_KEY, (Object)true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<RatedResolveResult> removeRuntimeModulesForWhomStubModulesFound(@NotNull List<? extends RatedResolveResult> resolved) {
        List list;
        Intrinsics.checkParameterIsNotNull(resolved, (String)"resolved");
        boolean bl = false;
        Set stubPkgModules = new LinkedHashSet();
        Iterable $this$forEach$iv = resolved;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RatedResolveResult it = (RatedResolveResult)element$iv;
            boolean bl2 = false;
            PsiElement stubPkgModule = it.getElement();
            if (!(stubPkgModule instanceof PyiFile) || !Intrinsics.areEqual((Object)((Boolean)stubPkgModule.getUserData(STUB_PACKAGE_KEY)), (Object)true)) continue;
            Collection collection = stubPkgModules;
            String string = ((PyiFile)stubPkgModule).getName();
            boolean bl3 = false;
            collection.add(string);
        }
        if (stubPkgModules.isEmpty()) {
            list = resolved;
        } else {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = resolved;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                RatedResolveResult it = (RatedResolveResult)element$iv$iv;
                boolean bl4 = false;
                PsiElement runtimePkgModule = it.getElement();
                if (runtimePkgModule instanceof PyFile && !(runtimePkgModule instanceof PyiFile) && stubPkgModules.contains(((PyFile)runtimePkgModule).getName() + "i")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private static final VirtualFile getClassOrContentOrSourceRoot(Project project, VirtualFile file) {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectFileIndex, (String)"ProjectFileIndex.getInstance(project)");
        ProjectFileIndex index = projectFileIndex;
        VirtualFile virtualFile = index.getClassRootForFile(file);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            return it;
        }
        VirtualFile virtualFile3 = index.getSourceRootForFile(file);
        if (virtualFile3 != null) {
            VirtualFile virtualFile4 = virtualFile3;
            boolean bl = false;
            boolean bl4 = false;
            VirtualFile it = virtualFile4;
            boolean bl5 = false;
            return it;
        }
        VirtualFile virtualFile5 = index.getContentRootForFile(file);
        if (virtualFile5 != null) {
            VirtualFile virtualFile6 = virtualFile5;
            boolean bl = false;
            boolean bl6 = false;
            VirtualFile it = virtualFile6;
            boolean bl7 = false;
            return it;
        }
        return null;
    }

    public static final boolean isInStubPackage(@NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)((Boolean)element.getUserData(STUB_PACKAGE_KEY)), (Object)true);
    }

    public static final boolean isInInlinePackage(@NotNull PsiElement element, @Nullable Module module) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (module == null) {
            return false;
        }
        Boolean cached = (Boolean)element.getUserData(INLINE_PACKAGE_KEY);
        if (cached != null) {
            return cached;
        }
        boolean result = !PyiUtil.isPyiFileOfPackage(element) && (element instanceof PyFile || PyUtil.turnDirIntoInit(element) instanceof PyFile) && PyStubPackages.getPyTyped(element) != null;
        element.putUserData(INLINE_PACKAGE_KEY, (Object)result);
        return result;
    }

    private static final VirtualFile getPyTyped(PsiElement element) {
        VirtualFile current;
        VirtualFile file;
        Object object;
        if (element == null) {
            return null;
        }
        if (element instanceof PsiFileSystemItem) {
            object = ((PsiFileSystemItem)element).getVirtualFile();
        } else {
            PsiFile psiFile = element.getContainingFile();
            object = file = psiFile != null ? psiFile.getVirtualFile() : null;
        }
        if (file == null) {
            return null;
        }
        Project project = element.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element.project");
        VirtualFile virtualFile = PyStubPackages.getClassOrContentOrSourceRoot(project, file);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile root = virtualFile;
        VirtualFile virtualFile2 = current = file.isDirectory() ? file : file.getParent();
        while (current != null && Intrinsics.areEqual((Object)current, (Object)root) ^ true && current.isDirectory()) {
            VirtualFile pyTyped = current.findChild("py.typed");
            if (pyTyped != null && !pyTyped.isDirectory()) {
                return pyTyped;
            }
            current = current.getParent();
        }
        return null;
    }
}

