/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.service.fus.collectors;

import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.service.fus.collectors.UsagesCollectorConsumer;
import com.intellij.openapi.extensions.ExtensionPointName;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class FeatureUsagesCollector {
    @NonNls
    private static final String GROUP_ID_PATTERN = "([a-zA-Z]*\\.)*[a-zA-Z]*";

    public final boolean isValid() {
        return Pattern.compile(GROUP_ID_PATTERN).matcher(this.getGroupId()).matches();
    }

    protected static <T extends FeatureUsagesCollector> Set<T> getExtensions(@NotNull UsagesCollectorConsumer invoker, ExtensionPointName<T> ep) {
        if (invoker == null) {
            FeatureUsagesCollector.$$$reportNull$$$0(0);
        }
        if (invoker.getClass().getClassLoader() instanceof PluginClassLoader) {
            return Collections.emptySet();
        }
        return ep.extensions().filter(u -> u.isValid()).collect(Collectors.toSet());
    }

    @NonNls
    @NotNull
    public String getGroupId() {
        EventLogGroup group = this.getGroup();
        if (group == null) {
            throw new IllegalStateException("Please override either getGroupId() or getGroup()");
        }
        String string = group.getId();
        if (string == null) {
            FeatureUsagesCollector.$$$reportNull$$$0(1);
        }
        return string;
    }

    public int getVersion() {
        EventLogGroup group = this.getGroup();
        if (group != null) {
            return group.getVersion();
        }
        return 1;
    }

    public EventLogGroup getGroup() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invoker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/service/fus/collectors/FeatureUsagesCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

