/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PlaceholderTextRanges {
    private PlaceholderTextRanges() {
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix) {
        if (s == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(0);
        }
        if (prefix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(1);
        }
        if (suffix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(2);
        }
        return PlaceholderTextRanges.getPlaceholderRanges(s, prefix, suffix, false);
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix, boolean useFullTextRange) {
        if (s == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(4);
        }
        if (suffix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(5);
        }
        return PlaceholderTextRanges.getPlaceholderRanges(s, prefix, suffix, useFullTextRange, false);
    }

    @NotNull
    public static Set<TextRange> getPlaceholderRanges(@NotNull String s, @NotNull String prefix, @NotNull String suffix, boolean useFullTextRange, boolean filterNestedRanges) {
        int nextSuffix;
        int current;
        if (s == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(7);
        }
        if (suffix == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(8);
        }
        if ((current = s.indexOf(prefix)) == -1) {
            Set<TextRange> set = Collections.emptySet();
            if (set == null) {
                PlaceholderTextRanges.$$$reportNull$$$0(9);
            }
            return set;
        }
        LinkedHashSet<TextRange> ranges = new LinkedHashSet<TextRange>(2);
        ArrayDeque<Integer> prefixes = new ArrayDeque<Integer>();
        prefixes.push(current);
        boolean currentPointsAtPrefix = true;
        while (current >= 0 && (nextSuffix = s.indexOf(suffix, currentPointsAtPrefix ? current + prefix.length() : current)) != -1) {
            int nextPrefix = s.indexOf(prefix, current + 1);
            while (nextPrefix > 0 && nextPrefix + prefix.length() <= nextSuffix) {
                prefixes.push(nextPrefix);
                nextPrefix = s.indexOf(prefix, nextPrefix + 1);
            }
            nextPrefix = (Integer)prefixes.pop();
            int startOffset = nextPrefix + (useFullTextRange ? 0 : prefix.length());
            int endOffset = useFullTextRange ? nextSuffix + suffix.length() : nextSuffix;
            TextRange textRange = new TextRange(startOffset, endOffset);
            ranges.add(textRange);
            while (!prefixes.isEmpty() && (Integer)prefixes.peek() + prefix.length() > nextPrefix) {
                prefixes.pop();
            }
            current = s.indexOf(prefix, nextSuffix + suffix.length());
            if (current > 0) {
                prefixes.push(current);
                currentPointsAtPrefix = true;
                continue;
            }
            if (prefixes.isEmpty()) continue;
            current = s.indexOf(suffix, nextSuffix + suffix.length());
            currentPointsAtPrefix = false;
        }
        Set<TextRange> set = filterNestedRanges ? PlaceholderTextRanges.filterNested(ranges) : ranges;
        if (set == null) {
            PlaceholderTextRanges.$$$reportNull$$$0(10);
        }
        return set;
    }

    private static Set<TextRange> filterNested(Set<TextRange> allRanges) {
        LinkedHashSet<TextRange> filtered = new LinkedHashSet<TextRange>(allRanges.size());
        for (TextRange outer : allRanges) {
            boolean contains = PlaceholderTextRanges.anyRangeContains(allRanges, outer);
            if (contains) continue;
            filtered.add(outer);
        }
        return filtered;
    }

    private static boolean anyRangeContains(Set<TextRange> allRanges, TextRange inner) {
        for (TextRange outer : allRanges) {
            if (inner.equals(outer) || !outer.contains(inner)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/PlaceholderTextRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/PlaceholderTextRanges";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderRanges";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

