/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.themes;

import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.tabs.impl.themes.TabTheme;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0006R\u0014\u0010\u001d\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0006R\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0006R\u0014\u0010!\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0006\u00a8\u0006#"}, d2={"Lcom/intellij/ui/tabs/impl/themes/EditorTabTheme;", "Lcom/intellij/ui/tabs/impl/themes/TabTheme;", "()V", "background", "Ljava/awt/Color;", "getBackground", "()Ljava/awt/Color;", "borderColor", "getBorderColor", "globalScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getGlobalScheme", "()Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "hoverBackground", "getHoverBackground", "hoverInactiveBackground", "getHoverInactiveBackground", "inactiveColoredFileBackground", "getInactiveColoredFileBackground", "inactiveUnderlineColor", "getInactiveUnderlineColor", "underlineColor", "getUnderlineColor", "underlineHeight", "", "getUnderlineHeight", "()I", "underlinedTabBackground", "getUnderlinedTabBackground", "underlinedTabForeground", "getUnderlinedTabForeground", "underlinedTabInactiveBackground", "getUnderlinedTabInactiveBackground", "underlinedTabInactiveForeground", "getUnderlinedTabInactiveForeground", "intellij.platform.ide"})
public final class EditorTabTheme
implements TabTheme {
    @NotNull
    public final EditorColorsScheme getGlobalScheme() {
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsManager, (String)"EditorColorsManager.getInstance()");
        EditorColorsScheme editorColorsScheme = editorColorsManager.getGlobalScheme();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"EditorColorsManager.getInstance().globalScheme");
        return editorColorsScheme;
    }

    @Override
    @Nullable
    public Color getBackground() {
        return JBUI.CurrentTheme.EditorTabs.background();
    }

    @Override
    @NotNull
    public Color getBorderColor() {
        Color color = JBUI.CurrentTheme.EditorTabs.borderColor();
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"JBUI.CurrentTheme.EditorTabs.borderColor()");
        return color;
    }

    @Override
    @NotNull
    public Color getUnderlineColor() {
        Color color = this.getGlobalScheme().getColor(EditorColors.TAB_UNDERLINE);
        if (color == null) {
            Color color2 = JBUI.CurrentTheme.EditorTabs.underlineColor();
            color = color2;
            Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"JBUI.CurrentTheme.EditorTabs.underlineColor()");
        }
        return color;
    }

    @Override
    @NotNull
    public Color getInactiveUnderlineColor() {
        Color color = this.getGlobalScheme().getColor(EditorColors.TAB_UNDERLINE_INACTIVE);
        if (color == null) {
            Color color2 = JBUI.CurrentTheme.EditorTabs.inactiveUnderlineColor();
            color = color2;
            Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"JBUI.CurrentTheme.Editor\u2026.inactiveUnderlineColor()");
        }
        return color;
    }

    @Override
    @NotNull
    public Color getHoverBackground() {
        Color color = JBUI.CurrentTheme.EditorTabs.hoverBackground();
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"JBUI.CurrentTheme.EditorTabs.hoverBackground()");
        return color;
    }

    @Override
    @Nullable
    public Color getUnderlinedTabBackground() {
        TextAttributes textAttributes = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED);
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes, (String)"globalScheme.getAttribut\u2026ditorColors.TAB_SELECTED)");
        Color color = textAttributes.getBackgroundColor();
        if (color == null) {
            color = JBUI.CurrentTheme.EditorTabs.underlinedTabBackground();
        }
        return color;
    }

    @Override
    @NotNull
    public Color getUnderlinedTabForeground() {
        TextAttributes textAttributes = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED);
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes, (String)"globalScheme.getAttribut\u2026ditorColors.TAB_SELECTED)");
        Color color = textAttributes.getForegroundColor();
        if (color == null) {
            Color color2 = JBUI.CurrentTheme.EditorTabs.underlinedTabForeground();
            color = color2;
            Intrinsics.checkExpressionValueIsNotNull((Object)color2, (String)"JBUI.CurrentTheme.Editor\u2026underlinedTabForeground()");
        }
        return color;
    }

    @Override
    public int getUnderlineHeight() {
        return JBUI.CurrentTheme.EditorTabs.underlineHeight();
    }

    @Override
    @Nullable
    public Color getHoverInactiveBackground() {
        return this.getHoverBackground();
    }

    @Override
    @Nullable
    public Color getUnderlinedTabInactiveBackground() {
        TextAttributes textAttributes = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED_INACTIVE);
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes, (String)"globalScheme.getAttribut\u2026rs.TAB_SELECTED_INACTIVE)");
        Color color = textAttributes.getBackgroundColor();
        if (color == null) {
            color = this.getUnderlinedTabBackground();
        }
        return color;
    }

    @Override
    @NotNull
    public Color getUnderlinedTabInactiveForeground() {
        TextAttributes textAttributes = this.getGlobalScheme().getAttributes(EditorColors.TAB_SELECTED_INACTIVE);
        Intrinsics.checkExpressionValueIsNotNull((Object)textAttributes, (String)"globalScheme.getAttribut\u2026rs.TAB_SELECTED_INACTIVE)");
        Color color = textAttributes.getForegroundColor();
        if (color == null) {
            color = this.getUnderlinedTabForeground();
        }
        return color;
    }

    @Nullable
    public final Color getInactiveColoredFileBackground() {
        return JBUI.CurrentTheme.EditorTabs.inactiveColoredFileBackground();
    }
}

